/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.spring;

import com.amazonaws.serverless.proxy.AwsHttpApiV2SecurityContextWriter;
import com.amazonaws.serverless.proxy.AwsProxySecurityContextWriter;
import com.amazonaws.serverless.proxy.SecurityContextWriter;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletResponse;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletResponseWriter;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.model.HttpApiV2ProxyRequest;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.springframework.cloud.function.serverless.web.FunctionClassUtils;
import org.springframework.cloud.function.serverless.web.ProxyHttpServletRequest;
import org.springframework.cloud.function.serverless.web.ProxyMvc;
import org.springframework.util.StringUtils;

public class SpringDelegatingLambdaContainerHandler
implements RequestStreamHandler {
    private final Class<?>[] startupClasses;
    private final ProxyMvc mvc;
    private final ObjectMapper mapper;
    private final AwsProxyHttpServletResponseWriter responseWriter;

    public SpringDelegatingLambdaContainerHandler() {
        this(FunctionClassUtils.getStartClass());
    }

    public SpringDelegatingLambdaContainerHandler(Class<?> ... startupClasses) {
        this.startupClasses = startupClasses;
        this.mvc = ProxyMvc.INSTANCE((Class[])this.startupClasses);
        this.mapper = new ObjectMapper();
        this.responseWriter = new AwsProxyHttpServletResponseWriter();
    }

    public void handleRequest(InputStream input, OutputStream output, Context lambdaContext) throws IOException {
        Map request = (Map)this.mapper.readValue(input, Map.class);
        AwsHttpApiV2SecurityContextWriter securityWriter = "2.0".equals(request.get("version")) ? new AwsHttpApiV2SecurityContextWriter() : new AwsProxySecurityContextWriter();
        HttpServletRequest httpServletRequest = "2.0".equals(request.get("version")) ? this.generateRequest2(request, lambdaContext, (SecurityContextWriter)securityWriter) : this.generateRequest(request, lambdaContext, (SecurityContextWriter)securityWriter);
        CountDownLatch latch = new CountDownLatch(1);
        AwsHttpServletResponse httpServletResponse = new AwsHttpServletResponse(httpServletRequest, latch);
        try {
            this.mvc.service(httpServletRequest, (HttpServletResponse)httpServletResponse);
            latch.await(10L, TimeUnit.SECONDS);
            this.mapper.writeValue(output, (Object)this.responseWriter.writeResponse(httpServletResponse, lambdaContext));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private HttpServletRequest generateRequest(Map request, Context lambdaContext, SecurityContextWriter securityWriter) {
        AwsProxyRequest v1Request = (AwsProxyRequest)this.mapper.convertValue((Object)request, AwsProxyRequest.class);
        ProxyHttpServletRequest httpRequest = new ProxyHttpServletRequest(this.mvc.getApplicationContext().getServletContext(), v1Request.getHttpMethod(), v1Request.getPath());
        if (StringUtils.hasText((String)v1Request.getBody())) {
            httpRequest.setContentType("application/json");
            httpRequest.setContent(v1Request.getBody().getBytes(StandardCharsets.UTF_8));
        }
        httpRequest.setAttribute("com.amazonaws.apigateway.request.context", (Object)v1Request.getRequestContext());
        httpRequest.setAttribute("com.amazonaws.apigateway.stage.variables", (Object)v1Request.getStageVariables());
        httpRequest.setAttribute("com.amazonaws.apigateway.request", (Object)v1Request);
        httpRequest.setAttribute("com.amazonaws.alb.request.context", (Object)v1Request.getRequestContext().getElb());
        httpRequest.setAttribute("com.amazonaws.lambda.context", (Object)lambdaContext);
        httpRequest.setAttribute("com.amazonaws.serverless.jaxrs.securityContext", (Object)securityWriter.writeSecurityContext((Object)v1Request, lambdaContext));
        return httpRequest;
    }

    public HttpServletRequest generateRequest2(Map request, Context lambdaContext, SecurityContextWriter securityWriter) {
        HttpApiV2ProxyRequest v2Request = (HttpApiV2ProxyRequest)this.mapper.convertValue((Object)request, HttpApiV2ProxyRequest.class);
        ProxyHttpServletRequest httpRequest = new ProxyHttpServletRequest(this.mvc.getApplicationContext().getServletContext(), v2Request.getRequestContext().getHttp().getMethod(), v2Request.getRequestContext().getHttp().getPath());
        if (StringUtils.hasText((String)v2Request.getBody())) {
            httpRequest.setContentType("application/json");
            httpRequest.setContent(v2Request.getBody().getBytes(StandardCharsets.UTF_8));
        }
        httpRequest.setAttribute("com.amazonaws.httpapi.request.context", (Object)v2Request.getRequestContext());
        httpRequest.setAttribute("com.amazonaws.httpapi.stage.variables", (Object)v2Request.getStageVariables());
        httpRequest.setAttribute("com.amazonaws.httpapi.request", (Object)v2Request);
        httpRequest.setAttribute("com.amazonaws.lambda.context", (Object)lambdaContext);
        httpRequest.setAttribute("com.amazonaws.serverless.jaxrs.securityContext", (Object)securityWriter.writeSecurityContext((Object)v2Request, lambdaContext));
        return httpRequest;
    }
}

