/*
 * Decompiled with CFR 0.152.
 */
package com.amdelamar.jhash;

import com.amdelamar.jhash.algorithms.BCrypt;
import com.amdelamar.jhash.algorithms.PBKDF2;
import com.amdelamar.jhash.algorithms.SCrypt;
import com.amdelamar.jhash.algorithms.Type;
import com.amdelamar.jhash.exception.InvalidHashException;
import com.amdelamar.jhash.util.HashUtils;

public class Hash {
    private static final String SCRYPT = "scrypt";
    private static final String BCRYPT = "bcrypt";
    private static final String PBKDF2_HMACSHA1 = "PBKDF2WithHmacSHA1";
    private static final String PBKDF2_HMACSHA256 = "PBKDF2WithHmacSHA256";
    private static final String PBKDF2_HMACSHA512 = "PBKDF2WithHmacSHA512";
    private static final String HASH_LENGTH_MISMATCH = "Hash length doesn't match stored hash length.";
    private static final int HASH_SECTIONS = 7;
    private static final int HASH_ALGORITHM_INDEX = 0;
    private static final int ITERATION_INDEX = 1;
    private static final int HASH_SIZE_INDEX = 2;
    private static final int SALT_SIZE_INDEX = 3;
    private static final int PEPPER_INDEX = 4;
    private static final int SALT_INDEX = 5;
    private static final int HASH_INDEX = 6;
    private char[] password;
    private byte[] salt;
    private char[] pepper;
    private int hashLength = 0;
    private int saltLength = 0;
    private int factor = 0;
    private Type algorithm = Type.PBKDF2_SHA1;

    public static Hash password(char[] password) {
        if (password == null || password.length < 1) {
            throw new IllegalArgumentException("Password cannot be null or empty.");
        }
        Hash hash = new Hash();
        hash.password = password;
        return hash;
    }

    public Hash salt(byte[] salt) {
        this.salt = salt;
        this.saltLength = salt.length;
        return this;
    }

    public Hash pepper(char[] pepper) {
        this.pepper = pepper;
        return this;
    }

    public Hash hashLength(int hashLength) {
        this.hashLength = hashLength;
        return this;
    }

    public Hash saltLength(int saltLength) {
        if (this.salt == null || this.salt.length <= 0) {
            this.saltLength = saltLength;
        }
        return this;
    }

    public Hash algorithm(Type algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public Hash factor(int factor) {
        this.factor = factor;
        return this;
    }

    public String create() throws IllegalArgumentException {
        char isPeppered = 'n';
        String pepperPassword = new String(this.password);
        if (this.pepper != null && this.pepper.length > 0) {
            isPeppered = 'y';
            pepperPassword = new String(this.pepper) + pepperPassword;
        }
        if (this.algorithm == Type.PBKDF2_SHA1 || this.algorithm == Type.PBKDF2_SHA256 || this.algorithm == Type.PBKDF2_SHA512) {
            String alg = null;
            String alg2 = null;
            if (this.algorithm == Type.PBKDF2_SHA1) {
                alg = PBKDF2_HMACSHA1;
                alg2 = "pbkdf2sha1";
            } else if (this.algorithm == Type.PBKDF2_SHA256) {
                alg = PBKDF2_HMACSHA256;
                alg2 = "pbkdf2sha256";
            } else {
                alg = PBKDF2_HMACSHA512;
                alg2 = "pbkdf2sha512";
            }
            if (this.hashLength <= 0) {
                this.hashLength = 18;
            }
            if (this.salt != null && this.salt.length > 0) {
                this.saltLength = this.salt.length;
            } else {
                if (this.saltLength <= 0) {
                    this.saltLength = 24;
                }
                this.salt = HashUtils.randomSalt(this.saltLength);
            }
            if (this.factor <= 0) {
                this.factor = 64000;
            }
            byte[] hash = PBKDF2.create(pepperPassword.toCharArray(), this.salt, alg, this.factor, this.hashLength);
            StringBuilder finalHash = new StringBuilder(alg2).append(":").append(this.factor).append(":").append(hash.length).append(":").append(this.salt.length).append(":").append(isPeppered).append(":").append(HashUtils.encodeBase64(this.salt)).append(":").append(HashUtils.encodeBase64(hash));
            return finalHash.toString();
        }
        if (this.algorithm == Type.BCRYPT) {
            if (this.factor <= 0) {
                this.factor = 13;
            }
            if (this.salt != null && this.salt.length > 0) {
                this.saltLength = this.salt.length;
            } else {
                if (this.saltLength <= 0) {
                    this.saltLength = 16;
                }
                this.salt = HashUtils.randomSalt(this.saltLength);
            }
            String hash = BCrypt.create(pepperPassword, null, this.salt, this.factor);
            StringBuilder finalHash = new StringBuilder(BCRYPT).append(":").append(this.factor).append(":").append(hash.length()).append(":").append(this.salt.length).append(":").append(isPeppered).append("::").append(hash);
            return finalHash.toString();
        }
        if (this.algorithm == Type.SCRYPT) {
            if (this.factor <= 0) {
                this.factor = 131072;
            }
            if (this.salt != null && this.salt.length > 0) {
                this.saltLength = this.salt.length;
            } else {
                if (this.saltLength <= 0) {
                    this.saltLength = 16;
                }
                this.salt = HashUtils.randomSalt(this.saltLength);
            }
            String hash = SCrypt.create(pepperPassword, this.salt, this.factor);
            StringBuilder finalHash = new StringBuilder(SCRYPT).append(":").append(this.factor).append(":").append(hash.length()).append(":").append(this.salt.length).append(":").append(isPeppered).append("::").append(hash);
            return finalHash.toString();
        }
        throw new IllegalArgumentException("Unsupported algorithm type. Expected Type.BCRYPT, Type.SCRIPT, or other Type enum.");
    }

    public boolean verify(String correctHash) throws InvalidHashException {
        if (correctHash == null || correctHash.isEmpty()) {
            throw new InvalidHashException("Correct hash cannot be null or empty.");
        }
        String[] params = correctHash.split(":");
        if (params.length != 7) {
            throw new InvalidHashException("Fields are missing from the correct hash. Double-check JHash vesrion and hash format.");
        }
        int iterations = 0;
        try {
            iterations = Integer.parseInt(params[1]);
        }
        catch (NumberFormatException ex) {
            throw new InvalidHashException("Could not parse the iteration count as an integer.", ex);
        }
        if (iterations < 1) {
            throw new InvalidHashException("Invalid number of iterations. Must be >= 1.");
        }
        String pepperPassword = new String(this.password);
        if ('y' == params[4].charAt(0)) {
            pepperPassword = new String(this.pepper) + pepperPassword;
        }
        byte[] salt = HashUtils.decodeBase64(params[5]);
        int storedHashSize = 0;
        try {
            storedHashSize = Integer.parseInt(params[2]);
        }
        catch (NumberFormatException ex) {
            throw new InvalidHashException("Could not parse the hash size as an integer.", ex);
        }
        int storedSaltSize = 0;
        try {
            storedSaltSize = Integer.parseInt(params[3]);
        }
        catch (NumberFormatException ex) {
            throw new InvalidHashException("Could not parse the salt size as an integer.", ex);
        }
        String algorithm = params[0];
        if (algorithm.toLowerCase().startsWith("pbkdf2")) {
            if ("pbkdf2sha1".equals(algorithm)) {
                algorithm = PBKDF2_HMACSHA1;
            } else if ("pbkdf2sha256".equals(algorithm)) {
                algorithm = PBKDF2_HMACSHA256;
            } else if ("pbkdf2sha512".equals(algorithm)) {
                algorithm = PBKDF2_HMACSHA512;
            }
            byte[] hash = HashUtils.decodeBase64(params[6]);
            if (storedHashSize != hash.length) {
                throw new InvalidHashException(HASH_LENGTH_MISMATCH);
            }
            byte[] testHash = PBKDF2.create(pepperPassword.toCharArray(), salt, algorithm, iterations, hash.length);
            return HashUtils.slowEquals(hash, testHash);
        }
        if (algorithm.equals(BCRYPT)) {
            byte[] hash = params[6].getBytes();
            if (storedHashSize != hash.length) {
                throw new InvalidHashException(HASH_LENGTH_MISMATCH);
            }
            byte[] testHash = BCrypt.create(pepperPassword, new String(hash), storedSaltSize, iterations).getBytes();
            return HashUtils.slowEquals(hash, testHash);
        }
        if (algorithm.equals(SCRYPT)) {
            byte[] hash = params[6].getBytes();
            if (storedHashSize != hash.length) {
                throw new InvalidHashException(HASH_LENGTH_MISMATCH);
            }
            return SCrypt.verify(pepperPassword, new String(hash));
        }
        throw new InvalidHashException("Unsupported algorithm type: " + algorithm);
    }
}

