/*
 * Decompiled with CFR 0.152.
 */
package com.amdelamar.jhash.algorithms;

import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class PBKDF2 {
    public static final int DEFAULT_HASH_LENGTH = 18;
    public static final int DEFAULT_SALT_LENGTH = 24;
    public static final int DEFAULT_ITERATIONS = 64000;

    public static byte[] create(char[] password, byte[] salt, String algorithm, int iterations, int hashSize) throws IllegalArgumentException {
        if (iterations < 1000) {
            iterations = 64000;
        }
        try {
            PBEKeySpec spec = new PBEKeySpec(password, salt, iterations, hashSize * 8);
            SecretKeyFactory skf = SecretKeyFactory.getInstance(algorithm);
            return skf.generateSecret(spec).getEncoded();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Invalid hash arguments", ex);
        }
    }
}

