/*
 * Decompiled with CFR 0.152.
 */
package com.amdelamar.jhash.util;

import java.security.SecureRandom;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;

public final class HashUtils {
    private HashUtils() {
    }

    public static byte[] randomSalt() {
        return HashUtils.randomSalt(new SecureRandom(), 24);
    }

    public static byte[] randomSalt(int size) {
        return HashUtils.randomSalt(new SecureRandom(), size);
    }

    public static byte[] randomSalt(SecureRandom secureRandom) {
        return HashUtils.randomSalt(secureRandom, 24);
    }

    public static byte[] randomSalt(SecureRandom secureRandom, int size) {
        byte[] salt = new byte[size];
        secureRandom.nextBytes(salt);
        return salt;
    }

    public static boolean slowEquals(byte[] byteA, byte[] byteB) {
        int diff = byteA.length ^ byteB.length;
        for (int i = 0; i < byteA.length && i < byteB.length; ++i) {
            diff |= byteA[i] ^ byteB[i];
        }
        return diff == 0;
    }

    public static byte[] decodeBase64(String string) {
        return Base64.decodeBase64((String)string);
    }

    public static String encodeBase64(byte[] array) {
        return StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])array));
    }
}

