/*
 * Decompiled with CFR 0.152.
 */
package com.amdelamar.jotp;

import com.amdelamar.jotp.type.HOTP;
import com.amdelamar.jotp.type.TOTP;
import com.amdelamar.jotp.type.Type;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.binary.Hex;

public final class OTP {
    public static final int BYTES = 20;

    private OTP() {
    }

    @Deprecated
    public static String random(String characters, int length) {
        int len = length < 1 ? 20 : length;
        SecureRandom random = new SecureRandom();
        char[] text = new char[len];
        for (int i = 0; i < len; ++i) {
            text[i] = characters.charAt(random.nextInt(characters.length()));
        }
        return new String(text);
    }

    public static String randomBase32(int length) {
        int len = length < 1 ? 20 : length;
        byte[] bytes = new byte[len];
        SecureRandom random = new SecureRandom();
        random.nextBytes(bytes);
        return new Base32().encodeToString(bytes);
    }

    @Deprecated
    public static String timeInHex() throws IOException {
        return OTP.timeInHex(System.currentTimeMillis());
    }

    public static String timeInHex(long timeInMillis) throws IOException {
        return OTP.timeInHex(timeInMillis, 30);
    }

    public static String timeInHex(long timeInMillis, int periodInSec) throws IOException {
        double period = 1.0;
        if (periodInSec > 1) {
            period = periodInSec;
        }
        long time = (long)Math.floor((double)Math.round((double)timeInMillis / 1000.0) / period);
        byte[] longBytes = ByteBuffer.allocate(8).putLong(time).array();
        return new String(Hex.encodeHex((byte[])longBytes));
    }

    public static String create(String secret, String base, int digits, Type type) throws IllegalArgumentException, InvalidKeyException, NoSuchAlgorithmException {
        OTP.validateParameters(secret, base, digits, type);
        String uppercaseSecret = secret.toUpperCase();
        byte[] bytes = new Base32().decode(uppercaseSecret);
        String key = new String(Hex.encodeHex((byte[])bytes));
        if (type == Type.HOTP) {
            HOTP hotp = new HOTP();
            return hotp.create(key, base, digits);
        }
        TOTP totp = new TOTP();
        return totp.create(key, base, digits);
    }

    public static boolean verify(String secret, String base, String code, int digits, Type type) throws IllegalArgumentException, InvalidKeyException, NoSuchAlgorithmException {
        OTP.validateParameters(secret, base, digits, type);
        String uppercaseSecret = secret.toUpperCase();
        if (code == null || code.isEmpty()) {
            throw new IllegalArgumentException("Code cannot be null or empty.");
        }
        if (code.length() != digits) {
            return false;
        }
        byte[] bytes = new Base32().decode(uppercaseSecret);
        String key = new String(Hex.encodeHex((byte[])bytes));
        String ncode = null;
        if (type == Type.HOTP) {
            HOTP hotp = new HOTP();
            ncode = hotp.create(key, base, digits);
        } else {
            TOTP totp = new TOTP();
            ncode = totp.create(key, base, digits);
        }
        return code.equals(ncode);
    }

    protected static boolean validateParameters(String secret, String base, int digits, Type type) throws IllegalArgumentException {
        if (secret == null || secret.isEmpty()) {
            throw new IllegalArgumentException("Secret cannot be null or empty.");
        }
        if (base == null || base.isEmpty()) {
            throw new IllegalArgumentException("Base cannot be null or empty.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null or empty.");
        }
        if (digits <= 0) {
            throw new IllegalArgumentException("Digits must be a positive integer (e.g. '6').");
        }
        return true;
    }

    public static String getURL(String secret, int digits, Type type, String issuer, String email) throws IllegalArgumentException {
        OTP.validateParameters(secret, secret, digits, type);
        StringBuilder sb = new StringBuilder();
        sb.append("otpauth://");
        if (type == Type.HOTP) {
            sb.append("hotp/");
        } else {
            sb.append("totp/");
        }
        sb.append(issuer + ":");
        sb.append(email + "?");
        sb.append("secret=" + secret);
        sb.append("&issuer=" + issuer);
        sb.append("&algorithm=SHA1");
        sb.append("&digits=" + digits);
        if (type == Type.TOTP) {
            sb.append("&period=30");
        }
        return sb.toString();
    }
}

