/*
 * Decompiled with CFR 0.152.
 */
package com.amdelamar.jotp.type;

import com.amdelamar.jotp.type.OTPInterface;
import com.amdelamar.jotp.util.Utils;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

public class HOTP
implements OTPInterface {
    private static final int TRUNCATE_OFFSET = 0;
    private static final boolean CHECKSUM = false;
    private static final String HMACSHA1_ALGORITHM = "HmacSHA1";
    private static final String LABEL = "hotp";
    private static final int[] doubleDigits = new int[]{0, 2, 4, 6, 8, 1, 3, 5, 7, 9};

    @Override
    public String getLabel() {
        return LABEL;
    }

    @Override
    public String create(String secret, String base, int digits) throws InvalidKeyException, NoSuchAlgorithmException {
        return HOTP.generateHotp(secret.getBytes(), Long.parseLong(base), digits, false, 0, HMACSHA1_ALGORITHM);
    }

    protected static int checksum(long num, int digits) {
        boolean doubleDigit = true;
        int total = 0;
        for (int i = digits; 0 < i; --i) {
            int digit = (int)(num % 10L);
            num /= 10L;
            if (doubleDigit) {
                digit = doubleDigits[digit];
            }
            total += digit;
            doubleDigit = !doubleDigit;
        }
        int result = total % 10;
        if (result > 0) {
            result = 10 - result;
        }
        return result;
    }

    protected static String generateHotp(byte[] secret, long movingFactor, int digits, boolean addChecksum, int truncationOffset, String crypto) throws NoSuchAlgorithmException, InvalidKeyException {
        int digit;
        byte[] text = new byte[8];
        for (int i = text.length - 1; i >= 0; --i) {
            text[i] = (byte)(movingFactor & 0xFFL);
            movingFactor >>= 8;
        }
        byte[] hash = Utils.hmac(crypto, secret, text);
        int offset = hash[hash.length - 1] & 0xF;
        if (-1 < truncationOffset && truncationOffset < hash.length - 4) {
            offset = truncationOffset;
        }
        int binary = (hash[offset] & 0x7F) << 24 | (hash[offset + 1] & 0xFF) << 16 | (hash[offset + 2] & 0xFF) << 8 | hash[offset + 3] & 0xFF;
        int otp = binary % (int)Math.pow(10.0, digits);
        if (addChecksum) {
            otp = otp * 10 + HOTP.checksum(otp, digits);
        }
        String result = Integer.toString(otp);
        int n = digit = addChecksum ? digits + 1 : digits;
        while (result.length() < digit) {
            result = "0" + result;
        }
        return result;
    }
}

