/*
 * Decompiled with CFR 0.152.
 */
package com.amdelamar.jotp.type;

import com.amdelamar.jotp.type.OTPInterface;
import com.amdelamar.jotp.util.Utils;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

public class TOTP
implements OTPInterface {
    private static final String HMACSHA1_ALGORITHM = "HmacSHA1";
    private static final String LABEL = "totp";

    @Override
    public String getLabel() {
        return LABEL;
    }

    @Override
    public String create(String secret, String base, int digits) throws InvalidKeyException, NoSuchAlgorithmException {
        return TOTP.generateTotp(secret, base, digits, HMACSHA1_ALGORITHM);
    }

    protected static byte[] hexStringToBytes(String hex) {
        byte[] bArray = new BigInteger("10" + hex, 16).toByteArray();
        byte[] ret = new byte[bArray.length - 1];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = bArray[i + 1];
        }
        return ret;
    }

    protected static String generateTotp(String key, String time, int digits, String crypto) throws InvalidKeyException, NoSuchAlgorithmException {
        while (time.length() < 16) {
            time = "0" + time;
        }
        byte[] msg = TOTP.hexStringToBytes(time);
        byte[] k = TOTP.hexStringToBytes(key);
        byte[] hash = Utils.hmac(crypto, k, msg);
        int offset = hash[hash.length - 1] & 0xF;
        int binary = (hash[offset] & 0x7F) << 24 | (hash[offset + 1] & 0xFF) << 16 | (hash[offset + 2] & 0xFF) << 8 | hash[offset + 3] & 0xFF;
        int otp = binary % (int)Math.pow(10.0, digits);
        String result = Integer.toString(otp);
        while (result.length() < digits) {
            result = "0" + result;
        }
        return result;
    }
}

