/*
 * Decompiled with CFR 0.152.
 */
package com.amdocs.zusammen.plugin.statestore.cassandra;

import com.amdocs.zusammen.datatypes.Id;
import com.amdocs.zusammen.datatypes.Namespace;
import com.amdocs.zusammen.datatypes.SessionContext;
import com.amdocs.zusammen.datatypes.item.ElementContext;
import com.amdocs.zusammen.plugin.statestore.cassandra.StateStoreConstants;
import com.amdocs.zusammen.plugin.statestore.cassandra.StateStoreUtil;
import com.amdocs.zusammen.plugin.statestore.cassandra.dao.ElementRepository;
import com.amdocs.zusammen.plugin.statestore.cassandra.dao.ElementRepositoryFactory;
import com.amdocs.zusammen.plugin.statestore.cassandra.dao.types.ElementEntity;
import com.amdocs.zusammen.plugin.statestore.cassandra.dao.types.ElementEntityContext;
import com.amdocs.zusammen.sdk.state.types.StateElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;

class ElementStateStore {
    ElementStateStore() {
    }

    Collection<StateElement> listElements(SessionContext context, ElementContext elementContext, Id elementId) {
        ElementEntityContext elementEntityContext = new ElementEntityContext(StateStoreUtil.getPrivateSpaceName(context), elementContext);
        if (elementId == null) {
            elementId = StateStoreConstants.ROOT_ELEMENTS_PARENT_ID;
        }
        ElementRepository elementRepository = this.getElementRepository(context);
        String elementIdValue = elementId.getValue();
        ArrayList<StateElement> subElements = new ArrayList<StateElement>();
        Optional<ElementEntity> element = elementRepository.get(context, elementEntityContext, new ElementEntity(elementId));
        if (element.isPresent() && element.get().getSubElementIds() != null) {
            for (Id subElementId : element.get().getSubElementIds()) {
                ElementEntity subElement = elementRepository.get(context, elementEntityContext, new ElementEntity(subElementId)).orElseThrow(() -> new IllegalStateException(String.format("List sub elements error: item %s, version %s - element %s, which appears as sub element of element %s, does not exist", elementContext.getItemId().getValue(), elementContext.getVersionId().getValue(), subElementId, elementIdValue)));
                subElements.add(StateStoreUtil.getStateElement(elementEntityContext, subElement));
            }
        }
        return subElements;
    }

    boolean isElementExist(SessionContext context, ElementContext elementContext, Id elementId) {
        return this.getElementRepository(context).get(context, new ElementEntityContext(StateStoreUtil.getPrivateSpaceName(context), elementContext), new ElementEntity(elementId)).isPresent();
    }

    Namespace getElementNamespace(SessionContext context, Id itemId, Id elementId) {
        return this.getElementRepository(context).getNamespace(context, new ElementEntityContext(null, itemId, null), new ElementEntity(elementId)).orElse(null);
    }

    StateElement getElement(SessionContext context, ElementContext elementContext, Id elementId) {
        ElementEntityContext elementEntityContext = new ElementEntityContext(StateStoreUtil.getPrivateSpaceName(context), elementContext);
        return this.getElementRepository(context).get(context, elementEntityContext, new ElementEntity(elementId)).map(elementEntity -> StateStoreUtil.getStateElement(elementEntityContext, elementEntity)).orElse(null);
    }

    void createElement(SessionContext context, StateElement element) {
        this.getElementRepository(context).create(context, new ElementEntityContext(StateStoreUtil.getSpaceName(context, element.getSpace()), element.getItemId(), element.getVersionId()), StateStoreUtil.getElementEntity(element));
    }

    void updateElement(SessionContext context, StateElement element) {
        this.getElementRepository(context).update(context, new ElementEntityContext(StateStoreUtil.getSpaceName(context, element.getSpace()), element.getItemId(), element.getVersionId()), StateStoreUtil.getElementEntity(element));
    }

    void deleteElement(SessionContext context, StateElement element) {
        this.deleteElementHierarchy(this.getElementRepository(context), context, new ElementEntityContext(StateStoreUtil.getSpaceName(context, element.getSpace()), element.getItemId(), element.getVersionId()), StateStoreUtil.getElementEntity(element));
    }

    private void deleteElementHierarchy(ElementRepository elementRepository, SessionContext context, ElementEntityContext elementEntityContext, ElementEntity elementEntity) {
        Optional<ElementEntity> retrieved = elementRepository.get(context, elementEntityContext, elementEntity);
        if (!retrieved.isPresent()) {
            return;
        }
        retrieved.get().getSubElementIds().stream().map(ElementEntity::new).forEach(subElementEntity -> this.deleteElementHierarchy(elementRepository, context, elementEntityContext, (ElementEntity)subElementEntity));
        elementRepository.delete(context, elementEntityContext, elementEntity);
    }

    protected ElementRepository getElementRepository(SessionContext context) {
        return ElementRepositoryFactory.getInstance().createInterface(context);
    }
}

