/*
 * Decompiled with CFR 0.152.
 */
package com.amdocs.zusammen.plugin.statestore.cassandra;

import com.amdocs.zusammen.datatypes.Id;
import com.amdocs.zusammen.datatypes.SessionContext;
import com.amdocs.zusammen.datatypes.Space;
import com.amdocs.zusammen.datatypes.item.Info;
import com.amdocs.zusammen.datatypes.item.Item;
import com.amdocs.zusammen.datatypes.item.ItemVersion;
import com.amdocs.zusammen.plugin.statestore.cassandra.VersionStateStore;
import com.amdocs.zusammen.plugin.statestore.cassandra.dao.ItemDao;
import com.amdocs.zusammen.plugin.statestore.cassandra.dao.ItemDaoFactory;
import java.util.Collection;
import java.util.Date;

class ItemStateStore {
    private VersionStateStore versionStateStore;

    ItemStateStore(VersionStateStore versionStateStore) {
        this.versionStateStore = versionStateStore;
    }

    Collection<Item> listItems(SessionContext context) {
        return this.getItemDao(context).list(context);
    }

    boolean isItemExist(SessionContext context, Id itemId) {
        return this.getItemDao(context).get(context, itemId).isPresent();
    }

    Item getItem(SessionContext context, Id itemId) {
        return this.getItemDao(context).get(context, itemId).orElse(null);
    }

    void createItem(SessionContext context, Id itemId, Info itemInfo, Date creationTime) {
        this.getItemDao(context).create(context, itemId, itemInfo, creationTime);
    }

    void updateItem(SessionContext context, Id itemId, Info itemInfo, Date modificationTime) {
        this.getItemDao(context).update(context, itemId, itemInfo, modificationTime);
    }

    void deleteItem(SessionContext context, Id itemId) {
        Collection<ItemVersion> versions = this.versionStateStore.listItemVersions(context, Space.PRIVATE, itemId);
        versions.forEach(itemVersion -> this.versionStateStore.deleteItemVersion(context, Space.PRIVATE, itemId, itemVersion.getId()));
        this.getItemDao(context).delete(context, itemId);
    }

    protected ItemDao getItemDao(SessionContext context) {
        return ItemDaoFactory.getInstance().createInterface(context);
    }

    public void updateItemModificationTime(SessionContext context, Id itemId, Date modificationTime) {
        this.getItemDao(context).updateItemModificationTime(context, itemId, modificationTime);
    }
}

