/*
 * Decompiled with CFR 0.152.
 */
package com.amdocs.zusammen.plugin.statestore.cassandra;

import com.amdocs.zusammen.commons.health.data.HealthInfo;
import com.amdocs.zusammen.commons.health.data.HealthStatus;
import com.amdocs.zusammen.commons.log.ZusammenLogger;
import com.amdocs.zusammen.commons.log.ZusammenLoggerFactory;
import com.amdocs.zusammen.datatypes.Id;
import com.amdocs.zusammen.datatypes.Namespace;
import com.amdocs.zusammen.datatypes.SessionContext;
import com.amdocs.zusammen.datatypes.Space;
import com.amdocs.zusammen.datatypes.item.ElementContext;
import com.amdocs.zusammen.datatypes.item.Info;
import com.amdocs.zusammen.datatypes.item.Item;
import com.amdocs.zusammen.datatypes.item.ItemVersion;
import com.amdocs.zusammen.datatypes.item.ItemVersionData;
import com.amdocs.zusammen.datatypes.response.Response;
import com.amdocs.zusammen.plugin.statestore.cassandra.ElementStateStore;
import com.amdocs.zusammen.plugin.statestore.cassandra.ItemStateStore;
import com.amdocs.zusammen.plugin.statestore.cassandra.VersionStateStore;
import com.amdocs.zusammen.plugin.statestore.cassandra.dao.HealthHelper;
import com.amdocs.zusammen.sdk.state.StateStore;
import com.amdocs.zusammen.sdk.state.types.StateElement;
import java.util.Collection;
import java.util.Date;

public class StateStoreImpl
implements StateStore,
HealthHelper {
    private ElementStateStore elementStateStore = new ElementStateStore();
    private VersionStateStore versionStateStore = new VersionStateStore();
    private ItemStateStore itemStateStore = new ItemStateStore(this.versionStateStore);
    public static final ZusammenLogger LOGGER = ZusammenLoggerFactory.getLogger((String)StateStoreImpl.class.getName());

    public Response<HealthInfo> checkHealth(SessionContext sessionContext) {
        HealthInfo healthInfo = null;
        boolean queryResult = false;
        try {
            queryResult = this.getKeepAliveDao(sessionContext).get(sessionContext);
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            healthInfo = new HealthInfo("Cassandra", HealthStatus.DOWN, t.getMessage());
            return new Response((Object)healthInfo);
        }
        if (queryResult) {
            healthInfo = new HealthInfo("Cassandra", HealthStatus.UP, "");
            LOGGER.info("Health info:" + healthInfo);
        } else {
            healthInfo = new HealthInfo("Cassandra", HealthStatus.DOWN, "DB Schema does not exist.");
            LOGGER.error("Health info:" + healthInfo);
        }
        return new Response((Object)healthInfo);
    }

    public Response<Collection<Item>> listItems(SessionContext context) {
        return new Response(this.itemStateStore.listItems(context));
    }

    public Response<Boolean> isItemExist(SessionContext context, Id itemId) {
        return new Response((Object)this.itemStateStore.isItemExist(context, itemId));
    }

    public Response<Item> getItem(SessionContext context, Id itemId) {
        return new Response((Object)this.itemStateStore.getItem(context, itemId));
    }

    public Response<Void> createItem(SessionContext context, Id itemId, Info itemInfo, Date creationTime) {
        this.itemStateStore.createItem(context, itemId, itemInfo, creationTime);
        return new Response(Void.TYPE);
    }

    public Response<Void> updateItem(SessionContext context, Id itemId, Info itemInfo, Date modificationTime) {
        this.itemStateStore.updateItem(context, itemId, itemInfo, modificationTime);
        return new Response(Void.TYPE);
    }

    public Response<Void> deleteItem(SessionContext context, Id itemId) {
        this.itemStateStore.deleteItem(context, itemId);
        return new Response(Void.TYPE);
    }

    public Response<Void> updateItemModificationTime(SessionContext context, Id itemId, Date modificationTime) {
        this.itemStateStore.updateItemModificationTime(context, itemId, modificationTime);
        return new Response(Void.TYPE);
    }

    public Response<Collection<ItemVersion>> listItemVersions(SessionContext context, Space space, Id itemId) {
        return new Response(this.versionStateStore.listItemVersions(context, space, itemId));
    }

    public Response<Boolean> isItemVersionExist(SessionContext context, Space space, Id itemId, Id versionId) {
        return new Response((Object)this.versionStateStore.isItemVersionExist(context, space, itemId, versionId));
    }

    public Response<ItemVersion> getItemVersion(SessionContext context, Space space, Id itemId, Id versionId) {
        return new Response((Object)this.versionStateStore.getItemVersion(context, space, itemId, versionId));
    }

    public Response<Void> createItemVersion(SessionContext context, Space space, Id itemId, Id baseVersionId, Id versionId, ItemVersionData data, Date creationTime) {
        this.versionStateStore.createItemVersion(context, space, itemId, baseVersionId, versionId, data, creationTime);
        return new Response(Void.TYPE);
    }

    public Response<Void> updateItemVersion(SessionContext context, Space space, Id itemId, Id versionId, ItemVersionData data, Date modificationTime) {
        this.versionStateStore.updateItemVersion(context, space, itemId, versionId, data, modificationTime);
        return new Response(Void.TYPE);
    }

    public Response<Void> deleteItemVersion(SessionContext context, Space space, Id itemId, Id versionId) {
        this.versionStateStore.deleteItemVersion(context, space, itemId, versionId);
        return new Response(Void.TYPE);
    }

    public Response<Void> updateItemVersionModificationTime(SessionContext context, Space space, Id itemId, Id versionId, Date modificationTime) {
        this.versionStateStore.updateItemVersionModificationTime(context, space, itemId, versionId, modificationTime);
        return new Response(Void.TYPE);
    }

    public Response<Collection<StateElement>> listElements(SessionContext context, ElementContext elementContext, Id elementId) {
        return new Response(this.elementStateStore.listElements(context, elementContext, elementId));
    }

    public Response<Boolean> isElementExist(SessionContext context, ElementContext elementContext, Id elementId) {
        return new Response((Object)this.elementStateStore.isElementExist(context, elementContext, elementId));
    }

    public Response<Namespace> getElementNamespace(SessionContext context, Id itemId, Id elementId) {
        return new Response((Object)this.elementStateStore.getElementNamespace(context, itemId, elementId));
    }

    public Response<StateElement> getElement(SessionContext context, ElementContext elementContext, Id elementId) {
        return new Response((Object)this.elementStateStore.getElement(context, elementContext, elementId));
    }

    public Response<Void> createElement(SessionContext context, StateElement element) {
        this.elementStateStore.createElement(context, element);
        return new Response(Void.TYPE);
    }

    public Response<Void> updateElement(SessionContext context, StateElement element) {
        this.elementStateStore.updateElement(context, element);
        return new Response(Void.TYPE);
    }

    public Response<Void> deleteElement(SessionContext context, StateElement element) {
        this.elementStateStore.deleteElement(context, element);
        return new Response(Void.TYPE);
    }
}

