/*
 * Decompiled with CFR 0.152.
 */
package com.amdocs.zusammen.plugin.statestore.cassandra;

import com.amdocs.zusammen.datatypes.Id;
import com.amdocs.zusammen.datatypes.SessionContext;
import com.amdocs.zusammen.datatypes.Space;
import com.amdocs.zusammen.plugin.statestore.cassandra.StateStoreConstants;
import com.amdocs.zusammen.plugin.statestore.cassandra.dao.types.ElementEntity;
import com.amdocs.zusammen.plugin.statestore.cassandra.dao.types.ElementEntityContext;
import com.amdocs.zusammen.sdk.state.types.StateElement;

class StateStoreUtil {
    StateStoreUtil() {
    }

    static String getSpaceName(SessionContext context, Space space) {
        switch (space) {
            case PUBLIC: {
                return "public";
            }
            case PRIVATE: {
                return StateStoreUtil.getPrivateSpaceName(context);
            }
        }
        throw new IllegalArgumentException(String.format("Space %s is not supported.", space));
    }

    static String getPrivateSpaceName(SessionContext context) {
        return context.getUser().getUserName();
    }

    static ElementEntity getElementEntity(StateElement element) {
        ElementEntity elementEntity = new ElementEntity(element.getId());
        elementEntity.setNamespace(element.getNamespace());
        elementEntity.setParentId(element.getParentId() == null ? StateStoreConstants.ROOT_ELEMENTS_PARENT_ID : element.getParentId());
        elementEntity.setInfo(element.getInfo());
        elementEntity.setRelations(element.getRelations());
        return elementEntity;
    }

    static StateElement getStateElement(ElementEntityContext elementEntityContext, ElementEntity elementEntity) {
        Id parentId = StateStoreConstants.ROOT_ELEMENTS_PARENT_ID.equals((Object)elementEntity.getParentId()) ? null : elementEntity.getParentId();
        StateElement element = new StateElement(elementEntityContext.getItemId(), elementEntityContext.getVersionId(), elementEntity.getNamespace(), elementEntity.getId());
        element.setParentId(parentId);
        element.setInfo(elementEntity.getInfo());
        element.setRelations(elementEntity.getRelations());
        element.setSubElements(elementEntity.getSubElementIds());
        return element;
    }
}

