/*
 * Decompiled with CFR 0.152.
 */
package com.amdocs.zusammen.plugin.statestore.cassandra;

import com.amdocs.zusammen.datatypes.Id;
import com.amdocs.zusammen.datatypes.SessionContext;
import com.amdocs.zusammen.datatypes.Space;
import com.amdocs.zusammen.datatypes.item.ItemVersion;
import com.amdocs.zusammen.datatypes.item.ItemVersionData;
import com.amdocs.zusammen.plugin.statestore.cassandra.StateStoreUtil;
import com.amdocs.zusammen.plugin.statestore.cassandra.dao.ElementRepository;
import com.amdocs.zusammen.plugin.statestore.cassandra.dao.ElementRepositoryFactory;
import com.amdocs.zusammen.plugin.statestore.cassandra.dao.VersionDao;
import com.amdocs.zusammen.plugin.statestore.cassandra.dao.VersionDaoFactory;
import com.amdocs.zusammen.plugin.statestore.cassandra.dao.types.ElementEntity;
import com.amdocs.zusammen.plugin.statestore.cassandra.dao.types.ElementEntityContext;
import java.util.Collection;
import java.util.Date;

class VersionStateStore {
    VersionStateStore() {
    }

    Collection<ItemVersion> listItemVersions(SessionContext context, Space space, Id itemId) {
        return this.getVersionDao(context).list(context, StateStoreUtil.getSpaceName(context, space), itemId);
    }

    boolean isItemVersionExist(SessionContext context, Space space, Id itemId, Id versionId) {
        return this.getVersionDao(context).get(context, StateStoreUtil.getSpaceName(context, space), itemId, versionId).isPresent();
    }

    ItemVersion getItemVersion(SessionContext context, Space space, Id itemId, Id versionId) {
        return this.getVersionDao(context).get(context, StateStoreUtil.getSpaceName(context, space), itemId, versionId).orElse(null);
    }

    void createItemVersion(SessionContext context, Space space, Id itemId, Id baseVersionId, Id versionId, ItemVersionData data, Date creationTime) {
        String spaceName = StateStoreUtil.getSpaceName(context, space);
        this.getVersionDao(context).create(context, spaceName, itemId, baseVersionId, versionId, data, creationTime);
        if (baseVersionId == null) {
            return;
        }
        this.copyElements(context, spaceName, itemId, baseVersionId, versionId);
    }

    void updateItemVersion(SessionContext context, Space space, Id itemId, Id versionId, ItemVersionData data, Date modificationTime) {
        this.getVersionDao(context).update(context, StateStoreUtil.getSpaceName(context, space), itemId, versionId, data, modificationTime);
    }

    void deleteItemVersion(SessionContext context, Space space, Id itemId, Id versionId) {
        String spaceName = StateStoreUtil.getSpaceName(context, space);
        this.deleteElements(context, spaceName, itemId, versionId);
        this.getVersionDao(context).delete(context, spaceName, itemId, versionId);
    }

    public void updateItemVersionModificationTime(SessionContext context, Space space, Id itemId, Id versionId, Date modificationTime) {
        this.getVersionDao(context).updateItemVersionModificationTime(context, StateStoreUtil.getSpaceName(context, space), itemId, versionId, modificationTime);
    }

    private void copyElements(SessionContext context, String space, Id itemId, Id sourceVersionId, Id targetVersionId) {
        ElementRepository elementRepository = this.getElementRepository(context);
        ElementEntityContext elementContext = new ElementEntityContext(space, itemId, sourceVersionId);
        Collection<ElementEntity> versionElements = elementRepository.list(context, elementContext);
        elementContext.setVersionId(targetVersionId);
        versionElements.forEach(elementEntity -> elementRepository.create(context, elementContext, (ElementEntity)elementEntity));
    }

    private void deleteElements(SessionContext context, String space, Id itemId, Id versionId) {
        ElementRepository elementRepository = this.getElementRepository(context);
        ElementEntityContext elementContext = new ElementEntityContext(space, itemId, versionId);
        Collection<ElementEntity> versionElements = elementRepository.list(context, elementContext);
        versionElements.stream().peek(elementEntity -> elementEntity.setParentId(null)).forEach(elementEntity -> elementRepository.delete(context, elementContext, (ElementEntity)elementEntity));
    }

    protected VersionDao getVersionDao(SessionContext context) {
        return VersionDaoFactory.getInstance().createInterface(context);
    }

    protected ElementRepository getElementRepository(SessionContext context) {
        return ElementRepositoryFactory.getInstance().createInterface(context);
    }
}

