/*
 * Decompiled with CFR 0.152.
 */
package com.amdocs.zusammen.plugin.statestore.cassandra.dao.impl;

import com.amdocs.zusammen.datatypes.Id;
import com.amdocs.zusammen.datatypes.Namespace;
import com.amdocs.zusammen.datatypes.SessionContext;
import com.amdocs.zusammen.datatypes.item.Info;
import com.amdocs.zusammen.datatypes.item.Relation;
import com.amdocs.zusammen.plugin.statestore.cassandra.dao.ElementRepository;
import com.amdocs.zusammen.plugin.statestore.cassandra.dao.impl.CassandraDaoUtils;
import com.amdocs.zusammen.plugin.statestore.cassandra.dao.types.ElementEntity;
import com.amdocs.zusammen.plugin.statestore.cassandra.dao.types.ElementEntityContext;
import com.amdocs.zusammen.utils.fileutils.json.JsonUtil;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.mapping.annotations.Accessor;
import com.datastax.driver.mapping.annotations.Param;
import com.datastax.driver.mapping.annotations.Query;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class CassandraElementRepository
implements ElementRepository {
    @Override
    public Collection<ElementEntity> list(SessionContext context, ElementEntityContext elementContext) {
        Set<String> elementIds = this.getVersionElementIds(context, elementContext);
        ArrayList<ElementEntity> elements = new ArrayList<ElementEntity>();
        for (String elementId : elementIds) {
            elements.add(this.get(context, elementContext, new ElementEntity(new Id(elementId))).orElseThrow(() -> new IllegalStateException(String.format("List version elements error: Element %s, which appears as an element of item %s version %s, does not exist", elementId, elementContext.getItemId().getValue(), elementContext.getVersionId().getValue()))));
        }
        return elements;
    }

    @Override
    public void create(SessionContext context, ElementEntityContext elementContext, ElementEntity element) {
        this.createElement(context, elementContext, element);
        this.addElementToParent(context, elementContext, element);
    }

    @Override
    public void update(SessionContext context, ElementEntityContext elementContext, ElementEntity element) {
        this.updateElement(context, elementContext, element);
    }

    @Override
    public void delete(SessionContext context, ElementEntityContext elementContext, ElementEntity element) {
        this.removeElementFromParent(context, elementContext, element);
        this.deleteElement(context, elementContext, element);
    }

    @Override
    public Optional<ElementEntity> get(SessionContext context, ElementEntityContext elementContext, ElementEntity element) {
        Row row = this.getElementAccessor(context).get(elementContext.getSpace(), elementContext.getItemId().toString(), elementContext.getVersionId().toString(), element.getId().toString()).one();
        return row == null ? Optional.empty() : Optional.of(this.getElementEntity(element, row));
    }

    @Override
    public Optional<Namespace> getNamespace(SessionContext context, ElementEntityContext elementContext, ElementEntity element) {
        Row row = this.getElementNamespaceAccessor(context).get(elementContext.getItemId().toString(), element.getId().toString()).one();
        return row == null ? Optional.empty() : Optional.of(this.getNamespace(row.getString("namespace")));
    }

    private ElementNamespaceAccessor getElementNamespaceAccessor(SessionContext context) {
        return CassandraDaoUtils.getAccessor(context, ElementNamespaceAccessor.class);
    }

    private ElementAccessor getElementAccessor(SessionContext context) {
        return CassandraDaoUtils.getAccessor(context, ElementAccessor.class);
    }

    private VersionElementsAccessor getVersionElementsAccessor(SessionContext context) {
        return CassandraDaoUtils.getAccessor(context, VersionElementsAccessor.class);
    }

    private void createElement(SessionContext context, ElementEntityContext elementContext, ElementEntity element) {
        this.getElementNamespaceAccessor(context).create(elementContext.getItemId().toString(), element.getId().toString(), element.getNamespace().toString());
        Set<String> subElementIds = element.getSubElementIds().stream().map(Id::toString).collect(Collectors.toSet());
        this.getElementAccessor(context).create(elementContext.getSpace(), elementContext.getItemId().toString(), elementContext.getVersionId().toString(), element.getId().toString(), element.getParentId().toString(), element.getNamespace().toString(), JsonUtil.object2Json((Object)element.getInfo()), JsonUtil.object2Json(element.getRelations()), subElementIds);
        this.getVersionElementsAccessor(context).addElements(Collections.singleton(element.getId().toString()), elementContext.getSpace(), elementContext.getItemId().toString(), elementContext.getVersionId().toString());
    }

    private void updateElement(SessionContext context, ElementEntityContext elementContext, ElementEntity element) {
        this.getElementAccessor(context).update(JsonUtil.object2Json((Object)element.getInfo()), JsonUtil.object2Json(element.getRelations()), elementContext.getSpace(), elementContext.getItemId().toString(), elementContext.getVersionId().toString(), element.getId().toString());
    }

    private void deleteElement(SessionContext context, ElementEntityContext elementContext, ElementEntity element) {
        this.getElementAccessor(context).delete(elementContext.getSpace(), elementContext.getItemId().toString(), elementContext.getVersionId().toString(), element.getId().toString());
        this.getVersionElementsAccessor(context).removeElements(Collections.singleton(element.getId().toString()), elementContext.getSpace(), elementContext.getItemId().toString(), elementContext.getVersionId().toString());
    }

    private void addElementToParent(SessionContext context, ElementEntityContext elementContext, ElementEntity element) {
        this.getElementAccessor(context).addSubElements(Collections.singleton(element.getId().toString()), elementContext.getSpace(), elementContext.getItemId().toString(), elementContext.getVersionId().toString(), element.getParentId().toString());
    }

    private void removeElementFromParent(SessionContext context, ElementEntityContext elementContext, ElementEntity element) {
        if (element.getParentId() == null) {
            return;
        }
        this.getElementAccessor(context).removeSubElements(Collections.singleton(element.getId().toString()), elementContext.getSpace(), elementContext.getItemId().toString(), elementContext.getVersionId().toString(), element.getParentId().toString());
    }

    private ElementEntity getElementEntity(ElementEntity element, Row row) {
        element.setNamespace(this.getNamespace(row.getString("namespace")));
        element.setParentId(new Id(row.getString("parent_id")));
        element.setInfo((Info)CassandraElementRepository.json2Object(row.getString("info"), Info.class));
        element.setRelations((Collection)CassandraElementRepository.json2Object(row.getString("relations"), new TypeToken<ArrayList<Relation>>(){}.getType()));
        element.setSubElementIds(row.getSet("sub_element_ids", String.class).stream().map(Id::new).collect(Collectors.toSet()));
        return element;
    }

    private Namespace getNamespace(String namespaceStr) {
        Namespace namespace = new Namespace();
        if (namespaceStr != null) {
            namespace.setValue(namespaceStr);
        }
        return namespace;
    }

    private static <T> T json2Object(String json, Type typeOfT) {
        return (T)(json == null ? null : JsonUtil.json2Object((String)json, (Type)typeOfT));
    }

    private Set<String> getVersionElementIds(SessionContext context, ElementEntityContext elementContext) {
        Row row = this.getVersionElementsAccessor(context).get(elementContext.getSpace(), elementContext.getItemId().toString(), elementContext.getVersionId().toString()).one();
        return row == null ? new HashSet() : row.getSet("element_ids", String.class);
    }

    private static final class VersionElementsField {
        private static final String ELEMENT_IDS = "element_ids";

        private VersionElementsField() {
        }
    }

    @Accessor
    static interface VersionElementsAccessor {
        @Query(value="UPDATE version_elements SET element_ids=element_ids+? WHERE space=? AND item_id=? AND version_id=?")
        public void addElements(Set<String> var1, String var2, String var3, String var4);

        @Query(value="UPDATE version_elements SET element_ids=element_ids-? WHERE space=? AND item_id=? AND version_id=?")
        public void removeElements(Set<String> var1, String var2, String var3, String var4);

        @Query(value="SELECT element_ids FROM version_elements WHERE space=? AND item_id=? AND version_id=?")
        public ResultSet get(String var1, String var2, String var3);
    }

    private static final class ElementField {
        private static final String NAMESPACE = "namespace";
        private static final String PARENT_ID = "parent_id";
        private static final String INFO = "info";
        private static final String RELATIONS = "relations";
        private static final String SUB_ELEMENT_IDS = "sub_element_ids";

        private ElementField() {
        }
    }

    @Accessor
    static interface ElementAccessor {
        @Query(value="UPDATE element SET parent_id=:parentId, namespace=:ns, info=:info, relations=:rels, sub_element_ids=sub_element_ids+:subs   WHERE space=:space AND item_id=:item AND version_id=:ver AND element_id=:id ")
        public void create(@Param(value="space") String var1, @Param(value="item") String var2, @Param(value="ver") String var3, @Param(value="id") String var4, @Param(value="parentId") String var5, @Param(value="ns") String var6, @Param(value="info") String var7, @Param(value="rels") String var8, @Param(value="subs") Set<String> var9);

        @Query(value="UPDATE element SET info=?, relations=?  WHERE space=? AND item_id=? AND version_id=? AND element_id=?")
        public void update(String var1, String var2, String var3, String var4, String var5, String var6);

        @Query(value="DELETE FROM element WHERE space=? AND item_id=? AND version_id=? AND element_id=?")
        public void delete(String var1, String var2, String var3, String var4);

        @Query(value="SELECT parent_id, namespace, info, relations, sub_element_ids FROM element  WHERE space=? AND item_id=? AND version_id=? AND element_id=?")
        public ResultSet get(String var1, String var2, String var3, String var4);

        @Query(value="UPDATE element SET sub_element_ids=sub_element_ids+?  WHERE space=? AND item_id=? AND version_id=? AND element_id=?")
        public void addSubElements(Set<String> var1, String var2, String var3, String var4, String var5);

        @Query(value="UPDATE element SET sub_element_ids=sub_element_ids-?  WHERE space=? AND item_id=? AND version_id=? AND element_id=?")
        public void removeSubElements(Set<String> var1, String var2, String var3, String var4, String var5);
    }

    private static final class ElementNamespaceField {
        private static final String NAMESPACE = "namespace";

        private ElementNamespaceField() {
        }
    }

    @Accessor
    static interface ElementNamespaceAccessor {
        @Query(value="UPDATE element_namespace SET namespace=:ns WHERE item_id=:item AND element_id=:id ")
        public void create(@Param(value="item") String var1, @Param(value="id") String var2, @Param(value="ns") String var3);

        @Query(value="SELECT namespace FROM element_namespace WHERE item_id=? AND element_id=?")
        public ResultSet get(String var1, String var2);
    }
}

