/*
 * Decompiled with CFR 0.152.
 */
package com.amdocs.zusammen.plugin.statestore.cassandra.dao.impl;

import com.amdocs.zusammen.datatypes.Id;
import com.amdocs.zusammen.datatypes.SessionContext;
import com.amdocs.zusammen.datatypes.item.Info;
import com.amdocs.zusammen.datatypes.item.Item;
import com.amdocs.zusammen.plugin.statestore.cassandra.dao.ItemDao;
import com.amdocs.zusammen.plugin.statestore.cassandra.dao.impl.CassandraDaoUtils;
import com.amdocs.zusammen.utils.fileutils.json.JsonUtil;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.mapping.annotations.Accessor;
import com.datastax.driver.mapping.annotations.Query;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ItemCassandraDao
implements ItemDao {
    @Override
    public void create(SessionContext context, Id itemId, Info itemInfo, Date creationTime) {
        this.getAccessor(context).create(itemId.getValue(), JsonUtil.object2Json((Object)itemInfo), creationTime, creationTime);
    }

    @Override
    public void update(SessionContext context, Id itemId, Info itemInfo, Date modificationTime) {
        this.getAccessor(context).update(itemId.getValue(), JsonUtil.object2Json((Object)itemInfo), modificationTime);
    }

    @Override
    public void updateItemModificationTime(SessionContext context, Id itemId, Date modificationTime) {
        this.getAccessor(context).updateModificationTime(itemId.getValue(), modificationTime);
    }

    @Override
    public void delete(SessionContext context, Id itemId) {
        this.getAccessor(context).delete(itemId.getValue());
    }

    @Override
    public Optional<Item> get(SessionContext context, Id itemId) {
        Row row = this.getAccessor(context).get(itemId.getValue()).one();
        return row == null ? Optional.empty() : Optional.of(this.createItem(row));
    }

    @Override
    public List<Item> list(SessionContext context) {
        List rows = this.getAccessor(context).list().all();
        return rows == null ? new ArrayList<Item>() : rows.stream().map(this::createItem).collect(Collectors.toList());
    }

    private Item createItem(Row row) {
        Item item = new Item();
        item.setId(new Id(row.getString("item_id")));
        item.setInfo((Info)JsonUtil.json2Object((String)row.getString("item_info"), Info.class));
        item.setCreationTime(row.getTimestamp("creation_time"));
        item.setModificationTime(row.getTimestamp("modification_time"));
        return item;
    }

    private ItemAccessor getAccessor(SessionContext context) {
        return CassandraDaoUtils.getAccessor(context, ItemAccessor.class);
    }

    private static final class ItemField {
        private static final String ITEM_ID = "item_id";
        private static final String ITEM_INFO = "item_info";
        private static final String CREATION_TIME = "creation_time";
        private static final String MODIFICATION_TIME = "modification_time";

        private ItemField() {
        }
    }

    @Accessor
    static interface ItemAccessor {
        @Query(value="INSERT INTO item (item_id, item_info, creation_time, modification_time) VALUES (?,?,?,?)")
        public void create(String var1, String var2, Date var3, Date var4);

        @Query(value="INSERT INTO item (item_id, item_info,modification_time) VALUES (?,?,?)")
        public void update(String var1, String var2, Date var3);

        @Query(value="INSERT INTO item (item_id, modification_time) VALUES (?,?)")
        public void updateModificationTime(String var1, Date var2);

        @Query(value="DELETE FROM item WHERE item_id=?")
        public void delete(String var1);

        @Query(value="SELECT item_id, item_info, creation_time, modification_time FROM item WHERE item_id=?")
        public ResultSet get(String var1);

        @Query(value="SELECT item_id, item_info , creation_time, modification_time FROM item")
        public ResultSet list();
    }
}

