/*
 * Decompiled with CFR 0.152.
 */
package com.amdocs.zusammen.plugin.statestore.cassandra.dao.impl;

import com.amdocs.zusammen.datatypes.Id;
import com.amdocs.zusammen.datatypes.SessionContext;
import com.amdocs.zusammen.datatypes.item.Info;
import com.amdocs.zusammen.datatypes.item.ItemVersion;
import com.amdocs.zusammen.datatypes.item.ItemVersionData;
import com.amdocs.zusammen.datatypes.item.Relation;
import com.amdocs.zusammen.plugin.statestore.cassandra.dao.VersionDao;
import com.amdocs.zusammen.plugin.statestore.cassandra.dao.impl.CassandraDaoUtils;
import com.amdocs.zusammen.utils.fileutils.json.JsonUtil;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.mapping.annotations.Accessor;
import com.datastax.driver.mapping.annotations.Query;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class VersionCassandraDao
implements VersionDao {
    @Override
    public void create(SessionContext context, String space, Id itemId, Id baseVersionId, Id versionId, ItemVersionData data, Date creationTime) {
        String baseVersion = baseVersionId != null ? baseVersionId.toString() : null;
        this.getAccessor(context).create(space, itemId.toString(), versionId.toString(), baseVersion, creationTime, creationTime, JsonUtil.object2Json((Object)data.getInfo()), JsonUtil.object2Json((Object)data.getRelations()));
    }

    @Override
    public void update(SessionContext context, String space, Id itemId, Id versionId, ItemVersionData data, Date modificationTime) {
        this.getAccessor(context).update(JsonUtil.object2Json((Object)data.getInfo()), JsonUtil.object2Json((Object)data.getRelations()), modificationTime, space, itemId.toString(), versionId.toString());
    }

    @Override
    public void delete(SessionContext context, String space, Id itemId, Id versionId) {
        this.getAccessor(context).delete(space, itemId.toString(), versionId.toString());
    }

    @Override
    public void updateItemVersionModificationTime(SessionContext context, String space, Id itemId, Id versionId, Date modificationTime) {
        this.getAccessor(context).updateModificationTime(modificationTime, space, itemId.toString(), versionId.toString());
    }

    @Override
    public Collection<ItemVersion> list(SessionContext context, String space, Id itemId) {
        List rows = this.getAccessor(context).list(space, itemId.toString()).all();
        return rows == null ? new ArrayList<ItemVersion>() : (Collection)rows.stream().map(this::createItemVersion).collect(Collectors.toList());
    }

    @Override
    public Optional<ItemVersion> get(SessionContext context, String space, Id itemId, Id versionId) {
        Row row = this.getAccessor(context).get(space, itemId.toString(), versionId.toString()).one();
        return row == null ? Optional.empty() : Optional.of(this.createItemVersion(row));
    }

    private ItemVersion createItemVersion(Row row) {
        ItemVersion itemVersion = new ItemVersion();
        itemVersion.setId(new Id(row.getString("version_id")));
        itemVersion.setBaseId(new Id(row.getString("base_version_id")));
        itemVersion.setData(new ItemVersionData());
        itemVersion.getData().setInfo((Info)JsonUtil.json2Object((String)row.getString("info"), Info.class));
        itemVersion.getData().setRelations((Collection)JsonUtil.json2Object((String)row.getString("relations"), (Type)new TypeToken<ArrayList<Relation>>(){}.getType()));
        itemVersion.setCreationTime(row.getTimestamp("creation_time"));
        itemVersion.setModificationTime(row.getTimestamp("modification_time"));
        return itemVersion;
    }

    private VersionAccessor getAccessor(SessionContext context) {
        return CassandraDaoUtils.getAccessor(context, VersionAccessor.class);
    }

    private static final class VersionField {
        private static final String VERSION_ID = "version_id";
        private static final String BASE_VERSION_ID = "base_version_id";
        private static final String INFO = "info";
        private static final String RELATIONS = "relations";
        private static final String CREATION_TIME = "creation_time";
        private static final String MODIFICATION_TIME = "modification_time";

        private VersionField() {
        }
    }

    @Accessor
    static interface VersionAccessor {
        @Query(value="INSERT INTO version (space, item_id, version_id, base_version_id, creation_time, modification_time, info, relations) VALUES (?, ?, ?, ?, ?, ?, ?, ?)")
        public void create(String var1, String var2, String var3, String var4, Date var5, Date var6, String var7, String var8);

        @Query(value="UPDATE version SET info=?, relations=? ,modification_time= ? WHERE space=? AND item_id=? AND version_id=?")
        public void update(String var1, String var2, Date var3, String var4, String var5, String var6);

        @Query(value="UPDATE version SET modification_time=? WHERE space=? AND item_id=? AND version_id=? ")
        public void updateModificationTime(Date var1, String var2, String var3, String var4);

        @Query(value="DELETE FROM version WHERE space=? AND item_id=? AND version_id=?")
        public void delete(String var1, String var2, String var3);

        @Query(value="SELECT version_id, base_version_id, info, relations, creation_time, modification_time FROM version WHERE space=? AND item_id=? AND version_id=?")
        public ResultSet get(String var1, String var2, String var3);

        @Query(value="SELECT version_id, base_version_id, info, relations, creation_time, modification_time FROM version WHERE space=? AND item_id=?")
        public ResultSet list(String var1, String var2);
    }
}

