/*
 * Decompiled with CFR 0.152.
 */
package com.amdocs.zusammen.adaptor.inbound.api.types.item;

import com.amdocs.zusammen.adaptor.inbound.api.types.item.Element;
import com.amdocs.zusammen.datatypes.Id;
import com.amdocs.zusammen.datatypes.item.Action;
import com.amdocs.zusammen.datatypes.item.Info;
import com.amdocs.zusammen.datatypes.item.Relation;
import com.amdocs.zusammen.utils.fileutils.FileUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;

public class ZusammenElement
implements Element {
    private Action action;
    private Id elementId;
    private Info info;
    private Collection<Relation> relations;
    private byte[] data;
    private byte[] searchableData;
    private byte[] visualization;
    private Collection<Element> subElements = new ArrayList<Element>();

    @Override
    public Action getAction() {
        return this.action;
    }

    @Override
    public Id getElementId() {
        return this.elementId;
    }

    @Override
    public Info getInfo() {
        return this.info;
    }

    @Override
    public Collection<Relation> getRelations() {
        return this.relations;
    }

    @Override
    public InputStream getData() {
        return FileUtils.toInputStream((byte[])this.data);
    }

    @Override
    public InputStream getSearchableData() {
        return FileUtils.toInputStream((byte[])this.searchableData);
    }

    @Override
    public InputStream getVisualization() {
        return FileUtils.toInputStream((byte[])this.visualization);
    }

    @Override
    public Collection<Element> getSubElements() {
        return this.subElements;
    }

    public void setInfo(Info info) {
        this.info = info;
    }

    public void setElementId(Id elementId) {
        this.elementId = elementId;
    }

    public void setData(InputStream data) {
        this.data = FileUtils.toByteArray((InputStream)data);
    }

    public void setRelations(Collection<Relation> relations) {
        this.relations = relations;
    }

    public void setSearchableData(InputStream searchableData) {
        this.searchableData = FileUtils.toByteArray((InputStream)searchableData);
    }

    public void setVisualization(InputStream visualization) {
        this.visualization = FileUtils.toByteArray((InputStream)visualization);
    }

    public void setSubElements(Collection<Element> subElements) {
        this.subElements = subElements;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public ZusammenElement addSubElement(Element element) {
        this.subElements.add(element);
        return this;
    }
}

