/*
 * Decompiled with CFR 0.152.
 */
package com.amdocs.zusammen.adaptor.outbound.impl;

import com.amdocs.zusammen.adaptor.outbound.api.CollaborationAdaptor;
import com.amdocs.zusammen.adaptor.outbound.impl.convertor.CollaborationElementConvertor;
import com.amdocs.zusammen.adaptor.outbound.impl.convertor.CollaborationItemVersionConflictConvertor;
import com.amdocs.zusammen.adaptor.outbound.impl.convertor.CollaborationMergeChangeConvertor;
import com.amdocs.zusammen.adaptor.outbound.impl.convertor.CollaborationMergeResultConvertor;
import com.amdocs.zusammen.adaptor.outbound.impl.convertor.CollaborationPublishResultConvertor;
import com.amdocs.zusammen.core.api.types.CoreElement;
import com.amdocs.zusammen.core.api.types.CoreElementConflict;
import com.amdocs.zusammen.core.api.types.CoreItemVersionConflict;
import com.amdocs.zusammen.core.api.types.CoreMergeChange;
import com.amdocs.zusammen.core.api.types.CoreMergeResult;
import com.amdocs.zusammen.core.api.types.CorePublishResult;
import com.amdocs.zusammen.datatypes.Id;
import com.amdocs.zusammen.datatypes.Namespace;
import com.amdocs.zusammen.datatypes.SessionContext;
import com.amdocs.zusammen.datatypes.Space;
import com.amdocs.zusammen.datatypes.item.ElementContext;
import com.amdocs.zusammen.datatypes.item.Info;
import com.amdocs.zusammen.datatypes.item.ItemVersion;
import com.amdocs.zusammen.datatypes.item.ItemVersionData;
import com.amdocs.zusammen.datatypes.item.ItemVersionStatus;
import com.amdocs.zusammen.datatypes.item.Resolution;
import com.amdocs.zusammen.datatypes.itemversion.ItemVersionRevisions;
import com.amdocs.zusammen.datatypes.itemversion.Revision;
import com.amdocs.zusammen.datatypes.itemversion.Tag;
import com.amdocs.zusammen.datatypes.response.Module;
import com.amdocs.zusammen.datatypes.response.Response;
import com.amdocs.zusammen.datatypes.response.ReturnCode;
import com.amdocs.zusammen.datatypes.response.ZusammenException;
import com.amdocs.zusammen.sdk.collaboration.CollaborationStore;
import com.amdocs.zusammen.sdk.collaboration.CollaborationStoreFactory;
import com.amdocs.zusammen.sdk.collaboration.types.CollaborationElement;
import com.amdocs.zusammen.sdk.collaboration.types.CollaborationElementConflict;
import com.amdocs.zusammen.sdk.collaboration.types.CollaborationItemVersionConflict;
import com.amdocs.zusammen.sdk.collaboration.types.CollaborationMergeChange;
import com.amdocs.zusammen.sdk.collaboration.types.CollaborationMergeResult;
import com.amdocs.zusammen.sdk.collaboration.types.CollaborationPublishResult;
import java.util.Collection;
import java.util.stream.Collectors;

public class CollaborationAdaptorImpl
implements CollaborationAdaptor {
    private CollaborationStore getCollaborationStore(SessionContext context) {
        return CollaborationStoreFactory.getInstance().createInterface(context);
    }

    public Response<Void> createItem(SessionContext context, Id itemId, Info itemInfo) {
        try {
            Response response = this.getCollaborationStore(context).createItem(context, itemId, itemInfo);
            if (response.isSuccessful()) {
                return response;
            }
            ReturnCode returnCode = new ReturnCode(20300, Module.ZCSM, null, response.getReturnCode());
            throw new ZusammenException(returnCode);
        }
        catch (RuntimeException e) {
            ReturnCode returnCode = new ReturnCode(20300, Module.ZCSM, null, new ReturnCode(30400, Module.ZCSP, e.getMessage(), null));
            throw new ZusammenException(returnCode);
        }
    }

    public Response<Void> updateItem(SessionContext context, Id itemId, Info itemInfo) {
        return new Response(Void.TYPE);
    }

    public Response<Void> deleteItem(SessionContext context, Id itemId) {
        Response response;
        try {
            response = this.getCollaborationStore(context).deleteItem(context, itemId);
        }
        catch (RuntimeException re) {
            ReturnCode returnCode = new ReturnCode(20200, Module.ZCSM, null, new ReturnCode(30500, Module.ZCSP, re.getMessage(), null));
            throw new ZusammenException(returnCode);
        }
        if (response.isSuccessful()) {
            return response;
        }
        ReturnCode returnCode = new ReturnCode(20200, Module.ZCSM, null, response.getReturnCode());
        throw new ZusammenException(returnCode);
    }

    public Response<Void> createItemVersion(SessionContext context, Id itemId, Id baseVersionId, Id versionId, ItemVersionData data) {
        Response response;
        try {
            response = this.getCollaborationStore(context).createItemVersion(context, itemId, baseVersionId, versionId, data);
        }
        catch (RuntimeException re) {
            ReturnCode returnCode = new ReturnCode(21000, Module.ZCSM, null, new ReturnCode(30200, Module.ZCSP, re.getMessage(), null));
            throw new ZusammenException(returnCode);
        }
        if (response.isSuccessful()) {
            return response;
        }
        ReturnCode returnCode = new ReturnCode(21000, Module.ZCSM, null, response.getReturnCode());
        throw new ZusammenException(returnCode);
    }

    public Response<Void> updateItemVersion(SessionContext context, Id itemId, Id versionId, ItemVersionData data) {
        Response response;
        try {
            response = this.getCollaborationStore(context).updateItemVersion(context, itemId, versionId, data);
        }
        catch (RuntimeException re) {
            ReturnCode returnCode = new ReturnCode(21100, Module.ZCSM, null, new ReturnCode(30100, Module.ZCSP, re.getMessage(), null));
            throw new ZusammenException(returnCode);
        }
        if (response.isSuccessful()) {
            return response;
        }
        ReturnCode returnCode = new ReturnCode(21100, Module.ZCSM, null, response.getReturnCode());
        throw new ZusammenException(returnCode);
    }

    public Response<Void> deleteItemVersion(SessionContext context, Id itemId, Id versionId) {
        Response response;
        try {
            response = this.getCollaborationStore(context).deleteItemVersion(context, itemId, versionId);
        }
        catch (RuntimeException re) {
            ReturnCode returnCode = new ReturnCode(21200, Module.ZCSM, null, new ReturnCode(30300, Module.ZCSP, re.getMessage(), null));
            throw new ZusammenException(returnCode);
        }
        if (response.isSuccessful()) {
            return response;
        }
        ReturnCode returnCode = new ReturnCode(21200, Module.ZCSM, null, response.getReturnCode());
        throw new ZusammenException(returnCode);
    }

    public Response<ItemVersionStatus> getItemVersionStatus(SessionContext context, Id itemId, Id versionId) {
        Response collaborationResponse;
        try {
            collaborationResponse = this.getCollaborationStore(context).getItemVersionStatus(context, itemId, versionId);
        }
        catch (RuntimeException re) {
            ReturnCode returnCode = new ReturnCode(23100, Module.ZCSM, null, new ReturnCode(32000, Module.ZCSP, re.getMessage(), null));
            throw new ZusammenException(returnCode);
        }
        if (!collaborationResponse.isSuccessful()) {
            ReturnCode returnCode = new ReturnCode(23100, Module.ZCSM, null, collaborationResponse.getReturnCode());
            throw new ZusammenException(returnCode);
        }
        return new Response(collaborationResponse.getValue());
    }

    public Response<Void> tagItemVersion(SessionContext context, Id itemId, Id versionId, Id changeId, Tag tag) {
        Response response;
        try {
            response = this.getCollaborationStore(context).tagItemVersion(context, itemId, versionId, changeId, tag);
        }
        catch (RuntimeException re) {
            ReturnCode returnCode = new ReturnCode(22900, Module.ZCSM, null, new ReturnCode(31500, Module.ZCSP, re.getMessage(), null));
            throw new ZusammenException(returnCode);
        }
        if (response.isSuccessful()) {
            return response;
        }
        ReturnCode returnCode = new ReturnCode(22900, Module.ZCSM, null, response.getReturnCode());
        throw new ZusammenException(returnCode);
    }

    public Response<CorePublishResult> publishItemVersion(SessionContext context, Id itemId, Id versionId, String message) {
        Response collaborationResponse;
        try {
            collaborationResponse = this.getCollaborationStore(context).publishItemVersion(context, itemId, versionId, message);
        }
        catch (RuntimeException re) {
            ReturnCode returnCode = new ReturnCode(21900, Module.ZCSM, null, new ReturnCode(31000, Module.ZCSP, re.getMessage(), null));
            throw new ZusammenException(returnCode);
        }
        if (!collaborationResponse.isSuccessful()) {
            ReturnCode returnCode = new ReturnCode(21900, Module.ZCSM, null, collaborationResponse.getReturnCode());
            throw new ZusammenException(returnCode);
        }
        CorePublishResult corePublishResult = CollaborationPublishResultConvertor.convert((CollaborationPublishResult)collaborationResponse.getValue());
        return new Response((Object)corePublishResult);
    }

    public Response<CoreMergeResult> syncItemVersion(SessionContext context, Id itemId, Id versionId) {
        Response collaborationResponse;
        try {
            collaborationResponse = this.getCollaborationStore(context).syncItemVersion(context, itemId, versionId);
        }
        catch (RuntimeException re) {
            ReturnCode returnCode = new ReturnCode(22000, Module.ZCSM, null, new ReturnCode(31100, Module.ZCSP, re.getMessage(), null));
            throw new ZusammenException(returnCode);
        }
        if (!collaborationResponse.isSuccessful()) {
            ReturnCode returnCode = new ReturnCode(22000, Module.ZCSM, null, collaborationResponse.getReturnCode());
            throw new ZusammenException(returnCode);
        }
        CoreMergeResult coreMergeResult = CollaborationMergeResultConvertor.convert((CollaborationMergeResult)collaborationResponse.getValue());
        return new Response((Object)coreMergeResult);
    }

    public Response<CoreMergeResult> forceSyncItemVersion(SessionContext context, Id itemId, Id versionId) {
        Response collaborationResponse;
        try {
            collaborationResponse = this.getCollaborationStore(context).forceSyncItemVersion(context, itemId, versionId);
        }
        catch (RuntimeException re) {
            ReturnCode returnCode = new ReturnCode(23300, Module.ZCSM, null, new ReturnCode(32300, Module.ZCSP, re.getMessage(), null));
            throw new ZusammenException(returnCode);
        }
        if (!collaborationResponse.isSuccessful()) {
            ReturnCode returnCode = new ReturnCode(23300, Module.ZCSM, null, collaborationResponse.getReturnCode());
            throw new ZusammenException(returnCode);
        }
        CoreMergeResult coreMergeResult = CollaborationMergeResultConvertor.convert((CollaborationMergeResult)collaborationResponse.getValue());
        return new Response((Object)coreMergeResult);
    }

    public Response<CoreMergeResult> mergeItemVersion(SessionContext context, Id itemId, Id versionId, Id sourceVersionId) {
        Response collaborationResponse;
        try {
            collaborationResponse = this.getCollaborationStore(context).mergeItemVersion(context, itemId, versionId, sourceVersionId);
        }
        catch (RuntimeException re) {
            ReturnCode returnCode = new ReturnCode(22100, Module.ZCSM, null, new ReturnCode(31200, Module.ZCSP, re.getMessage(), null));
            throw new ZusammenException(returnCode);
        }
        if (!collaborationResponse.isSuccessful()) {
            ReturnCode returnCode = new ReturnCode(22100, Module.ZCSM, null, collaborationResponse.getReturnCode());
            throw new ZusammenException(returnCode);
        }
        CoreMergeResult coreMergeResult = CollaborationMergeResultConvertor.convert((CollaborationMergeResult)collaborationResponse.getValue());
        return new Response((Object)coreMergeResult);
    }

    public Response<ItemVersionRevisions> listItemVersionRevisions(SessionContext context, Id itemId, Id versionId) {
        Response response;
        try {
            response = this.getCollaborationStore(context).listItemVersionRevisions(context, itemId, versionId);
        }
        catch (RuntimeException re) {
            ReturnCode returnCode = new ReturnCode(22200, Module.ZCSM, null, new ReturnCode(31300, Module.ZCSP, re.getMessage(), null));
            throw new ZusammenException(returnCode);
        }
        if (!response.isSuccessful()) {
            ReturnCode returnCode = new ReturnCode(22200, Module.ZCSM, null, response.getReturnCode());
            throw new ZusammenException(returnCode);
        }
        return response;
    }

    public Response<Revision> getItemVersionRevision(SessionContext context, Id itemId, Id versionId, Id revisionId) {
        Response response;
        try {
            response = this.getCollaborationStore(context).getItemVersionRevision(context, itemId, versionId, revisionId);
        }
        catch (RuntimeException re) {
            ReturnCode returnCode = new ReturnCode(23400, Module.ZCSM, null, new ReturnCode(32400, Module.ZCSP, re.getMessage(), null));
            throw new ZusammenException(returnCode);
        }
        if (!response.isSuccessful()) {
            ReturnCode returnCode = new ReturnCode(23400, Module.ZCSM, null, response.getReturnCode());
            throw new ZusammenException(returnCode);
        }
        return response;
    }

    public Response<CoreMergeChange> resetItemVersionRevision(SessionContext context, Id itemId, Id versionId, Id revisionId) {
        Response collaborationResponse;
        try {
            collaborationResponse = this.getCollaborationStore(context).resetItemVersionRevision(context, itemId, versionId, revisionId);
        }
        catch (RuntimeException re) {
            ReturnCode returnCode = new ReturnCode(22300, Module.ZCSM, null, new ReturnCode(31400, Module.ZCSP, re.getMessage(), null));
            throw new ZusammenException(returnCode);
        }
        if (collaborationResponse.isSuccessful()) {
            return new Response((Object)CollaborationMergeChangeConvertor.convertToCoreMergeChange((CollaborationMergeChange)collaborationResponse.getValue()));
        }
        ReturnCode returnCode = new ReturnCode(22300, Module.ZCSM, null, collaborationResponse.getReturnCode());
        throw new ZusammenException(returnCode);
    }

    public Response<CoreMergeChange> revertItemVersionRevision(SessionContext context, Id itemId, Id versionId, Id revisionId) {
        Response collaborationResponse;
        try {
            collaborationResponse = this.getCollaborationStore(context).revertItemVersionRevision(context, itemId, versionId, revisionId);
        }
        catch (RuntimeException re) {
            ReturnCode returnCode = new ReturnCode(23200, Module.ZCSM, null, new ReturnCode(32100, Module.ZCSP, re.getMessage(), null));
            throw new ZusammenException(returnCode);
        }
        if (collaborationResponse.isSuccessful()) {
            return new Response((Object)CollaborationMergeChangeConvertor.convertToCoreMergeChange((CollaborationMergeChange)collaborationResponse.getValue()));
        }
        ReturnCode returnCode = new ReturnCode(23200, Module.ZCSM, null, collaborationResponse.getReturnCode());
        throw new ZusammenException(returnCode);
    }

    public Response<CoreItemVersionConflict> getItemVersionConflict(SessionContext context, Id itemId, Id versionId) {
        Response collaborationResponse;
        try {
            collaborationResponse = this.getCollaborationStore(context).getItemVersionConflict(context, itemId, versionId);
        }
        catch (RuntimeException re) {
            ReturnCode returnCode = new ReturnCode(22700, Module.ZCSM, null, new ReturnCode(31800, Module.ZCSP, re.getMessage(), null));
            throw new ZusammenException(returnCode);
        }
        if (!collaborationResponse.isSuccessful()) {
            ReturnCode returnCode = new ReturnCode(22700, Module.ZCSM, null, collaborationResponse.getReturnCode());
            throw new ZusammenException(returnCode);
        }
        return new Response((Object)CollaborationItemVersionConflictConvertor.convertToCoreItemVersionConflict((CollaborationItemVersionConflict)collaborationResponse.getValue()));
    }

    public Response<Void> commitElements(SessionContext context, ElementContext elementContext, String message) {
        Response response = this.getCollaborationStore(context).commitElements(context, elementContext.getItemId(), elementContext.getVersionId(), message);
        if (!response.isSuccessful()) {
            ReturnCode returnCode = new ReturnCode(22500, Module.ZCSM, null, response.getReturnCode());
            throw new ZusammenException(returnCode);
        }
        return response;
    }

    public Response<Collection<CoreElement>> listElements(SessionContext context, ElementContext elementContext, Namespace namespace, Id elementId) {
        Response collaborationResponse;
        try {
            collaborationResponse = this.getCollaborationStore(context).listElements(context, elementContext, namespace, elementId);
        }
        catch (RuntimeException re) {
            ReturnCode returnCode = new ReturnCode(22600, Module.ZCSM, null, new ReturnCode(31600, Module.ZCSP, re.getMessage(), null));
            throw new ZusammenException(returnCode);
        }
        if (!collaborationResponse.isSuccessful()) {
            ReturnCode returnCode = new ReturnCode(22600, Module.ZCSM, null, collaborationResponse.getReturnCode());
            throw new ZusammenException(returnCode);
        }
        return new Response(((Collection)collaborationResponse.getValue()).stream().map(CollaborationElementConvertor::convertToCoreElement).collect(Collectors.toList()));
    }

    public Response<CoreElement> getElement(SessionContext context, ElementContext elementContext, Namespace namespace, Id elementId) {
        Response collaborationResponse;
        try {
            collaborationResponse = this.getCollaborationStore(context).getElement(context, elementContext, namespace, elementId);
        }
        catch (RuntimeException re) {
            ReturnCode returnCode = new ReturnCode(21500, Module.ZCSM, null, new ReturnCode(30700, Module.ZCSP, re.getMessage(), null));
            throw new ZusammenException(returnCode);
        }
        if (!collaborationResponse.isSuccessful()) {
            ReturnCode returnCode = new ReturnCode(21500, Module.ZCSM, null, collaborationResponse.getReturnCode());
            throw new ZusammenException(returnCode);
        }
        return new Response((Object)CollaborationElementConvertor.convertToCoreElement((CollaborationElement)collaborationResponse.getValue()));
    }

    public Response<CoreElementConflict> getElementConflict(SessionContext context, ElementContext elementContext, Namespace namespace, Id elementId) {
        Response collaborationResponse;
        try {
            collaborationResponse = this.getCollaborationStore(context).getElementConflict(context, elementContext, namespace, elementId);
        }
        catch (RuntimeException re) {
            ReturnCode returnCode = new ReturnCode(22800, Module.ZCSM, null, new ReturnCode(31700, Module.ZCSP, re.getMessage(), null));
            throw new ZusammenException(returnCode);
        }
        if (!collaborationResponse.isSuccessful()) {
            ReturnCode returnCode = new ReturnCode(22800, Module.ZCSM, null, collaborationResponse.getReturnCode());
            throw new ZusammenException(returnCode);
        }
        return new Response((Object)CollaborationElementConvertor.convertToCoreElement((CollaborationElementConflict)collaborationResponse.getValue()));
    }

    public Response<Void> createElement(SessionContext context, ElementContext elementContext, CoreElement element) {
        Response response;
        try {
            response = this.getCollaborationStore(context).createElement(context, CollaborationElementConvertor.convertFromCoreElement(element, elementContext));
        }
        catch (RuntimeException re) {
            ReturnCode returnCode = new ReturnCode(21600, Module.ZCSM, null, new ReturnCode(30800, Module.ZCSP, re.getMessage(), null));
            throw new ZusammenException(returnCode);
        }
        if (!response.isSuccessful()) {
            ReturnCode returnCode = new ReturnCode(21600, Module.ZCSM, null, response.getReturnCode());
            throw new ZusammenException(returnCode);
        }
        return response;
    }

    public Response<Void> updateElement(SessionContext context, ElementContext elementContext, CoreElement element) {
        Response response;
        try {
            response = this.getCollaborationStore(context).updateElement(context, CollaborationElementConvertor.convertFromCoreElement(element, elementContext));
        }
        catch (RuntimeException re) {
            ReturnCode returnCode = new ReturnCode(21700, Module.ZCSM, null, new ReturnCode(30600, Module.ZCSP, re.getMessage(), null));
            throw new ZusammenException(returnCode);
        }
        if (!response.isSuccessful()) {
            ReturnCode returnCode = new ReturnCode(21700, Module.ZCSM, null, response.getReturnCode());
            throw new ZusammenException(returnCode);
        }
        return response;
    }

    public Response<Void> deleteElement(SessionContext context, ElementContext elementContext, CoreElement element) {
        Response response;
        try {
            response = this.getCollaborationStore(context).deleteElement(context, CollaborationElementConvertor.convertFromCoreElement(element, elementContext));
        }
        catch (RuntimeException re) {
            ReturnCode returnCode = new ReturnCode(21800, Module.ZCSM, null, new ReturnCode(30900, Module.ZCSP, re.getMessage(), null));
            throw new ZusammenException(returnCode);
        }
        if (!response.isSuccessful()) {
            ReturnCode returnCode = new ReturnCode(21800, Module.ZCSM, null, response.getReturnCode());
            throw new ZusammenException(returnCode);
        }
        return response;
    }

    public Response<CoreMergeResult> resolveElementConflict(SessionContext context, ElementContext elementContext, CoreElement element, Resolution resolution) {
        Response response;
        try {
            response = this.getCollaborationStore(context).resolveElementConflict(context, CollaborationElementConvertor.convertFromCoreElement(element, elementContext), resolution);
        }
        catch (RuntimeException re) {
            ReturnCode returnCode = new ReturnCode(23000, Module.ZCSM, null, new ReturnCode(31900, Module.ZCSP, re.getMessage(), null));
            throw new ZusammenException(returnCode);
        }
        if (!response.isSuccessful()) {
            ReturnCode returnCode = new ReturnCode(23000, Module.ZCSM, null, response.getReturnCode());
            throw new ZusammenException(returnCode);
        }
        return new Response((Object)CollaborationMergeResultConvertor.convert((CollaborationMergeResult)response.getValue()));
    }

    public Response<ItemVersion> getItemVersion(SessionContext context, Space space, Id itemId, Id versionId, Id revisionId) {
        Response collaborationResponse;
        try {
            collaborationResponse = this.getCollaborationStore(context).getItemVersion(context, space, itemId, versionId, revisionId);
        }
        catch (RuntimeException re) {
            ReturnCode returnCode = new ReturnCode(20900, Module.ZCSM, null, new ReturnCode(32200, Module.ZCSP, re.getMessage(), null));
            throw new ZusammenException(returnCode);
        }
        if (!collaborationResponse.isSuccessful()) {
            ReturnCode returnCode = new ReturnCode(20900, Module.ZCSM, null, collaborationResponse.getReturnCode());
            throw new ZusammenException(returnCode);
        }
        return collaborationResponse;
    }
}

