/*
 * Decompiled with CFR 0.152.
 */
package com.amdocs.zusammen.adaptor.outbound.impl;

import com.amdocs.zusammen.adaptor.outbound.api.SearchIndexAdaptor;
import com.amdocs.zusammen.adaptor.outbound.impl.convertor.SearchIndexElementConvertor;
import com.amdocs.zusammen.core.api.types.CoreElement;
import com.amdocs.zusammen.datatypes.SessionContext;
import com.amdocs.zusammen.datatypes.Space;
import com.amdocs.zusammen.datatypes.item.ElementContext;
import com.amdocs.zusammen.datatypes.response.Module;
import com.amdocs.zusammen.datatypes.response.Response;
import com.amdocs.zusammen.datatypes.response.ReturnCode;
import com.amdocs.zusammen.datatypes.response.ZusammenException;
import com.amdocs.zusammen.datatypes.searchindex.SearchCriteria;
import com.amdocs.zusammen.datatypes.searchindex.SearchResult;
import com.amdocs.zusammen.sdk.searchindex.SearchIndex;
import com.amdocs.zusammen.sdk.searchindex.SearchIndexFactory;

public class SearchIndexAdaptorImpl
implements SearchIndexAdaptor {
    public Response<Void> createElement(SessionContext context, ElementContext elementContext, Space space, CoreElement element) {
        try {
            Response response = this.getSearchIndex(context).createElement(context, SearchIndexElementConvertor.convertFromCoreElement(elementContext, element, space));
            if (response.isSuccessful()) {
                return response;
            }
            ReturnCode returnCode = new ReturnCode(21600, Module.ZSIM, null, response.getReturnCode());
            throw new ZusammenException(returnCode);
        }
        catch (RuntimeException re) {
            ReturnCode returnCode = new ReturnCode(21600, Module.ZSIM, null, new ReturnCode(40200, Module.ZSIP, re.getMessage(), null));
            throw new ZusammenException(returnCode);
        }
    }

    public Response<Void> updateElement(SessionContext context, ElementContext elementContext, Space space, CoreElement element) {
        try {
            Response response = this.getSearchIndex(context).updateElement(context, SearchIndexElementConvertor.convertFromCoreElement(elementContext, element, space));
            if (response.isSuccessful()) {
                return response;
            }
            ReturnCode returnCode = new ReturnCode(21700, Module.ZSIM, null, response.getReturnCode());
            throw new ZusammenException(returnCode);
        }
        catch (RuntimeException re) {
            ReturnCode returnCode = new ReturnCode(21700, Module.ZSIM, null, new ReturnCode(40400, Module.ZSIP, re.getMessage(), null));
            throw new ZusammenException(returnCode);
        }
    }

    public Response<Void> deleteElement(SessionContext context, ElementContext elementContext, Space space, CoreElement element) {
        try {
            Response response = this.getSearchIndex(context).deleteElement(context, SearchIndexElementConvertor.convertFromCoreElement(elementContext, element, space));
            if (response.isSuccessful()) {
                return response;
            }
            ReturnCode returnCode = new ReturnCode(21800, Module.ZSIM, null, response.getReturnCode());
            throw new ZusammenException(returnCode);
        }
        catch (RuntimeException re) {
            ReturnCode returnCode = new ReturnCode(21800, Module.ZSIM, null, new ReturnCode(40300, Module.ZSIP, re.getMessage(), null));
            throw new ZusammenException(returnCode);
        }
    }

    public Response<SearchResult> search(SessionContext context, SearchCriteria searchCriteria) {
        try {
            Response response = this.getSearchIndex(context).search(context, searchCriteria);
            if (response.isSuccessful()) {
                return response;
            }
            ReturnCode returnCode = new ReturnCode(22400, Module.ZSIM, null, response.getReturnCode());
            throw new ZusammenException(returnCode);
        }
        catch (RuntimeException re) {
            ReturnCode returnCode = new ReturnCode(22400, Module.ZSIM, null, new ReturnCode(40100, Module.ZSIP, re.getMessage(), null));
            throw new ZusammenException(returnCode);
        }
    }

    private SearchIndex getSearchIndex(SessionContext context) {
        return SearchIndexFactory.getInstance().createInterface(context);
    }
}

