/*
 * Decompiled with CFR 0.152.
 */
package com.amdocs.zusammen.adaptor.outbound.impl.convertor;

import com.amdocs.zusammen.core.api.types.CoreElement;
import com.amdocs.zusammen.core.api.types.CoreElementInfo;
import com.amdocs.zusammen.datatypes.Id;
import com.amdocs.zusammen.datatypes.Space;
import com.amdocs.zusammen.datatypes.item.ElementContext;
import com.amdocs.zusammen.sdk.state.types.StateElement;
import java.util.Collection;
import java.util.stream.Collectors;

public class StateElementConvertor {
    public static StateElement convertFromCoreElement(ElementContext elementContext, Space space, CoreElement element) {
        StateElement stateElement = new StateElement(elementContext.getItemId(), elementContext.getVersionId(), element.getNamespace(), element.getId());
        stateElement.setSpace(space);
        stateElement.setParentId(element.getParentId());
        stateElement.setInfo(element.getInfo());
        stateElement.setRelations(element.getRelations());
        return stateElement;
    }

    public static CoreElementInfo convertToCoreElementInfo(StateElement element) {
        CoreElementInfo elementInfo = StateElementConvertor.convertToCoreElementInfo(element.getId());
        elementInfo.setParentId(element.getParentId());
        elementInfo.setNamespace(element.getNamespace());
        elementInfo.setRelations(element.getRelations());
        elementInfo.setInfo(element.getInfo());
        if (element.getSubElements() != null && !element.getSubElements().isEmpty()) {
            elementInfo.setSubElements((Collection)element.getSubElements().stream().map(StateElementConvertor::convertToCoreElementInfo).collect(Collectors.toList()));
        }
        return elementInfo;
    }

    private static CoreElementInfo convertToCoreElementInfo(Id elementId) {
        CoreElementInfo coreElementInfo = new CoreElementInfo();
        coreElementInfo.setId(elementId);
        return coreElementInfo;
    }
}

