/*
 * Decompiled with CFR 0.152.
 */
package com.amdocs.zusammen.adaptor.outbound.impl.item;

import com.amdocs.zusammen.adaptor.outbound.api.item.ElementStateAdaptor;
import com.amdocs.zusammen.adaptor.outbound.impl.OutboundAdaptorUtils;
import com.amdocs.zusammen.adaptor.outbound.impl.convertor.StateElementConvertor;
import com.amdocs.zusammen.core.api.types.CoreElement;
import com.amdocs.zusammen.core.api.types.CoreElementInfo;
import com.amdocs.zusammen.datatypes.Id;
import com.amdocs.zusammen.datatypes.Namespace;
import com.amdocs.zusammen.datatypes.SessionContext;
import com.amdocs.zusammen.datatypes.Space;
import com.amdocs.zusammen.datatypes.item.ElementContext;
import com.amdocs.zusammen.datatypes.response.Module;
import com.amdocs.zusammen.datatypes.response.Response;
import com.amdocs.zusammen.datatypes.response.ReturnCode;
import com.amdocs.zusammen.sdk.state.types.StateElement;
import java.util.Collection;
import java.util.stream.Collectors;

public class ElementStateAdaptorImpl
implements ElementStateAdaptor {
    public Response<Collection<CoreElementInfo>> list(SessionContext context, ElementContext elementContext, Id elementId) {
        Response response;
        try {
            Response plugintResponse = OutboundAdaptorUtils.getStateStore(context).listElements(context, elementContext, elementId);
            response = plugintResponse.isSuccessful() ? new Response(((Collection)plugintResponse.getValue()).stream().map(StateElementConvertor::convertToCoreElementInfo).collect(Collectors.toList())) : new Response(new ReturnCode(21300, Module.ZSTM, null, plugintResponse.getReturnCode()));
        }
        catch (RuntimeException rte) {
            response = new Response(new ReturnCode(21300, Module.ZSTM, null, new ReturnCode(52100, Module.ZMDP, rte.getMessage(), null)));
        }
        return response;
    }

    public Response<Boolean> isExist(SessionContext context, ElementContext elementContext, Id elementId) {
        Response response;
        try {
            response = OutboundAdaptorUtils.getStateStore(context).isElementExist(context, elementContext, elementId);
            if (!response.isSuccessful()) {
                response = new Response(new ReturnCode(21400, Module.ZSTM, null, response.getReturnCode()));
            }
        }
        catch (RuntimeException rte) {
            response = new Response(new ReturnCode(21400, Module.ZSTM, null, new ReturnCode(52200, Module.ZMDP, rte.getMessage(), null)));
        }
        return response;
    }

    public Response<Namespace> getNamespace(SessionContext context, Id itemId, Id elementId) {
        Response response;
        try {
            Response pluginResponse = OutboundAdaptorUtils.getStateStore(context).getElementNamespace(context, itemId, elementId);
            response = pluginResponse.isSuccessful() ? pluginResponse : new Response(new ReturnCode(21500, Module.ZSTM, null, pluginResponse.getReturnCode()));
        }
        catch (RuntimeException rte) {
            response = new Response(new ReturnCode(21500, Module.ZSTM, null, new ReturnCode(51300, Module.ZMDP, rte.getMessage(), null)));
        }
        return response;
    }

    public Response<CoreElementInfo> get(SessionContext context, ElementContext elementContext, Id elementId) {
        Response response;
        try {
            Response pluginResponse = OutboundAdaptorUtils.getStateStore(context).getElement(context, elementContext, elementId);
            response = pluginResponse.isSuccessful() ? new Response((Object)StateElementConvertor.convertToCoreElementInfo((StateElement)pluginResponse.getValue())) : new Response(new ReturnCode(21500, Module.ZSTM, null, pluginResponse.getReturnCode()));
        }
        catch (RuntimeException rte) {
            response = new Response(new ReturnCode(21500, Module.ZSTM, null, new ReturnCode(51300, Module.ZMDP, rte.getMessage(), null)));
        }
        return response;
    }

    public Response<Void> create(SessionContext context, ElementContext elementContext, Space space, CoreElement element) {
        Response response;
        StateElement elementInfo = StateElementConvertor.convertFromCoreElement(elementContext, space, element);
        try {
            response = OutboundAdaptorUtils.getStateStore(context).createElement(context, elementInfo);
            if (!response.isSuccessful()) {
                response = new Response(new ReturnCode(21600, Module.ZSTM, null, response.getReturnCode()));
            }
        }
        catch (RuntimeException rte) {
            response = new Response(new ReturnCode(21600, Module.ZSTM, null, new ReturnCode(51400, Module.ZMDP, rte.getMessage(), null)));
        }
        return response;
    }

    public Response<Void> update(SessionContext context, ElementContext elementContext, Space space, CoreElement element) {
        Response response;
        try {
            response = OutboundAdaptorUtils.getStateStore(context).updateElement(context, StateElementConvertor.convertFromCoreElement(elementContext, space, element));
            if (!response.isSuccessful()) {
                response = new Response(new ReturnCode(21700, Module.ZSTM, null, response.getReturnCode()));
            }
        }
        catch (RuntimeException rte) {
            response = new Response(new ReturnCode(21700, Module.ZSTM, null, new ReturnCode(51600, Module.ZMDP, rte.getMessage(), null)));
        }
        return response;
    }

    public Response<Void> delete(SessionContext context, ElementContext elementContext, Space space, CoreElement element) {
        Response response;
        try {
            response = OutboundAdaptorUtils.getStateStore(context).deleteElement(context, StateElementConvertor.convertFromCoreElement(elementContext, space, element));
            if (!response.isSuccessful()) {
                response = new Response(new ReturnCode(21800, Module.ZSTM, null, response.getReturnCode()));
            }
        }
        catch (RuntimeException rte) {
            response = new Response(new ReturnCode(21800, Module.ZSTM, null, new ReturnCode(51500, Module.ZMDP, rte.getMessage(), null)));
        }
        return response;
    }
}

