/*
 * Decompiled with CFR 0.152.
 */
package com.amdocs.zusammen.adaptor.outbound.impl.convertor;

import com.amdocs.zusammen.core.api.types.CoreElement;
import com.amdocs.zusammen.core.api.types.CoreElementConflict;
import com.amdocs.zusammen.datatypes.Id;
import com.amdocs.zusammen.datatypes.item.ElementContext;
import com.amdocs.zusammen.sdk.collaboration.types.CollaborationElement;
import com.amdocs.zusammen.sdk.collaboration.types.CollaborationElementConflict;
import java.util.Collection;
import java.util.stream.Collectors;

public class CollaborationElementConvertor {
    public static CollaborationElement convertFromCoreElement(CoreElement element, ElementContext elementContext) {
        CollaborationElement collaborationElement = new CollaborationElement(elementContext.getItemId(), elementContext.getVersionId(), element.getNamespace(), element.getId());
        collaborationElement.setParentId(element.getParentId());
        collaborationElement.setInfo(element.getInfo());
        collaborationElement.setRelations(element.getRelations());
        collaborationElement.setData(element.getData());
        collaborationElement.setSearchableData(element.getSearchableData());
        collaborationElement.setVisualization(element.getVisualization());
        return collaborationElement;
    }

    public static CoreElement convertToCoreElement(CollaborationElement element) {
        if (element == null) {
            return null;
        }
        CoreElement coreElement = CollaborationElementConvertor.convertToCoreElement(element.getId());
        coreElement.setNamespace(element.getNamespace());
        coreElement.setParentId(element.getParentId());
        coreElement.setInfo(element.getInfo());
        coreElement.setRelations(element.getRelations());
        coreElement.setData(element.getData());
        coreElement.setSearchableData(element.getSearchableData());
        coreElement.setVisualization(element.getVisualization());
        coreElement.setSubElements((Collection)element.getSubElements().stream().map(CollaborationElementConvertor::convertToCoreElement).collect(Collectors.toList()));
        return coreElement;
    }

    private static CoreElement convertToCoreElement(Id elementId) {
        CoreElement coreElement = new CoreElement();
        coreElement.setId(elementId);
        return coreElement;
    }

    public static CoreElementConflict convertToCoreElement(CollaborationElementConflict collaborationElementConflict) {
        CoreElementConflict coreElementConflict = new CoreElementConflict();
        coreElementConflict.setLocalElement(CollaborationElementConvertor.convertToCoreElement(collaborationElementConflict.getLocalElement()));
        coreElementConflict.setRemoteElement(CollaborationElementConvertor.convertToCoreElement(collaborationElementConflict.getRemoteElement()));
        return coreElementConflict;
    }
}

