/*
 * Decompiled with CFR 0.152.
 */
package com.amdocs.zusammen.adaptor.outbound.impl.health;

import com.amdocs.zusammen.adaptor.outbound.api.health.HealthAdaptor;
import com.amdocs.zusammen.commons.health.data.HealthInfo;
import com.amdocs.zusammen.commons.log.ZusammenLogger;
import com.amdocs.zusammen.commons.log.ZusammenLoggerFactory;
import com.amdocs.zusammen.datatypes.SessionContext;
import com.amdocs.zusammen.datatypes.response.Module;
import com.amdocs.zusammen.datatypes.response.ReturnCode;
import com.amdocs.zusammen.datatypes.response.ZusammenException;
import com.amdocs.zusammen.sdk.collaboration.CollaborationStore;
import com.amdocs.zusammen.sdk.collaboration.CollaborationStoreFactory;
import com.amdocs.zusammen.sdk.searchindex.SearchIndex;
import com.amdocs.zusammen.sdk.searchindex.SearchIndexFactory;
import com.amdocs.zusammen.sdk.state.StateStore;
import com.amdocs.zusammen.sdk.state.StateStoreFactory;

public class HealthAdaptorImpl
implements HealthAdaptor {
    private static final ZusammenLogger logger = ZusammenLoggerFactory.getLogger((String)HealthAdaptorImpl.class.getSimpleName());

    private CollaborationStore getCollaborationStore(SessionContext context) throws ZusammenException {
        try {
            return CollaborationStoreFactory.getInstance().createInterface(context);
        }
        catch (ZusammenException ze) {
            throw ze;
        }
        catch (Throwable t) {
            logger.error("Failed to generate adapter ", t);
            ReturnCode returnCode = new ReturnCode(50100, Module.ZHC, null, null);
            throw new ZusammenException(returnCode);
        }
    }

    private StateStore getStateStore(SessionContext context) throws ZusammenException {
        try {
            return StateStoreFactory.getInstance().createInterface(context);
        }
        catch (ZusammenException ze) {
            throw ze;
        }
        catch (Throwable t) {
            logger.error("Failed to generate adapter ", t);
            ReturnCode returnCode = new ReturnCode(50100, Module.ZHC, null, null);
            throw new ZusammenException(returnCode);
        }
    }

    private SearchIndex getSearchIndex(SessionContext context) throws ZusammenException {
        try {
            return SearchIndexFactory.getInstance().createInterface(context);
        }
        catch (ZusammenException ze) {
            throw ze;
        }
        catch (Throwable t) {
            logger.error("Failed to generate adapter ", t);
            ReturnCode returnCode = new ReturnCode(50100, Module.ZHC, null, null);
            throw new ZusammenException(returnCode);
        }
    }

    public HealthInfo getCollaborationStatus(SessionContext sessionContext) throws ZusammenException {
        return (HealthInfo)this.getCollaborationStore(sessionContext).checkHealth(sessionContext).getValue();
    }

    public HealthInfo getStateStatus(SessionContext sessionContext) throws ZusammenException {
        return (HealthInfo)this.getStateStore(sessionContext).checkHealth(sessionContext).getValue();
    }

    public HealthInfo getSearchStatus(SessionContext sessionContext) throws ZusammenException {
        return (HealthInfo)this.getSearchIndex(sessionContext).checkHealth(sessionContext).getValue();
    }
}

