/*
 * Decompiled with CFR 0.152.
 */
package com.amdocs.zusammen.adaptor.outbound.impl.item;

import com.amdocs.zusammen.adaptor.outbound.api.item.ItemStateAdaptor;
import com.amdocs.zusammen.adaptor.outbound.impl.OutboundAdaptorUtils;
import com.amdocs.zusammen.datatypes.Id;
import com.amdocs.zusammen.datatypes.SessionContext;
import com.amdocs.zusammen.datatypes.item.Info;
import com.amdocs.zusammen.datatypes.item.Item;
import com.amdocs.zusammen.datatypes.response.Module;
import com.amdocs.zusammen.datatypes.response.Response;
import com.amdocs.zusammen.datatypes.response.ReturnCode;
import java.util.Collection;
import java.util.Date;

public class ItemStateAdaptorImpl
implements ItemStateAdaptor {
    public Response<Collection<Item>> listItems(SessionContext context) {
        Response response;
        try {
            response = OutboundAdaptorUtils.getStateStore(context).listItems(context);
            if (!response.isSuccessful()) {
                response = new Response(new ReturnCode(20600, Module.ZSTM, null, response.getReturnCode()));
            }
        }
        catch (RuntimeException rte) {
            ReturnCode returnCode = new ReturnCode(50100, Module.ZMDP, rte.getMessage(), null);
            response = new Response(new ReturnCode(20600, Module.ZSTM, null, returnCode));
        }
        return response;
    }

    public Response<Boolean> isItemExist(SessionContext context, Id itemId) {
        Response response;
        try {
            response = OutboundAdaptorUtils.getStateStore(context).isItemExist(context, itemId);
            if (!response.isSuccessful()) {
                response = new Response(new ReturnCode(20500, Module.ZSTM, null, response.getReturnCode()));
            }
        }
        catch (RuntimeException rte) {
            ReturnCode returnCode = new ReturnCode(50200, Module.ZMDP, rte.getMessage(), null);
            response = new Response(new ReturnCode(20500, Module.ZSTM, null, returnCode));
        }
        return response;
    }

    public Response<Item> getItem(SessionContext context, Id itemId) {
        Response response;
        try {
            response = OutboundAdaptorUtils.getStateStore(context).getItem(context, itemId);
            if (!response.isSuccessful()) {
                response = new Response(new ReturnCode(20400, Module.ZSTM, null, response.getReturnCode()));
            }
        }
        catch (RuntimeException rte) {
            ReturnCode returnCode = new ReturnCode(50300, Module.ZMDP, rte.getMessage(), null);
            response = new Response(new ReturnCode(20400, Module.ZSTM, null, returnCode));
        }
        return response;
    }

    public Response<Void> createItem(SessionContext context, Id itemId, Info itemInfo, Date creationTime) {
        Response response;
        try {
            response = OutboundAdaptorUtils.getStateStore(context).createItem(context, itemId, itemInfo, creationTime);
            if (!response.isSuccessful()) {
                response = new Response(new ReturnCode(20300, Module.ZSTM, null, response.getReturnCode()));
            }
        }
        catch (RuntimeException rte) {
            ReturnCode returnCode = new ReturnCode(50400, Module.ZMDP, rte.getMessage(), null);
            response = new Response(new ReturnCode(20300, Module.ZSTM, null, returnCode));
        }
        return response;
    }

    public Response<Void> updateItem(SessionContext context, Id itemId, Info itemInfo, Date modificationTime) {
        Response response;
        try {
            response = OutboundAdaptorUtils.getStateStore(context).updateItem(context, itemId, itemInfo, modificationTime);
            if (!response.isSuccessful()) {
                response = new Response(new ReturnCode(20100, Module.ZSTM, null, response.getReturnCode()));
            }
        }
        catch (RuntimeException rte) {
            ReturnCode returnCode = new ReturnCode(50500, Module.ZMDP, rte.getMessage(), null);
            response = new Response(new ReturnCode(20100, Module.ZSTM, null, returnCode));
        }
        return response;
    }

    public Response<Void> deleteItem(SessionContext context, Id itemId) {
        Response response;
        try {
            response = OutboundAdaptorUtils.getStateStore(context).deleteItem(context, itemId);
            if (!response.isSuccessful()) {
                response = new Response(new ReturnCode(20200, Module.ZSTM, null, response.getReturnCode()));
            }
        }
        catch (RuntimeException rte) {
            ReturnCode returnCode = new ReturnCode(50600, Module.ZMDP, rte.getMessage(), null);
            response = new Response(new ReturnCode(20200, Module.ZSTM, null, returnCode));
        }
        return response;
    }

    public Response<Void> updateItemModificationTime(SessionContext context, Id itemId, Date modificationTime) {
        Response response;
        try {
            response = OutboundAdaptorUtils.getStateStore(context).updateItemModificationTime(context, itemId, modificationTime);
            if (!response.isSuccessful()) {
                response = new Response(new ReturnCode(20100, Module.ZSTM, null, response.getReturnCode()));
            }
        }
        catch (RuntimeException rte) {
            ReturnCode returnCode = new ReturnCode(50500, Module.ZMDP, rte.getMessage(), null);
            response = new Response(new ReturnCode(20100, Module.ZSTM, null, returnCode));
        }
        return response;
    }
}

