/*
 * Decompiled with CFR 0.152.
 */
package com.amdocs.zusammen.adaptor.outbound.impl.item;

import com.amdocs.zusammen.adaptor.outbound.api.item.ItemVersionStateAdaptor;
import com.amdocs.zusammen.adaptor.outbound.impl.OutboundAdaptorUtils;
import com.amdocs.zusammen.datatypes.Id;
import com.amdocs.zusammen.datatypes.SessionContext;
import com.amdocs.zusammen.datatypes.Space;
import com.amdocs.zusammen.datatypes.item.ItemVersion;
import com.amdocs.zusammen.datatypes.item.ItemVersionData;
import com.amdocs.zusammen.datatypes.response.Module;
import com.amdocs.zusammen.datatypes.response.Response;
import com.amdocs.zusammen.datatypes.response.ReturnCode;
import java.util.Collection;
import java.util.Date;

public class ItemVersionStateAdaptorImpl
implements ItemVersionStateAdaptor {
    public Response<Collection<ItemVersion>> listItemVersions(SessionContext context, Space space, Id itemId) {
        Response response;
        try {
            response = OutboundAdaptorUtils.getStateStore(context).listItemVersions(context, space, itemId);
            if (!response.isSuccessful()) {
                response = new Response(new ReturnCode(20700, Module.ZSTM, null, response.getReturnCode()));
            }
        }
        catch (RuntimeException rte) {
            ReturnCode returnCode = new ReturnCode(50700, Module.ZMDP, rte.getMessage(), null);
            response = new Response(new ReturnCode(20700, Module.ZSTM, null, returnCode));
        }
        return response;
    }

    public Response<Boolean> isItemVersionExist(SessionContext context, Space space, Id itemId, Id versionId) {
        Response response;
        try {
            response = OutboundAdaptorUtils.getStateStore(context).isItemVersionExist(context, space, itemId, versionId);
            if (!response.isSuccessful()) {
                response = new Response(new ReturnCode(20800, Module.ZSTM, null, response.getReturnCode()));
            }
        }
        catch (RuntimeException rte) {
            ReturnCode returnCode = new ReturnCode(51200, Module.ZMDP, rte.getMessage(), null);
            response = new Response(new ReturnCode(20800, Module.ZSTM, null, returnCode));
        }
        return response;
    }

    public Response<ItemVersion> getItemVersion(SessionContext context, Space space, Id itemId, Id versionId) {
        Response response;
        try {
            response = OutboundAdaptorUtils.getStateStore(context).getItemVersion(context, space, itemId, versionId);
            if (!response.isSuccessful()) {
                response = new Response(new ReturnCode(20900, Module.ZSTM, null, response.getReturnCode()));
            }
        }
        catch (RuntimeException rte) {
            ReturnCode returnCode = new ReturnCode(50800, Module.ZMDP, rte.getMessage(), null);
            response = new Response(new ReturnCode(20900, Module.ZSTM, null, returnCode));
        }
        return response;
    }

    public Response<Void> createItemVersion(SessionContext context, Space space, Id itemId, Id baseVersionId, Id versionId, ItemVersionData data, Date creationTime) {
        Response response;
        try {
            response = OutboundAdaptorUtils.getStateStore(context).createItemVersion(context, space, itemId, baseVersionId, versionId, data, creationTime);
            if (!response.isSuccessful()) {
                response = new Response(new ReturnCode(21000, Module.ZSTM, null, response.getReturnCode()));
            }
        }
        catch (RuntimeException rte) {
            ReturnCode returnCode = new ReturnCode(50900, Module.ZMDP, rte.getMessage(), null);
            response = new Response(new ReturnCode(21000, Module.ZSTM, null, returnCode));
        }
        return response;
    }

    public Response<Void> updateItemVersion(SessionContext context, Space space, Id itemId, Id versionId, ItemVersionData data, Date modificationTime) {
        Response response;
        try {
            response = OutboundAdaptorUtils.getStateStore(context).updateItemVersion(context, space, itemId, versionId, data, modificationTime);
            if (!response.isSuccessful()) {
                response = new Response(new ReturnCode(21100, Module.ZSTM, null, response.getReturnCode()));
            }
        }
        catch (RuntimeException rte) {
            ReturnCode returnCode = new ReturnCode(51000, Module.ZMDP, rte.getMessage(), null);
            response = new Response(new ReturnCode(21100, Module.ZSTM, null, returnCode));
        }
        return response;
    }

    public Response<Void> deleteItemVersion(SessionContext context, Space space, Id itemId, Id versionId) {
        Response response;
        try {
            response = OutboundAdaptorUtils.getStateStore(context).deleteItemVersion(context, space, itemId, versionId);
            if (!response.isSuccessful()) {
                response = new Response(new ReturnCode(21200, Module.ZSTM, null, response.getReturnCode()));
            }
        }
        catch (RuntimeException rte) {
            ReturnCode returnCode = new ReturnCode(51100, Module.ZMDP, rte.getMessage(), null);
            response = new Response(new ReturnCode(21200, Module.ZSTM, null, returnCode));
        }
        return response;
    }

    public Response<Void> updateItemVersionModificationTime(SessionContext context, Space space, Id itemId, Id versionId, Date modificationTime) {
        Response response;
        try {
            response = OutboundAdaptorUtils.getStateStore(context).updateItemVersionModificationTime(context, space, itemId, versionId, modificationTime);
            if (!response.isSuccessful()) {
                response = new Response(new ReturnCode(21100, Module.ZSTM, null, response.getReturnCode()));
            }
        }
        catch (RuntimeException rte) {
            ReturnCode returnCode = new ReturnCode(51000, Module.ZMDP, rte.getMessage(), null);
            response = new Response(new ReturnCode(21100, Module.ZSTM, null, returnCode));
        }
        return response;
    }
}

