/*
 * Decompiled with CFR 0.152.
 */
package com.amdocs.zusammen.utils.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class CommonMethods {
    private static final char[] CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    private CommonMethods() {
    }

    public static byte[] serializeObject(Serializable object) {
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream(2048);
        try (ObjectOutputStream ds = new ObjectOutputStream(byteArray);){
            ds.writeObject(object);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return byteArray.toByteArray();
    }

    public static Serializable deserializeObject(byte[] bytes) {
        Serializable obj;
        try (ObjectInputStream stream = new ObjectInputStream(new ByteArrayInputStream(bytes));){
            obj = (Serializable)stream.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return obj;
    }

    public static boolean isEmpty(Object obj) {
        return obj == null;
    }

    public static boolean isEmpty(byte[] byteArray) {
        return byteArray == null || byteArray.length == 0;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static long[] toPrimitive(Long[] array) {
        if (array == null) {
            return null;
        }
        long[] result = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] != null ? array[i] : 0L;
        }
        return result;
    }

    public static <T> T[] toArray(Collection<? extends T> col, Class<T> type) {
        int length = CommonMethods.isEmpty(col) ? 0 : col.size();
        Object[] array = (Object[])Array.newInstance(type, length);
        return col != null ? col.toArray(array) : array;
    }

    public static String nextUUID() {
        UUID uuid = UUID.randomUUID();
        StringBuilder buff = new StringBuilder(32);
        CommonMethods.long2string(uuid.getMostSignificantBits(), buff);
        CommonMethods.long2string(uuid.getLeastSignificantBits(), buff);
        return buff.toString();
    }

    private static void long2string(long l, StringBuilder buff) {
        for (int i = 0; i < 16; ++i) {
            long nextByte = l & 0xF000000000000000L;
            l <<= 4;
            boolean isNegative = nextByte < 0L;
            nextByte = CommonMethods.rightShift(nextByte, 60);
            if (isNegative) {
                nextByte |= 8L;
            }
            buff.append(CHARS[(int)nextByte]);
        }
    }

    private static long rightShift(long l, int n) {
        return l >>> n;
    }

    public static <T> T[] concat(T[] left, T[] right) {
        Object[] res;
        if (CommonMethods.isEmpty(left)) {
            res = right;
        } else if (CommonMethods.isEmpty(right)) {
            res = left;
        } else {
            res = (Object[])Array.newInstance(left[0].getClass(), left.length + right.length);
            System.arraycopy(left, 0, res, 0, left.length);
            System.arraycopy(right, 0, res, left.length, right.length);
        }
        return res;
    }

    public static <B, D> D cast(B b, Class<D> cls) {
        D d = null;
        if (b != null) {
            if (!cls.isInstance(b)) {
                throw new ClassCastException(String.format("Failed to cast from '%s' to '%s'", b.getClass().getName(), cls.getName()));
            }
            d = (D)b;
        }
        return d;
    }

    public static Object newInstance(String classname) {
        return CommonMethods.newInstance(classname, Object.class);
    }

    public static <T> T newInstance(String classname, Class<T> cls) {
        if (CommonMethods.isEmpty(classname)) {
            throw new IllegalArgumentException();
        }
        if (cls == null) {
            throw new IllegalArgumentException();
        }
        try {
            Class<?> temp = Class.forName(classname);
            if (!cls.isAssignableFrom(temp)) {
                throw new ClassCastException(String.format("Failed to cast from '%s' to '%s'", classname, cls.getName()));
            }
            Class<?> impl = temp;
            return (T)CommonMethods.newInstance(impl);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T newInstance(Class<T> cls) {
        try {
            return cls.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getResourcesPath(String resourceName) {
        URL resourceURL = CommonMethods.class.getClassLoader().getResource(resourceName);
        String resourcePath = resourceURL.getPath();
        return resourcePath.substring(0, resourcePath.lastIndexOf("/") + 1);
    }

    public static String getStackTrace(Throwable t) {
        if (null == t) {
            return "";
        }
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static String printStackTrace() {
        StackTraceElement[] trace;
        StringWriter sw = new StringWriter();
        for (StackTraceElement traceElement : trace = Thread.currentThread().getStackTrace()) {
            sw.write("\t  " + traceElement);
            sw.write(System.lineSeparator());
        }
        String s = sw.toString();
        try {
            sw.close();
        }
        catch (IOException e) {
            System.err.println(e);
        }
        return s;
    }

    public static boolean isEqualObject(Object obj1, Object obj2) {
        boolean isEqualValue = false;
        if (obj1 == null && obj2 == null) {
            isEqualValue = true;
        }
        if (!isEqualValue && obj1 != null && obj2 != null && obj1.equals(obj2)) {
            isEqualValue = true;
        }
        return isEqualValue;
    }

    public static String arrayToCommaSeparatedString(String[] arr) {
        return CommonMethods.arrayToSeparatedString(arr, ',');
    }

    public static String collectionToCommaSeparatedString(Collection<String> elementCollection) {
        ArrayList<String> list = new ArrayList<String>();
        elementCollection.stream().forEach(list::add);
        return CommonMethods.listToSeparatedString(list, ',');
    }

    public static String arrayToSeparatedString(String[] arr, char separator) {
        return CommonMethods.listToSeparatedString(Arrays.asList(arr), separator);
    }

    public static String listToSeparatedString(List<String> list, char separator) {
        String res = null;
        if (null != list) {
            StringBuilder sb = new StringBuilder();
            int sz = list.size();
            for (int i = 0; i < sz; ++i) {
                if (i > 0) {
                    sb.append(separator);
                }
                sb.append(list.get(i));
            }
            res = sb.toString();
        }
        return res;
    }

    public static String duplicateStringWithDelimiter(String arg, char separator, int numberOfDuplications) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numberOfDuplications; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(arg);
        }
        String res = sb.toString();
        return res;
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            int x = j << 1;
            hexChars[x] = hexArray[v >>> 4];
            hexChars[x + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static <T> Set<T> toSingleElementSet(T element) {
        return Collections.singleton(element);
    }

    public static <T> List<T> iteratorToList(Iterable<T> iter) {
        ArrayList<T> list = new ArrayList<T>();
        for (T item : iter) {
            list.add(item);
        }
        return list;
    }
}

