/*
 * Decompiled with CFR 0.152.
 */
package com.amdocs.zusammen.utils.facade.api;

import com.amdocs.zusammen.utils.common.CommonMethods;
import com.amdocs.zusammen.utils.facade.api.AbstractFactory;
import com.amdocs.zusammen.utils.facade.impl.FactoryConfig;
import java.util.Map;

public abstract class AbstractComponentFactory<I>
extends AbstractFactory<I> {
    static {
        RegistryImpl registry = new RegistryImpl();
        InitializationHelper.registerFactoryMapping(registry);
    }

    static class InitializationHelper {
        private static boolean isRegistered = false;

        private InitializationHelper() {
        }

        static synchronized boolean registerFactoryMapping(Registry registry) {
            boolean done;
            boolean bl = done = !isRegistered;
            if (!isRegistered) {
                InitializationHelper.registerFactoryMappingImpl(registry);
                isRegistered = true;
            }
            return done;
        }

        private static void registerFactoryMappingImpl(Registry registry) {
            Map<String, String> factoryMap = FactoryConfig.getFactoriesMap();
            try {
                for (Map.Entry<String, String> entry : factoryMap.entrySet()) {
                    String abstractClassName = entry.getKey();
                    String concreteTypeName = entry.getValue();
                    if (CommonMethods.isEmpty(concreteTypeName)) {
                        throw new RuntimeException("System Error - Missing configuration value:" + concreteTypeName + ".");
                    }
                    registry.register(abstractClassName, concreteTypeName);
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private static <T> Class<T> unsecureCast(Class<?> cls) {
            return cls;
        }

        private static String nameOf(Class<?> clazz) {
            return clazz != null ? clazz.getName() : "null";
        }
    }

    static interface Registry {
        public void register(String var1, String var2);
    }

    private static class RegistryImpl
    implements Registry {
        private RegistryImpl() {
        }

        @Override
        public void register(String factory, String impl) {
            AbstractComponentFactory.registerFactory(factory, impl);
        }
    }
}

