/*
 * Decompiled with CFR 0.152.
 */
package com.amdocs.zusammen.utils.facade.impl;

import com.amdocs.zusammen.utils.common.CommonMethods;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractFactoryBase {
    private static Map<String, String> registry = new ConcurrentHashMap<String, String>();
    private static Map<String, AbstractFactoryBase> factoryMap = new ConcurrentHashMap<String, AbstractFactoryBase>();

    public static <I, F extends AbstractFactoryBase> void registerFactory(Class<F> factory, Class<? extends F> impl) {
        if (factory == null) {
            throw new RuntimeException("System Error - Mandatory input factory missing.");
        }
        if (impl == null) {
            throw new RuntimeException("System Error - Mandatory input factory impl missing.");
        }
        if (factoryMap != null && factoryMap.containsKey(factory.getName())) {
            factoryMap.remove(factory.getName());
        }
        registry.put(factory.getName(), impl.getName());
    }

    protected static void registerFactory(String factoryName, String implName) {
        registry.put(factoryName, implName);
    }

    public static <F extends AbstractFactoryBase> void unregisterFactory(Class<F> factory) {
        if (factory == null) {
            throw new RuntimeException("System Error - Mandatory input factory missing.");
        }
        if (factoryMap != null) {
            factoryMap.remove(factory.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <I, F extends AbstractFactoryBase> F getInstance(Class<F> factoryType) {
        if (factoryType == null) {
            throw new RuntimeException("System Error - Mandatory input factory type missing.");
        }
        AbstractFactoryBase factory = factoryMap.get(factoryType.getName());
        if (factory == null) {
            Class<F> clazz = factoryType;
            synchronized (clazz) {
                factory = factoryMap.get(factoryType.getName());
                if (factory == null) {
                    String implName = registry.get(factoryType.getName());
                    if (CommonMethods.isEmpty(implName)) {
                        throw new RuntimeException("System Error - Mandatory input factory implementation missing.");
                    }
                    factory = (AbstractFactoryBase)CommonMethods.newInstance(implName, factoryType);
                    factory.init();
                    factoryMap.put(factoryType.getName(), factory);
                }
            }
        }
        return (F)factory;
    }

    public static <F extends AbstractFactoryBase> boolean isFactoryRegistered(Class<F> factoryType) {
        boolean isFactoryRegistered = false;
        if (factoryType == null) {
            throw new RuntimeException("system Error - Mandatory input factory type missing.");
        }
        AbstractFactoryBase factory = factoryMap.get(factoryType.getName());
        if (factory != null) {
            isFactoryRegistered = true;
        } else {
            String implName = registry.get(factoryType.getName());
            if (!CommonMethods.isEmpty(implName)) {
                isFactoryRegistered = true;
            }
        }
        return isFactoryRegistered;
    }

    protected void init() {
    }

    protected void stop() {
    }

    public static void stopAll() {
        Collection<AbstractFactoryBase> factorylist = factoryMap.values();
        for (AbstractFactoryBase factory : factorylist) {
            factory.stop();
        }
    }
}

