/*
 * Decompiled with CFR 0.152.
 */
package com.amdocs.zusammen.utils.fileutils;

import com.amdocs.zusammen.utils.fileutils.FileContentHandler;
import com.amdocs.zusammen.utils.fileutils.json.JsonUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileUtils {
    public static InputStream getFileInputStream(String fileName) {
        InputStream is;
        URL urlFile = FileUtils.class.getClassLoader().getResource(fileName);
        try {
            is = urlFile != null ? urlFile.openStream() : new FileInputStream(new File(fileName));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return is;
    }

    public static List<InputStream> getFileInputStreams(String fileName) {
        ArrayList<InputStream> streams = new ArrayList<InputStream>();
        try {
            Enumeration<URL> urlFiles = FileUtils.class.getClassLoader().getResources(fileName);
            while (urlFiles.hasMoreElements()) {
                URL url = urlFiles.nextElement();
                InputStream is = url.openStream();
                streams.add(is);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return streams;
    }

    public static InputStream loadFileToInputStream(String fileName) {
        URL urlFile = FileUtils.class.getClassLoader().getResource(fileName);
        try {
            Enumeration<URL> en = FileUtils.class.getClassLoader().getResources(fileName);
            while (en.hasMoreElements()) {
                urlFile = en.nextElement();
            }
        }
        catch (IOException | NullPointerException e) {
            throw new RuntimeException(e);
        }
        try {
            if (urlFile != null) {
                return urlFile.openStream();
            }
            throw new RuntimeException();
        }
        catch (IOException | NullPointerException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] toByteArray(InputStream input) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            byte[] returnValue;
            FileUtils.copy(input, output);
            byte[] byArray = returnValue = output.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("error will converting input stream to byte array:" + e.getMessage());
        }
        finally {
            try {
                output.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static InputStream toInputStream(byte[] bytes) {
        if (bytes == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        return is;
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        long count = FileUtils.copyLarge(input, output);
        return count > Integer.MAX_VALUE ? -1 : (int)count;
    }

    private static long copyLarge(InputStream input, OutputStream output) throws IOException {
        return FileUtils.copyLarge(input, output, new byte[4096]);
    }

    private static long copyLarge(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        int n1;
        long count = 0L;
        if (input == null) {
            return count;
        }
        while (-1 != (n1 = input.read(buffer))) {
            output.write(buffer, 0, n1);
            count += (long)n1;
        }
        return count;
    }

    public static String getFileWithoutExtention(String fileName) {
        if (!fileName.contains(".")) {
            return fileName;
        }
        return fileName.substring(0, fileName.lastIndexOf("."));
    }

    public static FileContentHandler getFileContentMapFromZip(byte[] zipData) throws IOException {
        FileContentHandler mapFileContent = new FileContentHandler();
        try {
            ZipEntry zipEntry;
            ZipInputStream inputZipStream = new ZipInputStream(new ByteArrayInputStream(zipData));
            while ((zipEntry = inputZipStream.getNextEntry()) != null) {
                String currentEntryName = zipEntry.getName();
                byte[] fileByteContent = FileUtils.toByteArray(inputZipStream);
                mapFileContent.addFile(currentEntryName, fileByteContent);
            }
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
        return mapFileContent;
    }

    public static List<File> getFiles(String path) {
        File file = new File(path);
        if (!file.exists()) {
            throw new RuntimeException("file[" + file.getAbsolutePath() + "] does not " + "exist");
        }
        ArrayList<File> fileList = new ArrayList<File>();
        FileUtils.getFiles(file, fileList);
        return fileList;
    }

    private static void getFiles(File file, List<File> fileList) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] files;
                for (File subFile : files = file.listFiles()) {
                    FileUtils.getFiles(subFile, fileList);
                }
            } else {
                fileList.add(file);
            }
        }
    }

    public static boolean delete(File file) {
        if (file.exists()) {
            File[] files;
            if (file.isDirectory() && (files = file.listFiles()) != null) {
                for (File subFile : files) {
                    boolean isDeleted = FileUtils.delete(subFile);
                    if (isDeleted) continue;
                    return false;
                }
            }
            return file.delete();
        }
        return false;
    }

    public static File writeFile(String path, String fileName, Object fileData) {
        File file = new File(path + File.separator + fileName);
        String fileByte = JsonUtil.object2Json(fileData);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            fos.write(fileByte.getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return file;
    }

    public static Optional<InputStream> readFile(String path, String fileName) {
        File file = new File(path + File.separator + fileName);
        if (!file.exists()) {
            return Optional.empty();
        }
        try {
            FileInputStream fis = new FileInputStream(file);
            return Optional.of(fis);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static File writeFileFromInputStream(String path, String fileName, InputStream fileData) {
        FileOutputStream fileDataOut = null;
        File file = new File(path + File.separator + fileName);
        try {
            fileDataOut = new FileOutputStream(file);
            FileUtils.copy(fileData, fileDataOut);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fileDataOut != null) {
                try {
                    ((OutputStream)fileDataOut).close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return file;
    }

    public static boolean exists(String path) {
        File file = new File(path);
        return file.exists();
    }

    public static File getFile(String path) {
        File file = new File(path);
        file.getParentFile().mkdirs();
        return file;
    }

    public static String trimPath(String path) {
        int lastIndex = path.lastIndexOf(File.separator);
        return path.substring(0, lastIndex - 1);
    }

    public static enum FileExtension {
        JSON("json"),
        YAML("yaml"),
        YML("yml"),
        OTHER("other");

        private String displayName;

        public String getDisplayName() {
            return this.displayName;
        }

        private FileExtension(String displayName) {
            this.displayName = displayName;
        }
    }
}

