/*
 * Decompiled with CFR 0.152.
 */
package com.amdocs.zusammen.utils.fileutils;

import com.amdocs.zusammen.utils.fileutils.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FileContentHandler {
    private Map<String, byte[]> files = new HashMap<String, byte[]>();

    public InputStream getFileContent(String fileName) {
        byte[] content = this.files.get(fileName);
        return content == null || content.length == 0 ? null : new ByteArrayInputStream(content);
    }

    public void addFile(String fileName, byte[] contect) {
        this.files.put(fileName, contect);
    }

    public void addFile(String fileName, InputStream is) {
        this.files.put(fileName, FileUtils.toByteArray(is));
    }

    public void setFiles(FileContentHandler extFiles) {
        extFiles.getFileList().stream().forEach(fileName -> this.addFile((String)fileName, extFiles.getFileContent((String)fileName)));
    }

    public Set<String> getFileList() {
        return this.files.keySet();
    }

    public void putAll(Map<String, byte[]> files) {
        this.files = files;
    }

    public void addAll(FileContentHandler other) {
        this.files.putAll(other.files);
    }

    public void remove(String fileName) {
        this.files.remove(fileName);
    }

    public boolean containsFile(String fileName) {
        return this.files.containsKey(fileName);
    }
}

