/*
 * Decompiled with CFR 0.152.
 */
package com.amdocs.zusammen.utils.fileutils.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;

public class JsonUtil {
    public static String object2Json(Object obj) {
        return new GsonBuilder().setPrettyPrinting().create().toJson(obj);
    }

    public static <T> T json2Object(String json, Class<T> classOfT) {
        return JsonUtil.json2Object(json, classOfT);
    }

    public static <T> T json2Object(String json, Type typeOfT) {
        Object t;
        try (StringReader br = new StringReader(json);){
            t = new Gson().fromJson((Reader)br, typeOfT);
        }
        catch (JsonIOException | JsonSyntaxException | IOException e) {
            throw new RuntimeException(e);
        }
        return (T)t;
    }

    public static String inputStream2Json(InputStream is) {
        if (Objects.isNull(is)) {
            throw new RuntimeException("Input object is null");
        }
        Map mapObject = JsonUtil.json2Object(is, Map.class);
        return JsonUtil.object2Json(mapObject);
    }

    public static <T> T json2Object(InputStream is, Class<T> classOfT) {
        return JsonUtil.json2Object(is, classOfT);
    }

    public static <T> T json2Object(InputStream is, Type typeOfT) {
        Object t;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
            t = new Gson().fromJson((Reader)br, typeOfT);
        }
        catch (JsonIOException | JsonSyntaxException | IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return (T)t;
    }

    public static boolean isValidJson(String json) {
        try {
            return new JsonParser().parse(json).isJsonObject();
        }
        catch (JsonSyntaxException jse) {
            return false;
        }
    }
}

