/*
 * Decompiled with CFR 0.152.
 */
package com.amdocs.zusammen.sdk.state.impl;

import com.amdocs.zusammen.commons.configuration.ConfigurationManager;
import com.amdocs.zusammen.commons.configuration.ConfigurationManagerFactory;
import com.amdocs.zusammen.commons.configuration.datatypes.PluginInfo;
import com.amdocs.zusammen.commons.log.ZusammenLogger;
import com.amdocs.zusammen.commons.log.ZusammenLoggerFactory;
import com.amdocs.zusammen.datatypes.SessionContext;
import com.amdocs.zusammen.datatypes.response.Module;
import com.amdocs.zusammen.datatypes.response.ReturnCode;
import com.amdocs.zusammen.datatypes.response.ZusammenException;
import com.amdocs.zusammen.sdk.state.StateStore;
import com.amdocs.zusammen.sdk.state.StateStoreFactory;
import com.amdocs.zusammen.utils.common.CommonMethods;

public class StateStoreFactoryImpl
extends StateStoreFactory {
    private static StateStore stateStore;
    private static ZusammenLogger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initStateStore(SessionContext context) {
        Class<StateStoreFactoryImpl> clazz = StateStoreFactoryImpl.class;
        synchronized (StateStoreFactoryImpl.class) {
            ConfigurationManager configurationManager = ConfigurationManagerFactory.getInstance().createInterface();
            PluginInfo pluginInfo = configurationManager.getPluginInfo("zusammen_state_store");
            try {
                stateStore = (StateStore)CommonMethods.newInstance((String)pluginInfo.getImplementationClass(), StateStore.class);
            }
            catch (Exception ex) {
                ReturnCode returnCode = new ReturnCode(11800, Module.ZDB, ex.getMessage(), null);
                logger.error(returnCode.toString(), (Throwable)ex);
                throw new ZusammenException(returnCode);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StateStore createInterface(SessionContext context) {
        Class<StateStoreFactoryImpl> clazz = StateStoreFactoryImpl.class;
        synchronized (StateStoreFactoryImpl.class) {
            if (stateStore == null) {
                StateStoreFactoryImpl.initStateStore(context);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return stateStore;
        }
    }

    static {
        logger = ZusammenLoggerFactory.getLogger((String)StateStoreFactoryImpl.class.getName());
    }
}

