/*
 * Decompiled with CFR 0.152.
 */
package com.amdocs.zusammen.sdk.collaboration;

import com.amdocs.zusammen.datatypes.Id;
import com.amdocs.zusammen.datatypes.Namespace;
import com.amdocs.zusammen.datatypes.SessionContext;
import com.amdocs.zusammen.datatypes.Space;
import com.amdocs.zusammen.datatypes.item.ElementContext;
import com.amdocs.zusammen.datatypes.item.Info;
import com.amdocs.zusammen.datatypes.item.ItemVersion;
import com.amdocs.zusammen.datatypes.item.ItemVersionData;
import com.amdocs.zusammen.datatypes.item.ItemVersionStatus;
import com.amdocs.zusammen.datatypes.item.Resolution;
import com.amdocs.zusammen.datatypes.itemversion.ItemVersionRevisions;
import com.amdocs.zusammen.datatypes.itemversion.Revision;
import com.amdocs.zusammen.datatypes.itemversion.Tag;
import com.amdocs.zusammen.datatypes.response.Response;
import com.amdocs.zusammen.sdk.collaboration.types.CollaborationElement;
import com.amdocs.zusammen.sdk.collaboration.types.CollaborationElementConflict;
import com.amdocs.zusammen.sdk.collaboration.types.CollaborationItemVersionConflict;
import com.amdocs.zusammen.sdk.collaboration.types.CollaborationMergeChange;
import com.amdocs.zusammen.sdk.collaboration.types.CollaborationMergeResult;
import com.amdocs.zusammen.sdk.collaboration.types.CollaborationPublishResult;
import com.amdocs.zusammen.sdk.health.IHealthCheck;
import java.util.Collection;

public interface CollaborationStore
extends IHealthCheck {
    public Response<Void> createItem(SessionContext var1, Id var2, Info var3);

    public Response<Void> deleteItem(SessionContext var1, Id var2);

    public Response<Void> createItemVersion(SessionContext var1, Id var2, Id var3, Id var4, ItemVersionData var5);

    public Response<Void> updateItemVersion(SessionContext var1, Id var2, Id var3, ItemVersionData var4);

    public Response<Void> deleteItemVersion(SessionContext var1, Id var2, Id var3);

    public Response<ItemVersionStatus> getItemVersionStatus(SessionContext var1, Id var2, Id var3);

    public Response<Void> tagItemVersion(SessionContext var1, Id var2, Id var3, Id var4, Tag var5);

    public Response<CollaborationPublishResult> publishItemVersion(SessionContext var1, Id var2, Id var3, String var4);

    public Response<CollaborationMergeResult> syncItemVersion(SessionContext var1, Id var2, Id var3);

    public Response<CollaborationMergeResult> forceSyncItemVersion(SessionContext var1, Id var2, Id var3);

    public Response<CollaborationMergeResult> mergeItemVersion(SessionContext var1, Id var2, Id var3, Id var4);

    public Response<CollaborationItemVersionConflict> getItemVersionConflict(SessionContext var1, Id var2, Id var3);

    public Response<ItemVersionRevisions> listItemVersionRevisions(SessionContext var1, Id var2, Id var3);

    public Response<Revision> getItemVersionRevision(SessionContext var1, Id var2, Id var3, Id var4);

    public Response<CollaborationMergeChange> resetItemVersionRevision(SessionContext var1, Id var2, Id var3, Id var4);

    public Response<CollaborationMergeChange> revertItemVersionRevision(SessionContext var1, Id var2, Id var3, Id var4);

    public Response<Void> commitElements(SessionContext var1, Id var2, Id var3, String var4);

    public Response<Collection<CollaborationElement>> listElements(SessionContext var1, ElementContext var2, Namespace var3, Id var4);

    public Response<CollaborationElement> getElement(SessionContext var1, ElementContext var2, Namespace var3, Id var4);

    public Response<CollaborationElementConflict> getElementConflict(SessionContext var1, ElementContext var2, Namespace var3, Id var4);

    public Response<Void> createElement(SessionContext var1, CollaborationElement var2);

    public Response<Void> updateElement(SessionContext var1, CollaborationElement var2);

    public Response<Void> deleteElement(SessionContext var1, CollaborationElement var2);

    public Response<CollaborationMergeResult> resolveElementConflict(SessionContext var1, CollaborationElement var2, Resolution var3);

    public Response<ItemVersion> getItemVersion(SessionContext var1, Space var2, Id var3, Id var4, Id var5);
}

