/*
 * Decompiled with CFR 0.152.
 */
package com.amido.stacks.aws.tracing;

import com.amazonaws.xray.AWSXRay;
import com.amazonaws.xray.AWSXRayRecorder;
import com.amazonaws.xray.AWSXRayRecorderBuilder;
import com.amazonaws.xray.javax.servlet.AWSXRayServletFilter;
import com.amazonaws.xray.listeners.SegmentListener;
import com.amazonaws.xray.log4j.Log4JSegmentListener;
import com.amazonaws.xray.metrics.MetricsSegmentListener;
import com.amazonaws.xray.plugins.EC2Plugin;
import com.amazonaws.xray.plugins.EKSPlugin;
import com.amazonaws.xray.plugins.Plugin;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"aws.xray.enabled"}, havingValue="true")
public class XRayTracingFilter {
    private static final Logger log = LoggerFactory.getLogger(XRayTracingFilter.class);
    @Value(value="${spring.application.name:undefined}")
    public String appName;

    @Bean
    public Filter xrayFilter() {
        log.info("Initialising AWS XRay Support...");
        AWSXRayRecorderBuilder builder = AWSXRayRecorderBuilder.standard().withPlugin((Plugin)new EC2Plugin()).withPlugin((Plugin)new EKSPlugin()).withSegmentListener((SegmentListener)new MetricsSegmentListener()).withSegmentListener((SegmentListener)new Log4JSegmentListener(this.appName));
        AWSXRay.setGlobalRecorder((AWSXRayRecorder)builder.build());
        return new AWSXRayServletFilter(this.appName);
    }
}

