/*
 * Decompiled with CFR 0.152.
 */
package com.amplifyframework.auth.cognito;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.logging.LogFactory;
import com.amazonaws.mobile.client.AWSMobileClient;
import com.amazonaws.mobile.client.Callback;
import com.amazonaws.mobile.client.HostedUIOptions;
import com.amazonaws.mobile.client.SignInUIOptions;
import com.amazonaws.mobile.client.SignOutOptions;
import com.amazonaws.mobile.client.UserState;
import com.amazonaws.mobile.client.UserStateDetails;
import com.amazonaws.mobile.client.results.Device;
import com.amazonaws.mobile.client.results.ForgotPasswordResult;
import com.amazonaws.mobile.client.results.ForgotPasswordState;
import com.amazonaws.mobile.client.results.ListDevicesResult;
import com.amazonaws.mobile.client.results.SignInResult;
import com.amazonaws.mobile.client.results.SignInState;
import com.amazonaws.mobile.client.results.SignUpResult;
import com.amazonaws.mobile.client.results.Tokens;
import com.amazonaws.mobile.client.results.UserCodeDeliveryDetails;
import com.amazonaws.mobile.config.AWSConfiguration;
import com.amazonaws.mobileconnectors.cognitoauth.exceptions.AuthNavigationException;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.util.CognitoJWTParser;
import com.amazonaws.services.cognitoidentityprovider.model.AuthFlowType;
import com.amazonaws.services.cognitoidentityprovider.model.NotAuthorizedException;
import com.amplifyframework.auth.AuthChannelEventName;
import com.amplifyframework.auth.AuthCodeDeliveryDetails;
import com.amplifyframework.auth.AuthDevice;
import com.amplifyframework.auth.AuthException;
import com.amplifyframework.auth.AuthPlugin;
import com.amplifyframework.auth.AuthProvider;
import com.amplifyframework.auth.AuthSession;
import com.amplifyframework.auth.AuthUser;
import com.amplifyframework.auth.AuthUserAttribute;
import com.amplifyframework.auth.AuthUserAttributeKey;
import com.amplifyframework.auth.cognito.AWSCognitoAuthSession;
import com.amplifyframework.auth.cognito.AWSCognitoUserPoolTokens;
import com.amplifyframework.auth.cognito.MobileClientSessionAdapter;
import com.amplifyframework.auth.cognito.options.AWSCognitoAuthConfirmResetPasswordOptions;
import com.amplifyframework.auth.cognito.options.AWSCognitoAuthConfirmSignInOptions;
import com.amplifyframework.auth.cognito.options.AWSCognitoAuthConfirmSignUpOptions;
import com.amplifyframework.auth.cognito.options.AWSCognitoAuthResendSignUpCodeOptions;
import com.amplifyframework.auth.cognito.options.AWSCognitoAuthResendUserAttributeConfirmationCodeOptions;
import com.amplifyframework.auth.cognito.options.AWSCognitoAuthResetPasswordOptions;
import com.amplifyframework.auth.cognito.options.AWSCognitoAuthSignInOptions;
import com.amplifyframework.auth.cognito.options.AWSCognitoAuthSignOutOptions;
import com.amplifyframework.auth.cognito.options.AWSCognitoAuthSignUpOptions;
import com.amplifyframework.auth.cognito.options.AWSCognitoAuthUpdateUserAttributeOptions;
import com.amplifyframework.auth.cognito.options.AWSCognitoAuthUpdateUserAttributesOptions;
import com.amplifyframework.auth.cognito.options.AWSCognitoAuthWebUISignInOptions;
import com.amplifyframework.auth.cognito.util.AuthProviderConverter;
import com.amplifyframework.auth.cognito.util.CognitoAuthExceptionConverter;
import com.amplifyframework.auth.cognito.util.SignInStateConverter;
import com.amplifyframework.auth.options.AuthConfirmResetPasswordOptions;
import com.amplifyframework.auth.options.AuthConfirmSignInOptions;
import com.amplifyframework.auth.options.AuthConfirmSignUpOptions;
import com.amplifyframework.auth.options.AuthResendSignUpCodeOptions;
import com.amplifyframework.auth.options.AuthResendUserAttributeConfirmationCodeOptions;
import com.amplifyframework.auth.options.AuthResetPasswordOptions;
import com.amplifyframework.auth.options.AuthSignInOptions;
import com.amplifyframework.auth.options.AuthSignOutOptions;
import com.amplifyframework.auth.options.AuthSignUpOptions;
import com.amplifyframework.auth.options.AuthUpdateUserAttributeOptions;
import com.amplifyframework.auth.options.AuthUpdateUserAttributesOptions;
import com.amplifyframework.auth.options.AuthWebUISignInOptions;
import com.amplifyframework.auth.result.AuthResetPasswordResult;
import com.amplifyframework.auth.result.AuthSessionResult;
import com.amplifyframework.auth.result.AuthSignInResult;
import com.amplifyframework.auth.result.AuthSignUpResult;
import com.amplifyframework.auth.result.AuthUpdateAttributeResult;
import com.amplifyframework.auth.result.step.AuthNextResetPasswordStep;
import com.amplifyframework.auth.result.step.AuthNextSignInStep;
import com.amplifyframework.auth.result.step.AuthNextSignUpStep;
import com.amplifyframework.auth.result.step.AuthNextUpdateAttributeStep;
import com.amplifyframework.auth.result.step.AuthResetPasswordStep;
import com.amplifyframework.auth.result.step.AuthSignInStep;
import com.amplifyframework.auth.result.step.AuthSignUpStep;
import com.amplifyframework.auth.result.step.AuthUpdateAttributeStep;
import com.amplifyframework.core.Action;
import com.amplifyframework.core.Amplify;
import com.amplifyframework.core.Consumer;
import com.amplifyframework.hub.HubChannel;
import com.amplifyframework.hub.HubEvent;
import com.amplifyframework.util.UserAgent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONException;
import org.json.JSONObject;

public final class AWSCognitoAuthPlugin
extends AuthPlugin<AWSMobileClient> {
    public static final int WEB_UI_SIGN_IN_ACTIVITY_CODE = 49281;
    private static final String AWS_COGNITO_AUTH_PLUGIN_KEY = "awsCognitoAuthPlugin";
    private static final long SECONDS_BEFORE_TIMEOUT = 10L;
    private static final String COGNITO_USER_ID_ATTRIBUTE = "sub";
    private static final String MOBILE_CLIENT_TOKEN_KEY = "token";
    private String userId;
    private AWSMobileClient awsMobileClient;
    private AuthChannelEventName lastEvent;

    public AWSCognitoAuthPlugin() {
        this.awsMobileClient = AWSMobileClient.getInstance();
    }

    @VisibleForTesting
    AWSCognitoAuthPlugin(AWSMobileClient instance, String userId) {
        this.awsMobileClient = instance;
        this.userId = userId;
    }

    @NonNull
    public String getPluginKey() {
        return AWS_COGNITO_AUTH_PLUGIN_KEY;
    }

    public void configure(@NonNull JSONObject pluginConfiguration, @NonNull Context context) throws AuthException {
        JSONObject mobileClientConfig;
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference asyncException = new AtomicReference();
        LogFactory.setLevel((LogFactory.Level)LogFactory.Level.OFF);
        try {
            mobileClientConfig = new JSONObject(pluginConfiguration.toString());
            mobileClientConfig.put("UserAgentOverride", (Object)UserAgent.string());
        }
        catch (JSONException exception) {
            throw new AuthException("Failed to set user agent string", (Throwable)exception, "There is a possibility that there is a bug if this error persists. Please take a look at \nhttps://github.com/aws-amplify/amplify-android/issues to see if there are any existing issues that \nmatch your scenario, and file an issue with the details of the bug if there isn't.");
        }
        this.awsMobileClient.initialize(context, new AWSConfiguration(mobileClientConfig), (Callback)new Callback<UserStateDetails>(){

            public void onResult(UserStateDetails result) {
                switch (result.getUserState()) {
                    case GUEST: 
                    case SIGNED_OUT: {
                        AWSCognitoAuthPlugin.this.lastEvent = AuthChannelEventName.SIGNED_OUT;
                        AWSCognitoAuthPlugin.this.userId = null;
                        break;
                    }
                    case SIGNED_IN: {
                        AWSCognitoAuthPlugin.this.lastEvent = AuthChannelEventName.SIGNED_IN;
                        AWSCognitoAuthPlugin.this.userId = AWSCognitoAuthPlugin.this.getUserIdFromToken((String)result.getDetails().get(AWSCognitoAuthPlugin.MOBILE_CLIENT_TOKEN_KEY));
                        break;
                    }
                    case SIGNED_OUT_USER_POOLS_TOKENS_INVALID: 
                    case SIGNED_OUT_FEDERATED_TOKENS_INVALID: {
                        AWSCognitoAuthPlugin.this.lastEvent = AuthChannelEventName.SESSION_EXPIRED;
                        AWSCognitoAuthPlugin.this.userId = AWSCognitoAuthPlugin.this.getUserIdFromToken((String)result.getDetails().get(AWSCognitoAuthPlugin.MOBILE_CLIENT_TOKEN_KEY));
                        break;
                    }
                    default: {
                        AWSCognitoAuthPlugin.this.userId = null;
                        AWSCognitoAuthPlugin.this.lastEvent = null;
                    }
                }
                AWSCognitoAuthPlugin.this.awsMobileClient.addUserStateListener(userStateDetails -> {
                    switch (userStateDetails.getUserState()) {
                        case GUEST: 
                        case SIGNED_OUT: {
                            AWSCognitoAuthPlugin.this.userId = null;
                            if (AWSCognitoAuthPlugin.this.lastEvent == AuthChannelEventName.SIGNED_OUT) break;
                            AWSCognitoAuthPlugin.this.lastEvent = AuthChannelEventName.SIGNED_OUT;
                            Amplify.Hub.publish(HubChannel.AUTH, HubEvent.create((Enum)AuthChannelEventName.SIGNED_OUT));
                            break;
                        }
                        case SIGNED_IN: {
                            AWSCognitoAuthPlugin.this.fetchAndSetUserId(() -> {
                                if (AWSCognitoAuthPlugin.this.lastEvent != AuthChannelEventName.SIGNED_IN) {
                                    AWSCognitoAuthPlugin.this.lastEvent = AuthChannelEventName.SIGNED_IN;
                                    Amplify.Hub.publish(HubChannel.AUTH, HubEvent.create((Enum)AuthChannelEventName.SIGNED_IN));
                                }
                            });
                            break;
                        }
                        case SIGNED_OUT_USER_POOLS_TOKENS_INVALID: 
                        case SIGNED_OUT_FEDERATED_TOKENS_INVALID: {
                            AWSCognitoAuthPlugin.this.fetchAndSetUserId(() -> {});
                            if (AWSCognitoAuthPlugin.this.lastEvent == AuthChannelEventName.SESSION_EXPIRED) break;
                            AWSCognitoAuthPlugin.this.lastEvent = AuthChannelEventName.SESSION_EXPIRED;
                            Amplify.Hub.publish(HubChannel.AUTH, HubEvent.create((Enum)AuthChannelEventName.SESSION_EXPIRED));
                            break;
                        }
                        default: {
                            AWSCognitoAuthPlugin.this.userId = null;
                        }
                    }
                });
                latch.countDown();
            }

            public void onError(Exception error) {
                asyncException.set(error);
                latch.countDown();
            }
        });
        try {
            if (latch.await(10L, TimeUnit.SECONDS)) {
                if (asyncException.get() != null) {
                    throw new AuthException("Failed to instantiate AWSMobileClient", (Throwable)asyncException.get(), "See attached exception for more details");
                }
                return;
            }
            throw new AuthException("Failed to instantiate AWSMobileClient within 10 seconds", "Check network connectivity");
        }
        catch (InterruptedException error) {
            throw new AuthException("Failed to instantiate AWSMobileClient", (Throwable)error, "See attached exception for more details");
        }
    }

    public void signUp(final @NonNull String username, @NonNull String password, @NonNull AuthSignUpOptions options, final @NonNull Consumer<AuthSignUpResult> onSuccess, final @NonNull Consumer<AuthException> onException) {
        HashMap<String, String> userAttributes = new HashMap<String, String>();
        Map<Object, Object> validationData = new HashMap();
        Map<Object, Object> clientMetadata = new HashMap();
        if (options.getUserAttributes() != null) {
            for (AuthUserAttribute attribute : options.getUserAttributes()) {
                userAttributes.put(attribute.getKey().getKeyString(), attribute.getValue());
            }
        }
        if (options instanceof AWSCognitoAuthSignUpOptions) {
            validationData = ((AWSCognitoAuthSignUpOptions)options).getValidationData();
            clientMetadata = ((AWSCognitoAuthSignUpOptions)options).getClientMetadata();
        }
        this.awsMobileClient.signUp(username, password, userAttributes, validationData, clientMetadata, (Callback)new Callback<SignUpResult>(){

            public void onResult(SignUpResult result) {
                onSuccess.accept((Object)AWSCognitoAuthPlugin.this.convertSignUpResult(result, username));
            }

            public void onError(Exception error) {
                onException.accept((Object)CognitoAuthExceptionConverter.lookup(error, "Sign up failed"));
            }
        });
    }

    public void confirmSignUp(final @NonNull String username, @NonNull String confirmationCode, @NonNull AuthConfirmSignUpOptions options, final @NonNull Consumer<AuthSignUpResult> onSuccess, final @NonNull Consumer<AuthException> onException) {
        HashMap<String, String> clientMetadata = new HashMap<String, String>();
        if (options instanceof AWSCognitoAuthConfirmSignUpOptions) {
            AWSCognitoAuthConfirmSignUpOptions cognitoOptions = (AWSCognitoAuthConfirmSignUpOptions)options;
            clientMetadata.putAll(cognitoOptions.getClientMetadata());
        }
        this.awsMobileClient.confirmSignUp(username, confirmationCode, clientMetadata, (Callback)new Callback<SignUpResult>(){

            public void onResult(SignUpResult result) {
                onSuccess.accept((Object)AWSCognitoAuthPlugin.this.convertSignUpResult(result, username));
            }

            public void onError(Exception error) {
                onException.accept((Object)CognitoAuthExceptionConverter.lookup(error, "Confirm sign up failed"));
            }
        });
    }

    public void confirmSignUp(@NonNull String username, @NonNull String confirmationCode, @NonNull Consumer<AuthSignUpResult> onSuccess, @NonNull Consumer<AuthException> onException) {
        this.confirmSignUp(username, confirmationCode, (AuthConfirmSignUpOptions)AuthConfirmSignUpOptions.defaults(), onSuccess, onException);
    }

    public void resendSignUpCode(final @NonNull String username, @NonNull AuthResendSignUpCodeOptions options, final @NonNull Consumer<AuthSignUpResult> onSuccess, final @NonNull Consumer<AuthException> onException) {
        HashMap<String, String> clientMetadata = new HashMap<String, String>();
        if (options instanceof AWSCognitoAuthResendSignUpCodeOptions) {
            AWSCognitoAuthResendSignUpCodeOptions cognitoOptions = (AWSCognitoAuthResendSignUpCodeOptions)options;
            clientMetadata.putAll(cognitoOptions.getMetadata());
        }
        this.awsMobileClient.resendSignUp(username, clientMetadata, (Callback)new Callback<SignUpResult>(){

            public void onResult(SignUpResult result) {
                onSuccess.accept((Object)AWSCognitoAuthPlugin.this.convertSignUpResult(result, username));
            }

            public void onError(Exception error) {
                onException.accept((Object)CognitoAuthExceptionConverter.lookup(error, "Resend confirmation code failed"));
            }
        });
    }

    public void resendSignUpCode(@NonNull String username, @NonNull Consumer<AuthSignUpResult> onSuccess, @NonNull Consumer<AuthException> onException) {
        this.resendSignUpCode(username, (AuthResendSignUpCodeOptions)AuthResendSignUpCodeOptions.defaults(), onSuccess, onException);
    }

    public void signIn(@Nullable String username, @Nullable String password, @NonNull AuthSignInOptions options, final @NonNull Consumer<AuthSignInResult> onSuccess, final @NonNull Consumer<AuthException> onException) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        Enum authFlowType = null;
        if (options instanceof AWSCognitoAuthSignInOptions) {
            metadata.putAll(((AWSCognitoAuthSignInOptions)options).getMetadata());
            authFlowType = ((AWSCognitoAuthSignInOptions)options).getAuthFlowType();
        }
        AuthFlowType sdkAuthFlowType = null;
        if (authFlowType != null) {
            sdkAuthFlowType = AuthFlowType.valueOf((String)authFlowType.name());
        }
        this.awsMobileClient.signIn(username, password, metadata, metadata, sdkAuthFlowType, (Callback)new Callback<SignInResult>(){

            public void onResult(SignInResult result) {
                try {
                    AuthSignInResult newResult = AWSCognitoAuthPlugin.this.convertSignInResult(result);
                    AWSCognitoAuthPlugin.this.fetchAndSetUserId(() -> onSuccess.accept((Object)newResult));
                }
                catch (AuthException exception) {
                    onException.accept((Object)exception);
                }
            }

            public void onError(Exception error) {
                onException.accept((Object)CognitoAuthExceptionConverter.lookup(error, "Sign in failed"));
            }
        });
    }

    public void signIn(@Nullable String username, @Nullable String password, @NonNull Consumer<AuthSignInResult> onSuccess, @NonNull Consumer<AuthException> onException) {
        this.signIn(username, password, (AuthSignInOptions)AuthSignInOptions.defaults(), onSuccess, onException);
    }

    public void confirmSignIn(@NonNull String confirmationCode, @NonNull AuthConfirmSignInOptions options, final @NonNull Consumer<AuthSignInResult> onSuccess, final @NonNull Consumer<AuthException> onException) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        HashMap<String, String> userAttributes = new HashMap<String, String>();
        if (options instanceof AWSCognitoAuthConfirmSignInOptions) {
            metadata.putAll(((AWSCognitoAuthConfirmSignInOptions)options).getMetadata());
            for (AuthUserAttribute attribute : ((AWSCognitoAuthConfirmSignInOptions)options).getUserAttributes()) {
                userAttributes.put(attribute.getKey().getKeyString(), attribute.getValue());
            }
        }
        this.awsMobileClient.confirmSignIn(confirmationCode, metadata, userAttributes, (Callback)new Callback<SignInResult>(){

            public void onResult(SignInResult result) {
                try {
                    AuthSignInResult newResult = AWSCognitoAuthPlugin.this.convertSignInResult(result);
                    AWSCognitoAuthPlugin.this.fetchAndSetUserId(() -> onSuccess.accept((Object)newResult));
                }
                catch (AuthException exception) {
                    onException.accept((Object)exception);
                }
            }

            public void onError(Exception error) {
                onException.accept((Object)CognitoAuthExceptionConverter.lookup(error, "Confirm sign in failed"));
            }
        });
    }

    public void confirmSignIn(@NonNull String confirmationCode, @NonNull Consumer<AuthSignInResult> onSuccess, @NonNull Consumer<AuthException> onException) {
        this.confirmSignIn(confirmationCode, (AuthConfirmSignInOptions)AuthConfirmSignInOptions.defaults(), onSuccess, onException);
    }

    public void signInWithSocialWebUI(@NonNull AuthProvider provider, @NonNull Activity callingActivity, @NonNull Consumer<AuthSignInResult> onSuccess, @NonNull Consumer<AuthException> onException) {
        this.signInWithSocialWebUI(Objects.requireNonNull(provider), Objects.requireNonNull(callingActivity), AuthWebUISignInOptions.builder().build(), Objects.requireNonNull(onSuccess), Objects.requireNonNull(onException));
    }

    public void signInWithSocialWebUI(@NonNull AuthProvider provider, @NonNull Activity callingActivity, @NonNull AuthWebUISignInOptions options, @NonNull Consumer<AuthSignInResult> onSuccess, @NonNull Consumer<AuthException> onException) {
        this.signInWithWebUIHelper(Objects.requireNonNull(provider), Objects.requireNonNull(callingActivity), Objects.requireNonNull(options), Objects.requireNonNull(onSuccess), Objects.requireNonNull(onException));
    }

    public void signInWithWebUI(@NonNull Activity callingActivity, @NonNull Consumer<AuthSignInResult> onSuccess, @NonNull Consumer<AuthException> onException) {
        this.signInWithWebUI(Objects.requireNonNull(callingActivity), AuthWebUISignInOptions.builder().build(), Objects.requireNonNull(onSuccess), Objects.requireNonNull(onException));
    }

    public void signInWithWebUI(@NonNull Activity callingActivity, @NonNull AuthWebUISignInOptions options, @NonNull Consumer<AuthSignInResult> onSuccess, @NonNull Consumer<AuthException> onException) {
        this.signInWithWebUIHelper(null, Objects.requireNonNull(callingActivity), Objects.requireNonNull(options), Objects.requireNonNull(onSuccess), Objects.requireNonNull(onException));
    }

    public void handleWebUISignInResponse(@NonNull Intent intent) {
        this.awsMobileClient.handleAuthResponse(intent);
    }

    public void fetchAuthSession(final @NonNull Consumer<AuthSession> onSuccess, final @NonNull Consumer<AuthException> onException) {
        try {
            this.awsMobileClient.currentUserState((Callback)new Callback<UserStateDetails>(){

                public void onResult(UserStateDetails result) {
                    switch (result.getUserState()) {
                        case GUEST: 
                        case SIGNED_OUT: {
                            MobileClientSessionAdapter.fetchSignedOutSession(AWSCognitoAuthPlugin.this.awsMobileClient, (Consumer<AuthSession>)onSuccess);
                            break;
                        }
                        case SIGNED_OUT_USER_POOLS_TOKENS_INVALID: 
                        case SIGNED_OUT_FEDERATED_TOKENS_INVALID: {
                            Amplify.Hub.publish(HubChannel.AUTH, HubEvent.create((Enum)AuthChannelEventName.SESSION_EXPIRED));
                            onSuccess.accept((Object)AWSCognitoAuthPlugin.this.expiredSession());
                            break;
                        }
                        default: {
                            MobileClientSessionAdapter.fetchSignedInSession(AWSCognitoAuthPlugin.this.awsMobileClient, (Consumer<AuthSession>)onSuccess);
                        }
                    }
                }

                public void onError(Exception exception) {
                    onException.accept((Object)CognitoAuthExceptionConverter.lookup(exception, "Fetching authorization session failed."));
                }
            });
        }
        catch (Throwable exception) {
            onException.accept((Object)new AuthException("An error occurred fetching authorization details for the current user", exception, "See attached exception for more details"));
        }
    }

    public void rememberDevice(final @NonNull Action onSuccess, final @NonNull Consumer<AuthException> onException) {
        this.awsMobileClient.getDeviceOperations().updateStatus(true, (Callback)new Callback<Void>(){

            public void onResult(Void result) {
                onSuccess.call();
            }

            public void onError(Exception exception) {
                onException.accept((Object)CognitoAuthExceptionConverter.lookup(exception, "Remember device failed."));
            }
        });
    }

    public void forgetDevice(final @NonNull Action onSuccess, final @NonNull Consumer<AuthException> onException) {
        this.awsMobileClient.getDeviceOperations().forget((Callback)new Callback<Void>(){

            public void onResult(Void result) {
                onSuccess.call();
            }

            public void onError(Exception exception) {
                onException.accept((Object)CognitoAuthExceptionConverter.lookup(exception, "Forget device failed."));
            }
        });
    }

    public void forgetDevice(@NonNull AuthDevice device, final @NonNull Action onSuccess, final @NonNull Consumer<AuthException> onException) {
        this.awsMobileClient.getDeviceOperations().forget(device.getDeviceId(), (Callback)new Callback<Void>(){

            public void onResult(Void result) {
                onSuccess.call();
            }

            public void onError(Exception exception) {
                onException.accept((Object)CognitoAuthExceptionConverter.lookup(exception, "Forget device failed."));
            }
        });
    }

    public void fetchDevices(final @NonNull Consumer<List<AuthDevice>> onSuccess, final @NonNull Consumer<AuthException> onException) {
        this.awsMobileClient.getDeviceOperations().list((Callback)new Callback<ListDevicesResult>(){

            public void onResult(ListDevicesResult result) {
                ArrayList<AuthDevice> devices = new ArrayList<AuthDevice>();
                for (Device device : result.getDevices()) {
                    devices.add(AuthDevice.fromId((String)device.getDeviceKey()));
                }
                onSuccess.accept(devices);
            }

            public void onError(Exception exception) {
                onException.accept((Object)CognitoAuthExceptionConverter.lookup(exception, "Fetching devices failed."));
            }
        });
    }

    public void resetPassword(@NonNull String username, @NonNull AuthResetPasswordOptions options, final @NonNull Consumer<AuthResetPasswordResult> onSuccess, final @NonNull Consumer<AuthException> onException) {
        HashMap<String, String> clientMetadata = new HashMap<String, String>();
        if (options instanceof AWSCognitoAuthResetPasswordOptions) {
            AWSCognitoAuthResetPasswordOptions cognitoOptions = (AWSCognitoAuthResetPasswordOptions)options;
            clientMetadata.putAll(cognitoOptions.getMetadata());
        }
        this.awsMobileClient.forgotPassword(username, clientMetadata, (Callback)new Callback<ForgotPasswordResult>(){

            public void onResult(ForgotPasswordResult result) {
                if (result.getState().equals((Object)ForgotPasswordState.CONFIRMATION_CODE)) {
                    onSuccess.accept((Object)new AuthResetPasswordResult(false, new AuthNextResetPasswordStep(AuthResetPasswordStep.CONFIRM_RESET_PASSWORD_WITH_CODE, Collections.emptyMap(), AWSCognitoAuthPlugin.this.convertCodeDeliveryDetails(result.getParameters()))));
                } else {
                    onException.accept((Object)new AuthException("Received an unsupported response after triggering password recovery: " + result.getState(), "This is almost certainly a bug. Please report it as an issue in our GitHub repo."));
                }
            }

            public void onError(Exception exception) {
                onException.accept((Object)CognitoAuthExceptionConverter.lookup(exception, "Reset password failed."));
            }
        });
    }

    public void resetPassword(@NonNull String username, @NonNull Consumer<AuthResetPasswordResult> onSuccess, @NonNull Consumer<AuthException> onException) {
        this.resetPassword(username, (AuthResetPasswordOptions)AuthResetPasswordOptions.defaults(), onSuccess, onException);
    }

    public void confirmResetPassword(@NonNull String newPassword, @NonNull String confirmationCode, @NonNull AuthConfirmResetPasswordOptions options, final @NonNull Action onSuccess, final @NonNull Consumer<AuthException> onException) {
        HashMap<String, String> clientMetadata = new HashMap<String, String>();
        if (options instanceof AWSCognitoAuthConfirmResetPasswordOptions) {
            AWSCognitoAuthConfirmResetPasswordOptions cognitoOptions = (AWSCognitoAuthConfirmResetPasswordOptions)options;
            clientMetadata.putAll(cognitoOptions.getMetadata());
        }
        this.awsMobileClient.confirmForgotPassword(newPassword, confirmationCode, clientMetadata, (Callback)new Callback<ForgotPasswordResult>(){

            public void onResult(ForgotPasswordResult result) {
                if (result.getState().equals((Object)ForgotPasswordState.DONE)) {
                    onSuccess.call();
                } else {
                    onException.accept((Object)new AuthException("Received an unsupported response while confirming password recovery code: " + result.getState(), "This is almost certainly a bug. Please report it as an issue in our GitHub repo."));
                }
            }

            public void onError(Exception error) {
                onException.accept((Object)CognitoAuthExceptionConverter.lookup(error, "Confirm reset password failed."));
            }
        });
    }

    public void confirmResetPassword(@NonNull String newPassword, @NonNull String confirmationCode, @NonNull Action onSuccess, @NonNull Consumer<AuthException> onException) {
        this.confirmResetPassword(newPassword, confirmationCode, (AuthConfirmResetPasswordOptions)AuthConfirmResetPasswordOptions.defaults(), onSuccess, onException);
    }

    public void updatePassword(@NonNull String oldPassword, @NonNull String newPassword, final @Nullable Action onSuccess, final @Nullable Consumer<AuthException> onException) {
        this.awsMobileClient.changePassword(oldPassword, newPassword, (Callback)new Callback<Void>(){

            public void onResult(Void result) {
                onSuccess.call();
            }

            public void onError(Exception exception) {
                onException.accept((Object)CognitoAuthExceptionConverter.lookup(exception, "Update password failed."));
            }
        });
    }

    public void fetchUserAttributes(final @NonNull Consumer<List<AuthUserAttribute>> onSuccess, final @NonNull Consumer<AuthException> onError) {
        this.awsMobileClient.getUserAttributes((Callback)new Callback<Map<String, String>>(){

            public void onResult(Map<String, String> result) {
                ArrayList<AuthUserAttribute> userAttributes = new ArrayList<AuthUserAttribute>();
                for (Map.Entry<String, String> entry : result.entrySet()) {
                    userAttributes.add(new AuthUserAttribute(AuthUserAttributeKey.custom((String)entry.getKey()), entry.getValue()));
                }
                onSuccess.accept(userAttributes);
            }

            public void onError(Exception error) {
                onError.accept((Object)CognitoAuthExceptionConverter.lookup(error, "Fetching user attributes failed."));
            }
        });
    }

    public void updateUserAttribute(@NonNull AuthUserAttribute attribute, @NonNull AuthUpdateUserAttributeOptions options, final @NonNull Consumer<AuthUpdateAttributeResult> onSuccess, final @NonNull Consumer<AuthException> onError) {
        HashMap<String, String> clientMetadata = new HashMap<String, String>();
        if (options instanceof AWSCognitoAuthUpdateUserAttributeOptions) {
            AWSCognitoAuthUpdateUserAttributeOptions cognitoOptions = (AWSCognitoAuthUpdateUserAttributeOptions)options;
            clientMetadata.putAll(cognitoOptions.getMetadata());
        }
        this.awsMobileClient.updateUserAttributes(Collections.singletonMap(attribute.getKey().getKeyString(), attribute.getValue()), clientMetadata, (Callback)new Callback<List<UserCodeDeliveryDetails>>(){

            public void onResult(List<UserCodeDeliveryDetails> result) {
                if (result.size() == 0) {
                    onSuccess.accept((Object)new AuthUpdateAttributeResult(true, new AuthNextUpdateAttributeStep(AuthUpdateAttributeStep.DONE, Collections.emptyMap(), null)));
                } else {
                    onSuccess.accept((Object)new AuthUpdateAttributeResult(true, new AuthNextUpdateAttributeStep(AuthUpdateAttributeStep.CONFIRM_ATTRIBUTE_WITH_CODE, Collections.emptyMap(), AWSCognitoAuthPlugin.this.convertCodeDeliveryDetails(result.get(0)))));
                }
            }

            public void onError(Exception error) {
                onError.accept((Object)new AuthException("Failed to update user attributes", (Throwable)error, "See attached exception for more details"));
            }
        });
    }

    public void updateUserAttribute(@NonNull AuthUserAttribute attribute, @NonNull Consumer<AuthUpdateAttributeResult> onSuccess, @NonNull Consumer<AuthException> onError) {
        this.updateUserAttribute(attribute, (AuthUpdateUserAttributeOptions)AuthUpdateUserAttributeOptions.defaults(), onSuccess, onError);
    }

    public void updateUserAttributes(@NonNull List<AuthUserAttribute> attributes, @NonNull AuthUpdateUserAttributesOptions options, final @NonNull Consumer<Map<AuthUserAttributeKey, AuthUpdateAttributeResult>> onSuccess, final @NonNull Consumer<AuthException> onError) {
        HashMap<String, String> clientMetadata = new HashMap<String, String>();
        if (options instanceof AWSCognitoAuthUpdateUserAttributesOptions) {
            AWSCognitoAuthUpdateUserAttributesOptions cognitoOptions = (AWSCognitoAuthUpdateUserAttributesOptions)options;
            clientMetadata.putAll(cognitoOptions.getMetadata());
        }
        final HashMap<String, String> attributesMap = new HashMap<String, String>();
        for (AuthUserAttribute attribute : attributes) {
            attributesMap.put(attribute.getKey().getKeyString(), attribute.getValue());
        }
        this.awsMobileClient.updateUserAttributes(attributesMap, clientMetadata, (Callback)new Callback<List<UserCodeDeliveryDetails>>(){

            public void onResult(List<UserCodeDeliveryDetails> result) {
                HashMap<String, UserCodeDeliveryDetails> codeDetailsMap = new HashMap<String, UserCodeDeliveryDetails>();
                HashMap<AuthUserAttributeKey, AuthUpdateAttributeResult> resultMap = new HashMap<AuthUserAttributeKey, AuthUpdateAttributeResult>();
                for (UserCodeDeliveryDetails details : result) {
                    codeDetailsMap.put(details.getAttributeName(), details);
                }
                for (String attributeKey : attributesMap.keySet()) {
                    if (codeDetailsMap.containsKey(attributeKey)) {
                        resultMap.put(AuthUserAttributeKey.custom((String)attributeKey), new AuthUpdateAttributeResult(true, new AuthNextUpdateAttributeStep(AuthUpdateAttributeStep.CONFIRM_ATTRIBUTE_WITH_CODE, Collections.emptyMap(), AWSCognitoAuthPlugin.this.convertCodeDeliveryDetails((UserCodeDeliveryDetails)codeDetailsMap.get(attributeKey)))));
                        continue;
                    }
                    resultMap.put(AuthUserAttributeKey.custom((String)attributeKey), new AuthUpdateAttributeResult(true, new AuthNextUpdateAttributeStep(AuthUpdateAttributeStep.DONE, Collections.emptyMap(), null)));
                }
                onSuccess.accept(resultMap);
            }

            public void onError(Exception error) {
                onError.accept((Object)new AuthException("Failed to update user attributes", (Throwable)error, "See attached exception for more details"));
            }
        });
    }

    public void updateUserAttributes(@NonNull List<AuthUserAttribute> attributes, @NonNull Consumer<Map<AuthUserAttributeKey, AuthUpdateAttributeResult>> onSuccess, @NonNull Consumer<AuthException> onError) {
        this.updateUserAttributes(attributes, (AuthUpdateUserAttributesOptions)AuthUpdateUserAttributesOptions.defaults(), onSuccess, onError);
    }

    public void resendUserAttributeConfirmationCode(@NonNull AuthUserAttributeKey attributeKey, @NonNull AuthResendUserAttributeConfirmationCodeOptions options, final @NonNull Consumer<AuthCodeDeliveryDetails> onSuccess, final @NonNull Consumer<AuthException> onError) {
        HashMap<String, String> clientMetadata = new HashMap<String, String>();
        if (options instanceof AWSCognitoAuthResendUserAttributeConfirmationCodeOptions) {
            AWSCognitoAuthResendUserAttributeConfirmationCodeOptions cognitoOptions = (AWSCognitoAuthResendUserAttributeConfirmationCodeOptions)options;
            clientMetadata.putAll(cognitoOptions.getMetadata());
        }
        String attributeName = attributeKey.getKeyString();
        this.awsMobileClient.verifyUserAttribute(attributeName, clientMetadata, (Callback)new Callback<UserCodeDeliveryDetails>(){

            public void onResult(UserCodeDeliveryDetails result) {
                onSuccess.accept((Object)AWSCognitoAuthPlugin.this.convertCodeDeliveryDetails(result));
            }

            public void onError(Exception error) {
                onError.accept((Object)new AuthException("Failed to resend user attribute confirmation code", (Throwable)error, "See attached exception for more details"));
            }
        });
    }

    public void resendUserAttributeConfirmationCode(@NonNull AuthUserAttributeKey attributeKey, @NonNull Consumer<AuthCodeDeliveryDetails> onSuccess, @NonNull Consumer<AuthException> onError) {
        this.resendUserAttributeConfirmationCode(attributeKey, (AuthResendUserAttributeConfirmationCodeOptions)AuthResendUserAttributeConfirmationCodeOptions.defaults(), onSuccess, onError);
    }

    public void confirmUserAttribute(@NonNull AuthUserAttributeKey attributeKey, @NonNull String confirmationCode, final @NonNull Action onSuccess, final @NonNull Consumer<AuthException> onError) {
        this.awsMobileClient.confirmUpdateUserAttribute(attributeKey.getKeyString(), confirmationCode, (Callback)new Callback<Void>(){

            public void onResult(Void result) {
                onSuccess.call();
            }

            public void onError(Exception error) {
                onError.accept((Object)CognitoAuthExceptionConverter.lookup(error, "Confirming user attributes failed."));
            }
        });
    }

    public AuthUser getCurrentUser() {
        if (this.userId != null && this.awsMobileClient.getUsername() != null) {
            return new AuthUser(this.userId, this.awsMobileClient.getUsername());
        }
        return null;
    }

    public void signOut(@NonNull Action onSuccess, @NonNull Consumer<AuthException> onError) {
        this.signOut(AuthSignOutOptions.builder().globalSignOut(false).build(), onSuccess, onError);
    }

    public void signOut(final @NonNull AuthSignOutOptions options, final @NonNull Action onSuccess, final @NonNull Consumer<AuthException> onError) {
        if (options.isGlobalSignOut()) {
            this.awsMobileClient.signOut(SignOutOptions.builder().signOutGlobally(true).build(), (Callback)new Callback<Void>(){

                public void onResult(Void result) {
                    onSuccess.call();
                }

                public void onError(Exception error) {
                    if (error instanceof NotAuthorizedException) {
                        AWSCognitoAuthPlugin.this.signOutLocally(options, onSuccess, (Consumer<AuthException>)onError);
                    } else if (error instanceof AuthNavigationException) {
                        onError.accept((Object)new AuthException.UserCancelledException("The user cancelled the sign-out attempt.", (Throwable)error, "To recover, catch this error, and retry sign-out."));
                    } else {
                        onError.accept((Object)new AuthException("Failed to sign out globally", (Throwable)error, "See attached exception for more details"));
                    }
                }
            });
        } else {
            this.signOutLocally(options, onSuccess, onError);
        }
    }

    public void deleteUser(final @NonNull Action onSuccess, final @NonNull Consumer<AuthException> onError) {
        this.awsMobileClient.deleteUser((Callback)new Callback<Void>(){

            public void onResult(Void result) {
                Amplify.Hub.publish(HubChannel.AUTH, HubEvent.create((Enum)AuthChannelEventName.USER_DELETED));
                onSuccess.call();
            }

            public void onError(Exception exception) {
                onError.accept((Object)CognitoAuthExceptionConverter.lookup(exception, "Delete user failed."));
            }
        });
    }

    @NonNull
    public AWSMobileClient getEscapeHatch() {
        return this.awsMobileClient;
    }

    @NonNull
    public String getVersion() {
        return "1.37.10";
    }

    private void signOutLocally(@NonNull AuthSignOutOptions options, final @NonNull Action onSuccess, final @NonNull Consumer<AuthException> onError) {
        SignOutOptions.Builder signOutOptionsBuilder = SignOutOptions.builder().signOutGlobally(false).invalidateTokens(true);
        if (options instanceof AWSCognitoAuthSignOutOptions) {
            signOutOptionsBuilder.browserPackage(((AWSCognitoAuthSignOutOptions)options).getBrowserPackage());
        }
        this.awsMobileClient.signOut(signOutOptionsBuilder.build(), (Callback)new Callback<Void>(){

            public void onResult(Void result) {
                onSuccess.call();
            }

            public void onError(Exception error) {
                if (error != null && error.getMessage() != null && error.getMessage().contains("signed-out")) {
                    onError.accept((Object)new AuthException("Failed to sign out since Auth is already signed out", "No need to sign out - you already are!"));
                } else if (error instanceof AuthNavigationException) {
                    onError.accept((Object)new AuthException.UserCancelledException("The user cancelled the sign-out attempt.", (Throwable)error, "To recover, catch this error, and retry sign-out."));
                } else {
                    onError.accept((Object)new AuthException("Failed to sign out", (Throwable)error, "See attached exception for more details"));
                }
            }
        });
    }

    private void signInWithWebUIHelper(@Nullable AuthProvider authProvider, @NonNull Activity callingActivity, @NonNull AuthWebUISignInOptions options, final @NonNull Consumer<AuthSignInResult> onSuccess, final @NonNull Consumer<AuthException> onException) {
        HostedUIOptions.Builder optionsBuilder = HostedUIOptions.builder();
        SignInUIOptions.Builder signInUIOptionsBuilder = SignInUIOptions.builder();
        if (options != null) {
            if (options.getScopes() != null) {
                optionsBuilder.scopes(options.getScopes().toArray(new String[options.getScopes().size()]));
            }
            if (!options.getSignInQueryParameters().isEmpty()) {
                optionsBuilder.signInQueryParameters(options.getSignInQueryParameters());
            }
            if (!options.getSignOutQueryParameters().isEmpty()) {
                optionsBuilder.signOutQueryParameters(options.getSignOutQueryParameters());
            }
            if (!options.getTokenQueryParameters().isEmpty()) {
                optionsBuilder.tokenQueryParameters(options.getTokenQueryParameters());
            }
            if (options instanceof AWSCognitoAuthWebUISignInOptions) {
                AWSCognitoAuthWebUISignInOptions cognitoOptions = (AWSCognitoAuthWebUISignInOptions)options;
                optionsBuilder.idpIdentifier(cognitoOptions.getIdpIdentifier()).federationProviderName(cognitoOptions.getFederationProviderName());
                signInUIOptionsBuilder.browserPackage(cognitoOptions.getBrowserPackage());
            }
            if (authProvider != null) {
                optionsBuilder.identityProvider(AuthProviderConverter.getIdentityProvider(authProvider));
            }
        }
        SignInUIOptions signInUIOptions = signInUIOptionsBuilder.hostedUIOptions(optionsBuilder.build()).build();
        this.awsMobileClient.showSignIn(callingActivity, signInUIOptions, (Callback)new Callback<UserStateDetails>(){

            public void onResult(UserStateDetails details) {
                AWSCognitoAuthPlugin.this.fetchAndSetUserId(() -> onSuccess.accept((Object)new AuthSignInResult(UserState.SIGNED_IN.equals((Object)details.getUserState()), new AuthNextSignInStep(AuthSignInStep.DONE, details.getDetails(), null))));
            }

            public void onError(Exception error) {
                if (error instanceof AuthNavigationException) {
                    onException.accept((Object)new AuthException.UserCancelledException("The user cancelled the sign-in attempt, so it did not complete.", (Throwable)error, "To recover: catch this error, and show the sign-in screen again."));
                } else {
                    onException.accept((Object)new AuthException("Sign-in with web UI failed", (Throwable)error, "See attached exception for more details"));
                }
            }
        });
    }

    private AuthSession expiredSession() {
        return new AWSCognitoAuthSession(true, (AuthSessionResult<String>)AuthSessionResult.failure((AuthException)new AuthException.SessionExpiredException()), (AuthSessionResult<AWSCredentials>)AuthSessionResult.failure((AuthException)new AuthException.SessionExpiredException()), (AuthSessionResult<String>)AuthSessionResult.failure((AuthException)new AuthException.SessionExpiredException()), (AuthSessionResult<AWSCognitoUserPoolTokens>)AuthSessionResult.failure((AuthException)new AuthException.SessionExpiredException()));
    }

    private void fetchAndSetUserId(final Action onComplete) {
        this.awsMobileClient.getTokens((Callback)new Callback<Tokens>(){

            public void onResult(Tokens result) {
                AWSCognitoAuthPlugin.this.userId = AWSCognitoAuthPlugin.this.getUserIdFromToken(result.getAccessToken().getTokenString());
                onComplete.call();
            }

            public void onError(Exception error) {
                AWSCognitoAuthPlugin.this.userId = null;
                onComplete.call();
            }
        });
    }

    private String getUserIdFromToken(String token) {
        try {
            return CognitoJWTParser.getPayload((String)token).getString(COGNITO_USER_ID_ATTRIBUTE);
        }
        catch (JSONException error) {
            return null;
        }
    }

    private AuthSignUpResult convertSignUpResult(@NonNull SignUpResult result, @NonNull String username) {
        UserCodeDeliveryDetails details = Objects.requireNonNull(result).getUserCodeDeliveryDetails();
        AuthCodeDeliveryDetails newDetails = details != null ? new AuthCodeDeliveryDetails(details.getDestination(), AuthCodeDeliveryDetails.DeliveryMedium.fromString((String)details.getDeliveryMedium()), details.getAttributeName()) : null;
        return new AuthSignUpResult(true, new AuthNextSignUpStep(result.getConfirmationState() ? AuthSignUpStep.DONE : AuthSignUpStep.CONFIRM_SIGN_UP_STEP, Collections.emptyMap(), newDetails), result.getUserSub() != null ? new AuthUser(result.getUserSub(), username) : null);
    }

    private AuthSignInResult convertSignInResult(SignInResult result) throws AuthException {
        return new AuthSignInResult(SignInState.DONE.equals((Object)result.getSignInState()), new AuthNextSignInStep(SignInStateConverter.getAuthSignInStep(result.getSignInState()), result.getParameters() == null ? Collections.emptyMap() : result.getParameters(), this.convertCodeDeliveryDetails(result.getCodeDetails())));
    }

    private AuthCodeDeliveryDetails convertCodeDeliveryDetails(UserCodeDeliveryDetails details) {
        return details != null ? new AuthCodeDeliveryDetails(details.getDestination(), AuthCodeDeliveryDetails.DeliveryMedium.fromString((String)details.getDeliveryMedium()), details.getAttributeName()) : null;
    }
}

