/*
 * Decompiled with CFR 0.152.
 */
package com.amplifyframework.auth.cognito;

import androidx.annotation.NonNull;
import androidx.core.util.ObjectsCompat;
import com.amazonaws.auth.AWSCredentials;
import com.amplifyframework.auth.AuthSession;
import com.amplifyframework.auth.cognito.AWSCognitoUserPoolTokens;
import com.amplifyframework.auth.result.AuthSessionResult;
import java.util.Objects;

public final class AWSCognitoAuthSession
extends AuthSession {
    private final AuthSessionResult<String> identityId;
    private final AuthSessionResult<AWSCredentials> awsCredentials;
    private final AuthSessionResult<String> userSub;
    private final AuthSessionResult<AWSCognitoUserPoolTokens> userPoolTokens;

    public AWSCognitoAuthSession(boolean isSignedIn, @NonNull AuthSessionResult<String> identityId, @NonNull AuthSessionResult<AWSCredentials> awsCredentials, @NonNull AuthSessionResult<String> userSub, @NonNull AuthSessionResult<AWSCognitoUserPoolTokens> userPoolTokens) {
        super(isSignedIn);
        this.identityId = Objects.requireNonNull(identityId);
        this.awsCredentials = Objects.requireNonNull(awsCredentials);
        this.userSub = Objects.requireNonNull(userSub);
        this.userPoolTokens = Objects.requireNonNull(userPoolTokens);
    }

    @NonNull
    public AuthSessionResult<AWSCredentials> getAWSCredentials() {
        return this.awsCredentials;
    }

    @NonNull
    public AuthSessionResult<String> getUserSub() {
        return this.userSub;
    }

    @NonNull
    public AuthSessionResult<String> getIdentityId() {
        return this.identityId;
    }

    @NonNull
    public AuthSessionResult<AWSCognitoUserPoolTokens> getUserPoolTokens() {
        return this.userPoolTokens;
    }

    public int hashCode() {
        return ObjectsCompat.hash((Object[])new Object[]{this.isSignedIn(), this.getAWSCredentials(), this.getUserSub(), this.getIdentityId(), this.getUserPoolTokens()});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AWSCognitoAuthSession cognitoAuthState = (AWSCognitoAuthSession)((Object)obj);
        return ObjectsCompat.equals((Object)this.isSignedIn(), (Object)cognitoAuthState.isSignedIn()) && ObjectsCompat.equals(this.getAWSCredentials(), cognitoAuthState.getAWSCredentials()) && ObjectsCompat.equals(this.getUserSub(), cognitoAuthState.getUserSub()) && ObjectsCompat.equals(this.getIdentityId(), cognitoAuthState.getIdentityId()) && ObjectsCompat.equals(this.getUserPoolTokens(), cognitoAuthState.getUserPoolTokens());
    }

    public String toString() {
        return "AWSCognitoAuthSession{isSignedIn=" + this.isSignedIn() + ", awsCredentials=" + this.getAWSCredentials() + ", userSub='" + this.getUserSub() + '\'' + ", identityId='" + this.getIdentityId() + '\'' + ", userPoolTokens='" + this.getUserPoolTokens() + '\'' + '}';
    }
}

