/*
 * Decompiled with CFR 0.152.
 */
package com.amplifyframework.auth.cognito;

import androidx.annotation.NonNull;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.mobile.client.AWSMobileClient;
import com.amazonaws.mobile.client.Callback;
import com.amazonaws.mobile.client.results.Tokens;
import com.amazonaws.mobileconnectors.cognitoidentityprovider.util.CognitoJWTParser;
import com.amplifyframework.auth.AuthException;
import com.amplifyframework.auth.AuthSession;
import com.amplifyframework.auth.cognito.AWSCognitoAuthSession;
import com.amplifyframework.auth.cognito.AWSCognitoUserPoolTokens;
import com.amplifyframework.auth.result.AuthSessionResult;
import com.amplifyframework.core.Consumer;
import java.util.Arrays;
import java.util.List;
import org.json.JSONException;

final class MobileClientSessionAdapter {
    private static final List<String> MOBILE_CLIENT_INVALID_ACCOUNT_MESSAGES = Arrays.asList("getTokens does not support retrieving tokens for federated sign-in", "You must be signed-in with Cognito Userpools to be able to use getTokens", "Tokens are not supported for OAuth2", "Cognito Identity not configured");
    private static final List<String> MOBILE_CLIENT_SIGNED_OUT_MESSAGES = Arrays.asList("getTokens does not support retrieving tokens while signed-out");

    private MobileClientSessionAdapter() {
    }

    static void fetchSignedOutSession(final @NonNull AWSMobileClient awsMobileClient, final @NonNull Consumer<AuthSession> onComplete) {
        awsMobileClient.getAWSCredentials((Callback)new Callback<AWSCredentials>(){

            public void onResult(AWSCredentials result) {
                MobileClientSessionAdapter.fetchSignedOutSessionWithAWSCredentials(result, awsMobileClient, (Consumer<AuthSession>)onComplete);
            }

            public void onError(Exception error) {
                if (error.getMessage().contains("Cognito Identity not configured")) {
                    onComplete.accept((Object)MobileClientSessionAdapter.signedOutSessionWithoutIdentityPool());
                } else {
                    onComplete.accept((Object)MobileClientSessionAdapter.signedOutSessionWithIdentityPool());
                }
            }
        });
    }

    static void fetchSignedInSession(final @NonNull AWSMobileClient awsMobileClient, final @NonNull Consumer<AuthSession> onComplete) {
        awsMobileClient.getTokens((Callback)new Callback<Tokens>(){

            public void onResult(Tokens result) {
                AuthSessionResult userSubResult;
                try {
                    userSubResult = AuthSessionResult.success((Object)CognitoJWTParser.getPayload((String)result.getAccessToken().getTokenString()).getString("sub"));
                }
                catch (JSONException error) {
                    userSubResult = AuthSessionResult.failure((AuthException)new AuthException.UnknownException((Throwable)error));
                }
                AuthSessionResult tokensResult = AuthSessionResult.success((Object)new AWSCognitoUserPoolTokens(result.getAccessToken().getTokenString(), result.getIdToken().getTokenString(), result.getRefreshToken().getTokenString()));
                MobileClientSessionAdapter.fetchSignedInSessionWithUserPoolResults((AuthSessionResult<String>)userSubResult, (AuthSessionResult<AWSCognitoUserPoolTokens>)tokensResult, awsMobileClient, (Consumer<AuthSession>)onComplete);
            }

            public void onError(Exception error) {
                if (MOBILE_CLIENT_INVALID_ACCOUNT_MESSAGES.contains(error.getMessage())) {
                    MobileClientSessionAdapter.fetchIdentityPoolOnlySignedInSession(awsMobileClient, (Consumer<AuthSession>)onComplete);
                } else if (MOBILE_CLIENT_SIGNED_OUT_MESSAGES.contains(error.getMessage())) {
                    MobileClientSessionAdapter.fetchSignedOutSession(awsMobileClient, (Consumer<AuthSession>)onComplete);
                } else {
                    MobileClientSessionAdapter.fetchSignedInSessionWithUserPoolResults((AuthSessionResult<String>)AuthSessionResult.failure((AuthException)new AuthException.UnknownException((Throwable)error)), (AuthSessionResult<AWSCognitoUserPoolTokens>)AuthSessionResult.failure((AuthException)new AuthException.UnknownException((Throwable)error)), awsMobileClient, (Consumer<AuthSession>)onComplete);
                }
            }
        });
    }

    private static void fetchIdentityPoolOnlySignedInSession(AWSMobileClient awsMobileClient, Consumer<AuthSession> onComplete) {
        AuthSessionResult userSubResult = AuthSessionResult.failure((AuthException)new AuthException.InvalidAccountTypeException());
        AuthSessionResult tokensResult = AuthSessionResult.failure((AuthException)new AuthException.InvalidAccountTypeException());
        MobileClientSessionAdapter.fetchSignedInSessionWithUserPoolResults((AuthSessionResult<String>)userSubResult, (AuthSessionResult<AWSCognitoUserPoolTokens>)tokensResult, awsMobileClient, onComplete);
    }

    private static void fetchSignedInSessionWithUserPoolResults(final AuthSessionResult<String> userSubResult, final AuthSessionResult<AWSCognitoUserPoolTokens> tokensResult, final AWSMobileClient awsMobileClient, final Consumer<AuthSession> onComplete) {
        awsMobileClient.getAWSCredentials((Callback)new Callback<AWSCredentials>(){

            public void onResult(AWSCredentials result) {
                if (result != null) {
                    MobileClientSessionAdapter.fetchSignedInSessionWithUserPoolAndAWSCredentialResults((AuthSessionResult<AWSCredentials>)AuthSessionResult.success((Object)result), (AuthSessionResult<String>)userSubResult, (AuthSessionResult<AWSCognitoUserPoolTokens>)tokensResult, awsMobileClient, (Consumer<AuthSession>)onComplete);
                } else {
                    AuthException error = new AuthException("Could not fetch AWS Cognito credentials, but there was no error reported back from AWSMobileClient.getAWSCredentials call.", "This is a bug with the underlying AWSMobileClient");
                    onComplete.accept((Object)new AWSCognitoAuthSession(true, (AuthSessionResult<String>)AuthSessionResult.failure((AuthException)error), (AuthSessionResult<AWSCredentials>)AuthSessionResult.failure((AuthException)error), (AuthSessionResult<String>)userSubResult, (AuthSessionResult<AWSCognitoUserPoolTokens>)tokensResult));
                }
            }

            public void onError(Exception error) {
                Object wrappedError = MOBILE_CLIENT_INVALID_ACCOUNT_MESSAGES.contains(error.getMessage()) ? new AuthException.InvalidAccountTypeException((Throwable)error) : new AuthException.UnknownException((Throwable)error);
                onComplete.accept((Object)new AWSCognitoAuthSession(true, (AuthSessionResult<String>)AuthSessionResult.failure((AuthException)wrappedError), (AuthSessionResult<AWSCredentials>)AuthSessionResult.failure((AuthException)wrappedError), (AuthSessionResult<String>)userSubResult, (AuthSessionResult<AWSCognitoUserPoolTokens>)tokensResult));
            }
        });
    }

    private static void fetchSignedInSessionWithUserPoolAndAWSCredentialResults(AuthSessionResult<AWSCredentials> awsCredentialsResult, AuthSessionResult<String> userSubResult, AuthSessionResult<AWSCognitoUserPoolTokens> tokensResult, AWSMobileClient awsMobileClient, Consumer<AuthSession> onComplete) {
        try {
            String identityId = awsMobileClient.getIdentityId();
            AuthSessionResult identityIdResult = identityId != null ? AuthSessionResult.success((Object)identityId) : AuthSessionResult.failure((AuthException)new AuthException("AWSMobileClient returned awsCredentials but no identity id and no error", "This should never happen and is a bug with AWSMobileClient."));
            onComplete.accept((Object)new AWSCognitoAuthSession(true, (AuthSessionResult<String>)identityIdResult, awsCredentialsResult, userSubResult, tokensResult));
        }
        catch (Throwable identityIdError) {
            onComplete.accept((Object)new AWSCognitoAuthSession(true, (AuthSessionResult<String>)AuthSessionResult.failure((AuthException)new AuthException.UnknownException(identityIdError)), awsCredentialsResult, userSubResult, tokensResult));
        }
    }

    private static void fetchSignedOutSessionWithAWSCredentials(AWSCredentials credentials, AWSMobileClient awsMobileClient, Consumer<AuthSession> onComplete) {
        try {
            String identityId = awsMobileClient.getIdentityId();
            onComplete.accept((Object)new AWSCognitoAuthSession(false, (AuthSessionResult<String>)AuthSessionResult.success((Object)identityId), (AuthSessionResult<AWSCredentials>)AuthSessionResult.success((Object)credentials), (AuthSessionResult<String>)AuthSessionResult.failure((AuthException)new AuthException.SignedOutException()), (AuthSessionResult<AWSCognitoUserPoolTokens>)AuthSessionResult.failure((AuthException)new AuthException.SignedOutException())));
        }
        catch (Throwable exception) {
            onComplete.accept((Object)new AWSCognitoAuthSession(false, (AuthSessionResult<String>)AuthSessionResult.failure((AuthException)new AuthException("Retrieved guest credentials but failed to retrieve Identity ID", exception, "This should never happen. See the attached exception for more details.")), (AuthSessionResult<AWSCredentials>)AuthSessionResult.success((Object)credentials), (AuthSessionResult<String>)AuthSessionResult.failure((AuthException)new AuthException.SignedOutException()), (AuthSessionResult<AWSCognitoUserPoolTokens>)AuthSessionResult.failure((AuthException)new AuthException.SignedOutException())));
            return;
        }
    }

    private static AuthSession signedOutSessionWithoutIdentityPool() {
        return new AWSCognitoAuthSession(false, (AuthSessionResult<String>)AuthSessionResult.failure((AuthException)new AuthException.InvalidAccountTypeException()), (AuthSessionResult<AWSCredentials>)AuthSessionResult.failure((AuthException)new AuthException.InvalidAccountTypeException()), (AuthSessionResult<String>)AuthSessionResult.failure((AuthException)new AuthException.SignedOutException()), (AuthSessionResult<AWSCognitoUserPoolTokens>)AuthSessionResult.failure((AuthException)new AuthException.SignedOutException()));
    }

    private static AuthSession signedOutSessionWithIdentityPool() {
        return new AWSCognitoAuthSession(false, (AuthSessionResult<String>)AuthSessionResult.failure((AuthException)new AuthException.SignedOutException(AuthException.GuestAccess.GUEST_ACCESS_POSSIBLE)), (AuthSessionResult<AWSCredentials>)AuthSessionResult.failure((AuthException)new AuthException.SignedOutException(AuthException.GuestAccess.GUEST_ACCESS_POSSIBLE)), (AuthSessionResult<String>)AuthSessionResult.failure((AuthException)new AuthException.SignedOutException()), (AuthSessionResult<AWSCognitoUserPoolTokens>)AuthSessionResult.failure((AuthException)new AuthException.SignedOutException()));
    }
}

