/*
 * Decompiled with CFR 0.152.
 */
package com.amplifyframework.auth.cognito.options;

import androidx.annotation.NonNull;
import androidx.core.util.ObjectsCompat;
import com.amplifyframework.auth.AuthUserAttribute;
import com.amplifyframework.auth.options.AuthConfirmSignInOptions;
import com.amplifyframework.util.Immutable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class AWSCognitoAuthConfirmSignInOptions
extends AuthConfirmSignInOptions {
    private final Map<String, String> metadata;
    private final List<AuthUserAttribute> userAttributes;

    protected AWSCognitoAuthConfirmSignInOptions(Map<String, String> metadata, List<AuthUserAttribute> userAttributes) {
        this.metadata = metadata;
        this.userAttributes = userAttributes;
    }

    @NonNull
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @NonNull
    public List<AuthUserAttribute> getUserAttributes() {
        return this.userAttributes;
    }

    @NonNull
    public static CognitoBuilder builder() {
        return new CognitoBuilder();
    }

    public int hashCode() {
        return ObjectsCompat.hash((Object[])new Object[]{this.getMetadata(), this.getUserAttributes()});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AWSCognitoAuthConfirmSignInOptions authConfirmSignInOptions = (AWSCognitoAuthConfirmSignInOptions)((Object)obj);
        return ObjectsCompat.equals(this.getMetadata(), authConfirmSignInOptions.getMetadata()) && ObjectsCompat.equals(this.getUserAttributes(), authConfirmSignInOptions.getUserAttributes());
    }

    public String toString() {
        return "AWSCognitoAuthConfirmSignInOptions{userAttributes=" + this.getUserAttributes() + ", metadata=" + this.getMetadata() + '}';
    }

    public static final class CognitoBuilder
    extends AuthConfirmSignInOptions.Builder<CognitoBuilder> {
        private Map<String, String> metadata = new HashMap<String, String>();
        private List<AuthUserAttribute> userAttributes = new ArrayList<AuthUserAttribute>();

        public CognitoBuilder getThis() {
            return this;
        }

        @NonNull
        public CognitoBuilder metadata(@NonNull Map<String, String> metadata) {
            Objects.requireNonNull(metadata);
            this.metadata.clear();
            this.metadata.putAll(metadata);
            return this.getThis();
        }

        @NonNull
        public CognitoBuilder userAttributes(@NonNull List<AuthUserAttribute> userAttributes) {
            Objects.requireNonNull(userAttributes);
            this.userAttributes.clear();
            this.userAttributes.addAll(userAttributes);
            return this.getThis();
        }

        @NonNull
        public AWSCognitoAuthConfirmSignInOptions build() {
            return new AWSCognitoAuthConfirmSignInOptions(Immutable.of(this.metadata), Immutable.of(this.userAttributes));
        }
    }
}

