/*
 * Decompiled with CFR 0.152.
 */
package com.amplifyframework.auth.cognito.options;

import androidx.annotation.NonNull;
import androidx.core.util.ObjectsCompat;
import com.amplifyframework.auth.options.AuthConfirmSignUpOptions;
import com.amplifyframework.util.Immutable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class AWSCognitoAuthConfirmSignUpOptions
extends AuthConfirmSignUpOptions {
    private final Map<String, String> clientMetadata;

    protected AWSCognitoAuthConfirmSignUpOptions(Map<String, String> clientMetadata) {
        this.clientMetadata = clientMetadata;
    }

    @NonNull
    public Map<String, String> getClientMetadata() {
        return this.clientMetadata;
    }

    @NonNull
    public static CognitoBuilder builder() {
        return new CognitoBuilder();
    }

    public int hashCode() {
        return ObjectsCompat.hash((Object[])new Object[]{this.getClientMetadata()});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AWSCognitoAuthConfirmSignUpOptions authConfirmSignUpOptions = (AWSCognitoAuthConfirmSignUpOptions)((Object)obj);
        return ObjectsCompat.equals(this.getClientMetadata(), authConfirmSignUpOptions.getClientMetadata());
    }

    public String toString() {
        return "AWSCognitoAuthConfirmSignUpOptions{metadata=" + this.clientMetadata + '}';
    }

    public static final class CognitoBuilder
    extends AuthConfirmSignUpOptions.Builder<CognitoBuilder> {
        private final Map<String, String> clientMetadata = new HashMap<String, String>();

        public CognitoBuilder getThis() {
            return this;
        }

        @NonNull
        public CognitoBuilder clientMetadata(@NonNull Map<String, String> clientMetadata) {
            Objects.requireNonNull(clientMetadata);
            this.clientMetadata.clear();
            this.clientMetadata.putAll(clientMetadata);
            return this.getThis();
        }

        @NonNull
        public AWSCognitoAuthConfirmSignUpOptions build() {
            return new AWSCognitoAuthConfirmSignUpOptions(Immutable.of(this.clientMetadata));
        }
    }
}

