/*
 * Decompiled with CFR 0.152.
 */
package com.amplifyframework.auth.cognito.options;

import androidx.annotation.NonNull;
import androidx.core.util.ObjectsCompat;
import com.amplifyframework.auth.cognito.options.AuthFlowType;
import com.amplifyframework.auth.options.AuthSignInOptions;
import com.amplifyframework.util.Immutable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class AWSCognitoAuthSignInOptions
extends AuthSignInOptions {
    private final Map<String, String> metadata;
    private final AuthFlowType authFlowType;

    protected AWSCognitoAuthSignInOptions(Map<String, String> metadata, AuthFlowType authFlowType) {
        this.metadata = metadata;
        this.authFlowType = authFlowType;
    }

    @NonNull
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @NonNull
    public AuthFlowType getAuthFlowType() {
        return this.authFlowType;
    }

    @NonNull
    public static CognitoBuilder builder() {
        return new CognitoBuilder();
    }

    public int hashCode() {
        return ObjectsCompat.hash((Object[])new Object[]{this.getMetadata()});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AWSCognitoAuthSignInOptions authSignInOptions = (AWSCognitoAuthSignInOptions)((Object)obj);
        return ObjectsCompat.equals(this.getMetadata(), authSignInOptions.getMetadata());
    }

    public String toString() {
        return "AWSCognitoAuthSignInOptions{metadata=" + this.metadata + '}';
    }

    public static final class CognitoBuilder
    extends AuthSignInOptions.Builder<CognitoBuilder> {
        private Map<String, String> metadata = new HashMap<String, String>();
        private AuthFlowType authFlowType;

        public CognitoBuilder getThis() {
            return this;
        }

        @NonNull
        public CognitoBuilder metadata(@NonNull Map<String, String> metadata) {
            Objects.requireNonNull(metadata);
            this.metadata.clear();
            this.metadata.putAll(metadata);
            return this.getThis();
        }

        @NonNull
        public CognitoBuilder authFlowType(@NonNull AuthFlowType authFlowType) {
            this.authFlowType = authFlowType;
            return this.getThis();
        }

        @NonNull
        public AWSCognitoAuthSignInOptions build() {
            return new AWSCognitoAuthSignInOptions(Immutable.of(this.metadata), this.authFlowType);
        }
    }
}

