/*
 * Decompiled with CFR 0.152.
 */
package com.amplifyframework.auth.cognito.options;

import androidx.annotation.NonNull;
import androidx.core.util.ObjectsCompat;
import com.amplifyframework.auth.AuthUserAttribute;
import com.amplifyframework.auth.options.AuthSignUpOptions;
import com.amplifyframework.util.Immutable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class AWSCognitoAuthSignUpOptions
extends AuthSignUpOptions {
    private final Map<String, String> clientMetadata;
    private final Map<String, String> validationData;

    protected AWSCognitoAuthSignUpOptions(List<AuthUserAttribute> userAttributes, Map<String, String> validationData, Map<String, String> clientMetadata) {
        super(userAttributes);
        this.validationData = validationData;
        this.clientMetadata = clientMetadata;
    }

    @NonNull
    public Map<String, String> getValidationData() {
        return this.validationData;
    }

    @NonNull
    public Map<String, String> getClientMetadata() {
        return this.clientMetadata;
    }

    @NonNull
    public static CognitoBuilder builder() {
        return new CognitoBuilder();
    }

    public int hashCode() {
        return ObjectsCompat.hash((Object[])new Object[]{this.getUserAttributes(), this.getValidationData(), this.getClientMetadata()});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AWSCognitoAuthSignUpOptions authSignUpOptions = (AWSCognitoAuthSignUpOptions)((Object)obj);
        return ObjectsCompat.equals((Object)this.getUserAttributes(), (Object)authSignUpOptions.getUserAttributes()) && ObjectsCompat.equals(this.getValidationData(), authSignUpOptions.getValidationData()) && ObjectsCompat.equals(this.getClientMetadata(), authSignUpOptions.getClientMetadata());
    }

    public String toString() {
        return "AWSCognitoAuthSignUpOptions{userAttributes=" + this.getUserAttributes() + ", validationData=" + this.getValidationData() + ", clientMetadata=" + this.getClientMetadata() + '}';
    }

    public static final class CognitoBuilder
    extends AuthSignUpOptions.Builder<CognitoBuilder> {
        private Map<String, String> validationData = new HashMap<String, String>();
        private Map<String, String> clientMetadata = new HashMap<String, String>();

        public CognitoBuilder getThis() {
            return this;
        }

        @NonNull
        public CognitoBuilder validationData(@NonNull Map<String, String> validationData) {
            Objects.requireNonNull(validationData);
            this.validationData.clear();
            this.validationData.putAll(validationData);
            return this.getThis();
        }

        @NonNull
        public CognitoBuilder clientMetadata(@NonNull Map<String, String> clientMetadata) {
            Objects.requireNonNull(clientMetadata);
            this.clientMetadata.clear();
            this.clientMetadata.putAll(clientMetadata);
            return this.getThis();
        }

        @NonNull
        public AWSCognitoAuthSignUpOptions build() {
            return new AWSCognitoAuthSignUpOptions(Immutable.of((List)super.getUserAttributes()), Immutable.of(this.validationData), Immutable.of(this.clientMetadata));
        }
    }
}

