/*
 * Decompiled with CFR 0.152.
 */
package com.amplifyframework.auth.cognito.options;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.ObjectsCompat;
import com.amplifyframework.auth.options.AuthWebUISignInOptions;
import com.amplifyframework.util.Immutable;
import java.util.List;
import java.util.Map;

public final class AWSCognitoAuthWebUISignInOptions
extends AuthWebUISignInOptions {
    private final String idpIdentifier;
    private final String federationProviderName;
    private final String browserPackage;

    protected AWSCognitoAuthWebUISignInOptions(List<String> scopes, Map<String, String> signInQueryParameters, Map<String, String> signOutQueryParameters, Map<String, String> tokenQueryParameters, String idpIdentifier, String federationProviderName, String browserPackage) {
        super(scopes, signInQueryParameters, signOutQueryParameters, tokenQueryParameters);
        this.idpIdentifier = idpIdentifier;
        this.federationProviderName = federationProviderName;
        this.browserPackage = browserPackage;
    }

    @Nullable
    public String getIdpIdentifier() {
        return this.idpIdentifier;
    }

    @Nullable
    public String getFederationProviderName() {
        return this.federationProviderName;
    }

    @Nullable
    public String getBrowserPackage() {
        return this.browserPackage;
    }

    @NonNull
    public static CognitoBuilder builder() {
        return new CognitoBuilder();
    }

    public int hashCode() {
        return ObjectsCompat.hash((Object[])new Object[]{this.getScopes(), this.getSignInQueryParameters(), this.getSignOutQueryParameters(), this.getTokenQueryParameters(), this.getIdpIdentifier(), this.getFederationProviderName(), this.getBrowserPackage()});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AWSCognitoAuthWebUISignInOptions webUISignInOptions = (AWSCognitoAuthWebUISignInOptions)((Object)obj);
        return ObjectsCompat.equals((Object)this.getScopes(), (Object)webUISignInOptions.getScopes()) && ObjectsCompat.equals((Object)this.getSignInQueryParameters(), (Object)webUISignInOptions.getSignInQueryParameters()) && ObjectsCompat.equals((Object)this.getSignOutQueryParameters(), (Object)webUISignInOptions.getSignOutQueryParameters()) && ObjectsCompat.equals((Object)this.getTokenQueryParameters(), (Object)webUISignInOptions.getTokenQueryParameters()) && ObjectsCompat.equals((Object)this.getIdpIdentifier(), (Object)webUISignInOptions.getIdpIdentifier()) && ObjectsCompat.equals((Object)this.getFederationProviderName(), (Object)webUISignInOptions.getFederationProviderName()) && ObjectsCompat.equals((Object)this.getBrowserPackage(), (Object)webUISignInOptions.getBrowserPackage());
    }

    public String toString() {
        return "AWSCognitoAuthWebUISignInOptions{scopes=" + this.getScopes() + ", signInQueryParameters=" + this.getSignInQueryParameters() + ", signOutQueryParameters=" + this.getSignOutQueryParameters() + ", tokenQueryParameters=" + this.getTokenQueryParameters() + ", idpIdentifier=" + this.getIdpIdentifier() + ", federationProviderName=" + this.getFederationProviderName() + ", browserPackage=" + this.getBrowserPackage() + '}';
    }

    public static final class CognitoBuilder
    extends AuthWebUISignInOptions.Builder<CognitoBuilder> {
        private String idpIdentifier;
        private String federationProviderName;
        private String browserPackage;

        public CognitoBuilder getThis() {
            return this;
        }

        @NonNull
        public CognitoBuilder idpIdentifier(@NonNull String idpIdentifier) {
            this.idpIdentifier = idpIdentifier;
            return this.getThis();
        }

        @NonNull
        public CognitoBuilder federationProviderName(@NonNull String federationProviderName) {
            this.federationProviderName = federationProviderName;
            return this.getThis();
        }

        public CognitoBuilder browserPackage(@NonNull String browserPackage) {
            this.browserPackage = browserPackage;
            return this;
        }

        @NonNull
        public AWSCognitoAuthWebUISignInOptions build() {
            return new AWSCognitoAuthWebUISignInOptions(Immutable.of((List)super.getScopes()), Immutable.of((Map)super.getSignInQueryParameters()), Immutable.of((Map)super.getSignOutQueryParameters()), Immutable.of((Map)super.getTokenQueryParameters()), this.idpIdentifier, this.federationProviderName, this.browserPackage);
        }
    }
}

