/*
 * Decompiled with CFR 0.152.
 */
package com.amplifyframework.auth.cognito.util;

import com.amplifyframework.auth.AuthProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class AuthProviderConverter {
    private static final Map<AuthProvider, String> CONVERT_AUTH_PROVIDER;

    private AuthProviderConverter() {
    }

    public static String getIdentityProvider(AuthProvider fromProvider) {
        String convertedVal = CONVERT_AUTH_PROVIDER.get(fromProvider);
        if (convertedVal != null) {
            return convertedVal;
        }
        return fromProvider.getProviderKey();
    }

    static {
        HashMap<AuthProvider, String> convertAuthProviderInit = new HashMap<AuthProvider, String>();
        convertAuthProviderInit.put(AuthProvider.amazon(), "LoginWithAmazon");
        convertAuthProviderInit.put(AuthProvider.facebook(), "Facebook");
        convertAuthProviderInit.put(AuthProvider.google(), "Google");
        convertAuthProviderInit.put(AuthProvider.apple(), "SignInWithApple");
        CONVERT_AUTH_PROVIDER = Collections.unmodifiableMap(convertAuthProviderInit);
    }
}

