/*
 * Decompiled with CFR 0.152.
 */
package com.amplifyframework.auth.cognito.util;

import androidx.annotation.NonNull;
import com.amazonaws.services.cognitoidentityprovider.model.AliasExistsException;
import com.amazonaws.services.cognitoidentityprovider.model.CodeDeliveryFailureException;
import com.amazonaws.services.cognitoidentityprovider.model.CodeMismatchException;
import com.amazonaws.services.cognitoidentityprovider.model.ExpiredCodeException;
import com.amazonaws.services.cognitoidentityprovider.model.InvalidParameterException;
import com.amazonaws.services.cognitoidentityprovider.model.InvalidPasswordException;
import com.amazonaws.services.cognitoidentityprovider.model.InvalidUserPoolConfigurationException;
import com.amazonaws.services.cognitoidentityprovider.model.LimitExceededException;
import com.amazonaws.services.cognitoidentityprovider.model.MFAMethodNotFoundException;
import com.amazonaws.services.cognitoidentityprovider.model.NotAuthorizedException;
import com.amazonaws.services.cognitoidentityprovider.model.PasswordResetRequiredException;
import com.amazonaws.services.cognitoidentityprovider.model.ResourceNotFoundException;
import com.amazonaws.services.cognitoidentityprovider.model.SoftwareTokenMFANotFoundException;
import com.amazonaws.services.cognitoidentityprovider.model.TooManyFailedAttemptsException;
import com.amazonaws.services.cognitoidentityprovider.model.TooManyRequestsException;
import com.amazonaws.services.cognitoidentityprovider.model.UserNotConfirmedException;
import com.amazonaws.services.cognitoidentityprovider.model.UserNotFoundException;
import com.amazonaws.services.cognitoidentityprovider.model.UsernameExistsException;
import com.amplifyframework.auth.AuthException;

public final class CognitoAuthExceptionConverter {
    private CognitoAuthExceptionConverter() {
    }

    @NonNull
    public static AuthException lookup(@NonNull Exception error, @NonNull String fallbackMessage) {
        if (error instanceof UserNotFoundException) {
            return new AuthException.UserNotFoundException((Throwable)error);
        }
        if (error instanceof UserNotConfirmedException) {
            return new AuthException.UserNotConfirmedException((Throwable)error);
        }
        if (error instanceof UsernameExistsException) {
            return new AuthException.UsernameExistsException((Throwable)error);
        }
        if (error instanceof AliasExistsException) {
            return new AuthException.AliasExistsException((Throwable)error);
        }
        if (error instanceof InvalidPasswordException) {
            return new AuthException.InvalidPasswordException((Throwable)error);
        }
        if (error instanceof InvalidParameterException) {
            return new AuthException.InvalidParameterException((Throwable)error);
        }
        if (error instanceof InvalidUserPoolConfigurationException) {
            return new AuthException.InvalidUserPoolConfigurationException((Throwable)error);
        }
        if (error instanceof ExpiredCodeException) {
            return new AuthException.CodeExpiredException((Throwable)error);
        }
        if (error instanceof CodeMismatchException) {
            return new AuthException.CodeMismatchException((Throwable)error);
        }
        if (error instanceof CodeDeliveryFailureException) {
            return new AuthException.CodeDeliveryFailureException((Throwable)error);
        }
        if (error instanceof LimitExceededException) {
            return new AuthException.LimitExceededException((Throwable)error);
        }
        if (error instanceof MFAMethodNotFoundException) {
            return new AuthException.MFAMethodNotFoundException((Throwable)error);
        }
        if (error instanceof NotAuthorizedException) {
            return new AuthException.NotAuthorizedException((Throwable)error);
        }
        if (error instanceof ResourceNotFoundException) {
            return new AuthException.ResourceNotFoundException((Throwable)error);
        }
        if (error instanceof SoftwareTokenMFANotFoundException) {
            return new AuthException.SoftwareTokenMFANotFoundException((Throwable)error);
        }
        if (error instanceof TooManyFailedAttemptsException) {
            return new AuthException.FailedAttemptsLimitExceededException((Throwable)error);
        }
        if (error instanceof TooManyRequestsException) {
            return new AuthException.TooManyRequestsException((Throwable)error);
        }
        if (error instanceof PasswordResetRequiredException) {
            return new AuthException.PasswordResetRequiredException((Throwable)error);
        }
        return new AuthException(fallbackMessage, (Throwable)error, "See attached exception for more details.");
    }
}

