/*
 * Decompiled with CFR 0.152.
 */
package com.amplifyframework.auth.cognito.util;

import com.amazonaws.mobile.client.results.SignInState;
import com.amplifyframework.auth.AuthException;
import com.amplifyframework.auth.result.step.AuthSignInStep;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class SignInStateConverter {
    private static final Map<SignInState, AuthSignInStep> CONVERT_SIGN_IN_STATE;

    private SignInStateConverter() {
    }

    public static AuthSignInStep getAuthSignInStep(SignInState fromState) throws AuthException {
        AuthSignInStep convertedVal = CONVERT_SIGN_IN_STATE.get(fromState);
        if (convertedVal != null) {
            return convertedVal;
        }
        throw new AuthException("Unsupported sign in state", "We currently do not support the " + fromState + " state from AWSMobileClient. If this error is reached, please report it as a bug");
    }

    static {
        HashMap<SignInState, AuthSignInStep> convertSignInStateInit = new HashMap<SignInState, AuthSignInStep>();
        convertSignInStateInit.put(SignInState.SMS_MFA, AuthSignInStep.CONFIRM_SIGN_IN_WITH_SMS_MFA_CODE);
        convertSignInStateInit.put(SignInState.CUSTOM_CHALLENGE, AuthSignInStep.CONFIRM_SIGN_IN_WITH_CUSTOM_CHALLENGE);
        convertSignInStateInit.put(SignInState.NEW_PASSWORD_REQUIRED, AuthSignInStep.CONFIRM_SIGN_IN_WITH_NEW_PASSWORD);
        convertSignInStateInit.put(SignInState.DONE, AuthSignInStep.DONE);
        CONVERT_SIGN_IN_STATE = Collections.unmodifiableMap(convertSignInStateInit);
    }
}

