/*
 * Decompiled with CFR 0.152.
 */
package com.amplifyframework.auth.cognito;

import com.amplifyframework.auth.AWSAuthSessionBehavior;
import com.amplifyframework.auth.AWSCognitoUserPoolTokens;
import com.amplifyframework.auth.AWSCredentials;
import com.amplifyframework.auth.AuthException;
import com.amplifyframework.auth.cognito.AWSCognitoAuthSession;
import com.amplifyframework.auth.cognito.helpers.SessionHelper;
import com.amplifyframework.auth.exceptions.ConfigurationException;
import com.amplifyframework.auth.exceptions.InvalidStateException;
import com.amplifyframework.auth.exceptions.SignedOutException;
import com.amplifyframework.auth.exceptions.UnknownException;
import com.amplifyframework.auth.result.AuthSessionResult;
import com.amplifyframework.statemachine.codegen.data.AmplifyCredential;
import com.amplifyframework.statemachine.codegen.data.CognitoUserPoolTokens;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0000\u001a\f\u0010\u0006\u001a\u00020\u0007*\u00020\u0003H\u0000\u00a8\u0006\b"}, d2={"getCognitoSession", "Lcom/amplifyframework/auth/AWSAuthSessionBehavior;", "Lcom/amplifyframework/auth/AWSCognitoUserPoolTokens;", "Lcom/amplifyframework/statemachine/codegen/data/AmplifyCredential;", "exception", "Lcom/amplifyframework/auth/AuthException;", "isValid", "", "aws-auth-cognito_release"})
@SourceDebugExtension(value={"SMAP\nAWSCognitoAuthSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AWSCognitoAuthSession.kt\ncom/amplifyframework/auth/cognito/AWSCognitoAuthSessionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,178:1\n1#2:179\n*E\n"})
public final class AWSCognitoAuthSessionKt {
    public static final boolean isValid(@NotNull AmplifyCredential $this$isValid) {
        Intrinsics.checkNotNullParameter((Object)$this$isValid, (String)"<this>");
        AmplifyCredential amplifyCredential = $this$isValid;
        return amplifyCredential instanceof AmplifyCredential.UserPool ? SessionHelper.INSTANCE.isValidTokens(((AmplifyCredential.UserPool)$this$isValid).getSignedInData().getCognitoUserPoolTokens()) : (amplifyCredential instanceof AmplifyCredential.UserAndIdentityPool ? SessionHelper.INSTANCE.isValidTokens(((AmplifyCredential.UserAndIdentityPool)$this$isValid).getSignedInData().getCognitoUserPoolTokens()) && SessionHelper.INSTANCE.isValidSession(((AmplifyCredential.UserAndIdentityPool)$this$isValid).getCredentials()) : (amplifyCredential instanceof AmplifyCredential.IdentityPoolTypeCredential ? SessionHelper.INSTANCE.isValidSession(((AmplifyCredential.IdentityPoolTypeCredential)((Object)$this$isValid)).getCredentials()) : false));
    }

    @NotNull
    public static final AWSAuthSessionBehavior<AWSCognitoUserPoolTokens> getCognitoSession(@NotNull AmplifyCredential $this$getCognitoSession, @Nullable AuthException exception) {
        AWSAuthSessionBehavior aWSAuthSessionBehavior;
        Intrinsics.checkNotNullParameter((Object)$this$getCognitoSession, (String)"<this>");
        AmplifyCredential amplifyCredential = $this$getCognitoSession;
        if (amplifyCredential instanceof AmplifyCredential.UserPool) {
            AuthSessionResult authSessionResult = AuthSessionResult.failure((AuthException)((AuthException)new ConfigurationException("Could not retrieve Identity ID", "Cognito Identity not configured. Please check amplifyconfiguration.json file.", null, 4, null)));
            Intrinsics.checkNotNullExpressionValue((Object)authSessionResult, (String)"failure(...)");
            AuthSessionResult authSessionResult2 = AuthSessionResult.failure((AuthException)((AuthException)new ConfigurationException("Could not fetch AWS Cognito credentials", "Cognito Identity not configured. Please check amplifyconfiguration.json file.", null, 4, null)));
            Intrinsics.checkNotNullExpressionValue((Object)authSessionResult2, (String)"failure(...)");
            aWSAuthSessionBehavior = new AWSCognitoAuthSession(true, (AuthSessionResult<String>)authSessionResult, (AuthSessionResult<AWSCredentials>)authSessionResult2, AWSCognitoAuthSessionKt.getCognitoSession$getUserSubResult(((AmplifyCredential.UserPool)$this$getCognitoSession).getSignedInData().getCognitoUserPoolTokens(), exception), AWSCognitoAuthSessionKt.getCognitoSession$getUserPoolTokensResult(((AmplifyCredential.UserPool)$this$getCognitoSession).getSignedInData().getCognitoUserPoolTokens(), exception));
        } else if (amplifyCredential instanceof AmplifyCredential.UserAndIdentityPool) {
            aWSAuthSessionBehavior = new AWSCognitoAuthSession(true, AWSCognitoAuthSessionKt.getCognitoSession$getIdentityIdResult(((AmplifyCredential.UserAndIdentityPool)$this$getCognitoSession).getIdentityId(), exception), AWSCognitoAuthSessionKt.getCognitoSession$getCredentialsResult(((AmplifyCredential.UserAndIdentityPool)$this$getCognitoSession).getCredentials(), exception), AWSCognitoAuthSessionKt.getCognitoSession$getUserSubResult(((AmplifyCredential.UserAndIdentityPool)$this$getCognitoSession).getSignedInData().getCognitoUserPoolTokens(), exception), AWSCognitoAuthSessionKt.getCognitoSession$getUserPoolTokensResult(((AmplifyCredential.UserAndIdentityPool)$this$getCognitoSession).getSignedInData().getCognitoUserPoolTokens(), exception));
        } else if (amplifyCredential instanceof AmplifyCredential.IdentityPool) {
            AuthSessionResult<String> authSessionResult = AWSCognitoAuthSessionKt.getCognitoSession$getIdentityIdResult(((AmplifyCredential.IdentityPool)$this$getCognitoSession).getIdentityId(), exception);
            AuthSessionResult<AWSCredentials> authSessionResult3 = AWSCognitoAuthSessionKt.getCognitoSession$getCredentialsResult(((AmplifyCredential.IdentityPool)$this$getCognitoSession).getCredentials(), exception);
            AuthSessionResult authSessionResult4 = AuthSessionResult.failure((AuthException)((AuthException)new SignedOutException(null, null, null, 7, null)));
            Intrinsics.checkNotNullExpressionValue((Object)authSessionResult4, (String)"failure(...)");
            AuthSessionResult authSessionResult5 = AuthSessionResult.failure((AuthException)((AuthException)new SignedOutException(null, null, null, 7, null)));
            Intrinsics.checkNotNullExpressionValue((Object)authSessionResult5, (String)"failure(...)");
            aWSAuthSessionBehavior = new AWSCognitoAuthSession(false, authSessionResult, authSessionResult3, (AuthSessionResult<String>)authSessionResult4, (AuthSessionResult<AWSCognitoUserPoolTokens>)authSessionResult5);
        } else if (amplifyCredential instanceof AmplifyCredential.IdentityPoolFederated) {
            InvalidStateException userPoolException = new InvalidStateException("Users Federated to Identity Pool do not have User Pool access.", "To access User Pool data, you must use a Sign In method.", null, 4, null);
            AuthSessionResult<String> authSessionResult = AWSCognitoAuthSessionKt.getCognitoSession$getIdentityIdResult(((AmplifyCredential.IdentityPoolFederated)$this$getCognitoSession).getIdentityId(), exception);
            AuthSessionResult<AWSCredentials> authSessionResult6 = AWSCognitoAuthSessionKt.getCognitoSession$getCredentialsResult(((AmplifyCredential.IdentityPoolFederated)$this$getCognitoSession).getCredentials(), exception);
            AuthSessionResult authSessionResult7 = AuthSessionResult.failure((AuthException)((AuthException)userPoolException));
            Intrinsics.checkNotNullExpressionValue((Object)authSessionResult7, (String)"failure(...)");
            AuthSessionResult authSessionResult8 = AuthSessionResult.failure((AuthException)((AuthException)userPoolException));
            Intrinsics.checkNotNullExpressionValue((Object)authSessionResult8, (String)"failure(...)");
            aWSAuthSessionBehavior = new AWSCognitoAuthSession(true, authSessionResult, authSessionResult6, (AuthSessionResult<String>)authSessionResult7, (AuthSessionResult<AWSCognitoUserPoolTokens>)authSessionResult8);
        } else {
            AuthSessionResult authSessionResult = AuthSessionResult.failure((AuthException)exception);
            Intrinsics.checkNotNullExpressionValue((Object)authSessionResult, (String)"failure(...)");
            AuthSessionResult authSessionResult9 = AuthSessionResult.failure((AuthException)exception);
            Intrinsics.checkNotNullExpressionValue((Object)authSessionResult9, (String)"failure(...)");
            AuthSessionResult authSessionResult10 = AuthSessionResult.failure((AuthException)exception);
            Intrinsics.checkNotNullExpressionValue((Object)authSessionResult10, (String)"failure(...)");
            AuthSessionResult authSessionResult11 = AuthSessionResult.failure((AuthException)exception);
            Intrinsics.checkNotNullExpressionValue((Object)authSessionResult11, (String)"failure(...)");
            aWSAuthSessionBehavior = new AWSCognitoAuthSession(false, (AuthSessionResult<String>)authSessionResult, (AuthSessionResult<AWSCredentials>)authSessionResult9, (AuthSessionResult<String>)authSessionResult10, (AuthSessionResult<AWSCognitoUserPoolTokens>)authSessionResult11);
        }
        return aWSAuthSessionBehavior;
    }

    public static /* synthetic */ AWSAuthSessionBehavior getCognitoSession$default(AmplifyCredential amplifyCredential, AuthException authException, int n, Object object) {
        if ((n & 1) != 0) {
            authException = null;
        }
        return AWSCognitoAuthSessionKt.getCognitoSession(amplifyCredential, authException);
    }

    private static final AuthSessionResult<AWSCredentials> getCognitoSession$getCredentialsResult(com.amplifyframework.statemachine.codegen.data.AWSCredentials awsCredentials, AuthException exception) {
        AuthSessionResult authSessionResult;
        AuthSessionResult authSessionResult2;
        AuthSessionResult authSessionResult3;
        if (exception != null && !(exception instanceof SignedOutException)) {
            AuthSessionResult authSessionResult4 = AuthSessionResult.failure((AuthException)exception);
            Intrinsics.checkNotNullExpressionValue((Object)authSessionResult4, (String)"failure(...)");
            return authSessionResult4;
        }
        com.amplifyframework.statemachine.codegen.data.AWSCredentials $this$getCognitoSession_u24getCredentialsResult_u24lambda_u240 = awsCredentials;
        boolean bl = false;
        AWSCredentials aWSCredentials = AWSCredentials.Factory.createAWSCredentials($this$getCognitoSession_u24getCredentialsResult_u24lambda_u240.getAccessKeyId(), $this$getCognitoSession_u24getCredentialsResult_u24lambda_u240.getSecretAccessKey(), $this$getCognitoSession_u24getCredentialsResult_u24lambda_u240.getSessionToken(), $this$getCognitoSession_u24getCredentialsResult_u24lambda_u240.getExpiration());
        if (aWSCredentials != null) {
            AWSCredentials it = aWSCredentials;
            boolean bl2 = false;
            authSessionResult3 = AuthSessionResult.success((Object)it);
        } else {
            authSessionResult3 = authSessionResult2 = null;
        }
        if (authSessionResult2 == null) {
            AuthSessionResult authSessionResult5 = AuthSessionResult.failure((AuthException)((AuthException)new UnknownException("Failed to fetch AWS credentials.", null, 2, null)));
            authSessionResult = authSessionResult5;
            Intrinsics.checkNotNullExpressionValue((Object)authSessionResult5, (String)"failure(...)");
        } else {
            authSessionResult = authSessionResult2;
        }
        return authSessionResult;
    }

    private static final AuthSessionResult<String> getCognitoSession$getIdentityIdResult(String identityId, AuthException exception) {
        AuthSessionResult authSessionResult;
        if (exception != null && !(exception instanceof SignedOutException)) {
            AuthSessionResult authSessionResult2 = AuthSessionResult.failure((AuthException)exception);
            Intrinsics.checkNotNull((Object)authSessionResult2);
            authSessionResult = authSessionResult2;
        } else if (((CharSequence)identityId).length() > 0) {
            AuthSessionResult authSessionResult3 = AuthSessionResult.success((Object)identityId);
            Intrinsics.checkNotNull((Object)authSessionResult3);
            authSessionResult = authSessionResult3;
        } else {
            AuthSessionResult authSessionResult4 = AuthSessionResult.failure((AuthException)((AuthException)new UnknownException("Failed to fetch identity id.", null, 2, null)));
            Intrinsics.checkNotNull((Object)authSessionResult4);
            authSessionResult = authSessionResult4;
        }
        return authSessionResult;
    }

    private static final AuthSessionResult<String> getCognitoSession$getUserSubResult(CognitoUserPoolTokens userPoolTokens, AuthException exception) {
        AuthSessionResult authSessionResult;
        if (exception != null && !(exception instanceof SignedOutException)) {
            AuthSessionResult authSessionResult2 = AuthSessionResult.failure((AuthException)exception);
            Intrinsics.checkNotNullExpressionValue((Object)authSessionResult2, (String)"failure(...)");
            return authSessionResult2;
        }
        try {
            String string;
            Object object = userPoolTokens;
            if (object != null && (object = ((CognitoUserPoolTokens)object).getAccessToken()) != null) {
                Object object2 = object;
                SessionHelper sessionHelper = SessionHelper.INSTANCE;
                Object p0 = object2;
                boolean bl = false;
                string = sessionHelper.getUserSub((String)p0);
            } else {
                string = null;
            }
            authSessionResult = AuthSessionResult.success(string);
            Intrinsics.checkNotNull((Object)authSessionResult);
        }
        catch (Exception e) {
            AuthSessionResult authSessionResult3 = AuthSessionResult.failure((AuthException)((AuthException)new UnknownException(null, (Throwable)e, 1, null)));
            Intrinsics.checkNotNull((Object)authSessionResult3);
            authSessionResult = authSessionResult3;
        }
        return authSessionResult;
    }

    private static final AuthSessionResult<AWSCognitoUserPoolTokens> getCognitoSession$getUserPoolTokensResult(CognitoUserPoolTokens cognitoUserPoolTokens, AuthException exception) {
        if (exception != null && !(exception instanceof SignedOutException)) {
            AuthSessionResult authSessionResult = AuthSessionResult.failure((AuthException)exception);
            Intrinsics.checkNotNullExpressionValue((Object)authSessionResult, (String)"failure(...)");
            return authSessionResult;
        }
        AuthSessionResult authSessionResult = AuthSessionResult.success((Object)new AWSCognitoUserPoolTokens(cognitoUserPoolTokens.getAccessToken(), cognitoUserPoolTokens.getIdToken(), cognitoUserPoolTokens.getRefreshToken()));
        Intrinsics.checkNotNullExpressionValue((Object)authSessionResult, (String)"success(...)");
        return authSessionResult;
    }
}

