/*
 * Decompiled with CFR 0.152.
 */
package com.amplifyframework.auth.cognito;

import com.amplifyframework.annotations.InternalAmplifyApi;
import com.amplifyframework.auth.AuthUserAttributeKey;
import com.amplifyframework.auth.cognito.PasswordProtectionSettings;
import com.amplifyframework.auth.cognito.UsernameAttribute;
import com.amplifyframework.auth.cognito.VerificationMechanism;
import com.amplifyframework.auth.cognito.options.AuthFlowType;
import com.amplifyframework.auth.exceptions.ConfigurationException;
import com.amplifyframework.core.configuration.AmplifyOutputsData;
import com.amplifyframework.statemachine.codegen.data.IdentityPoolConfiguration;
import com.amplifyframework.statemachine.codegen.data.OauthConfiguration;
import com.amplifyframework.statemachine.codegen.data.UserPoolConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@InternalAmplifyApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0087\b\u0018\u0000 62\u00020\u0001:\u00016Ba\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0013J\u000b\u0010\"\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010%\u001a\u00020\tH\u00c6\u0003J\u000f\u0010&\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0003J\u000f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bH\u00c6\u0003J\u000f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00100\u000bH\u00c6\u0003J\u000b\u0010)\u001a\u0004\u0018\u00010\u0012H\u00c6\u0003Js\u0010*\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00c6\u0001J\u0013\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010.\u001a\u00020/H\u00d6\u0001J\u0017\u00100\u001a\u0002012\b\b\u0002\u00102\u001a\u000203H\u0000\u00a2\u0006\u0002\b4J\t\u00105\u001a\u000203H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001dR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001d\u00a8\u00067"}, d2={"Lcom/amplifyframework/auth/cognito/AuthConfiguration;", "", "userPool", "Lcom/amplifyframework/statemachine/codegen/data/UserPoolConfiguration;", "identityPool", "Lcom/amplifyframework/statemachine/codegen/data/IdentityPoolConfiguration;", "oauth", "Lcom/amplifyframework/statemachine/codegen/data/OauthConfiguration;", "authFlowType", "Lcom/amplifyframework/auth/cognito/options/AuthFlowType;", "signUpAttributes", "", "Lcom/amplifyframework/auth/AuthUserAttributeKey;", "usernameAttributes", "Lcom/amplifyframework/auth/cognito/UsernameAttribute;", "verificationMechanisms", "Lcom/amplifyframework/auth/cognito/VerificationMechanism;", "passwordProtectionSettings", "Lcom/amplifyframework/auth/cognito/PasswordProtectionSettings;", "(Lcom/amplifyframework/statemachine/codegen/data/UserPoolConfiguration;Lcom/amplifyframework/statemachine/codegen/data/IdentityPoolConfiguration;Lcom/amplifyframework/statemachine/codegen/data/OauthConfiguration;Lcom/amplifyframework/auth/cognito/options/AuthFlowType;Ljava/util/List;Ljava/util/List;Ljava/util/List;Lcom/amplifyframework/auth/cognito/PasswordProtectionSettings;)V", "getAuthFlowType", "()Lcom/amplifyframework/auth/cognito/options/AuthFlowType;", "getIdentityPool", "()Lcom/amplifyframework/statemachine/codegen/data/IdentityPoolConfiguration;", "getOauth", "()Lcom/amplifyframework/statemachine/codegen/data/OauthConfiguration;", "getPasswordProtectionSettings", "()Lcom/amplifyframework/auth/cognito/PasswordProtectionSettings;", "getSignUpAttributes", "()Ljava/util/List;", "getUserPool", "()Lcom/amplifyframework/statemachine/codegen/data/UserPoolConfiguration;", "getUsernameAttributes", "getVerificationMechanisms", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "hashCode", "", "toGen1Json", "Lorg/json/JSONObject;", "configName", "", "toGen1Json$aws_auth_cognito_release", "toString", "Companion", "aws-auth-cognito_release"})
@SourceDebugExtension(value={"SMAP\nAuthConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthConfiguration.kt\ncom/amplifyframework/auth/cognito/AuthConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,256:1\n1549#2:257\n1620#2,3:258\n1549#2:261\n1620#2,3:262\n1549#2:265\n1620#2,3:266\n1#3:269\n*S KotlinDebug\n*F\n+ 1 AuthConfiguration.kt\ncom/amplifyframework/auth/cognito/AuthConfiguration\n*L\n69#1:257\n69#1:258,3\n72#1:261\n72#1:262,3\n75#1:265\n75#1:266,3\n*E\n"})
public final class AuthConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final UserPoolConfiguration userPool;
    @Nullable
    private final IdentityPoolConfiguration identityPool;
    @Nullable
    private final OauthConfiguration oauth;
    @NotNull
    private final AuthFlowType authFlowType;
    @NotNull
    private final List<AuthUserAttributeKey> signUpAttributes;
    @NotNull
    private final List<UsernameAttribute> usernameAttributes;
    @NotNull
    private final List<VerificationMechanism> verificationMechanisms;
    @Nullable
    private final PasswordProtectionSettings passwordProtectionSettings;

    public AuthConfiguration(@Nullable UserPoolConfiguration userPool, @Nullable IdentityPoolConfiguration identityPool, @Nullable OauthConfiguration oauth, @NotNull AuthFlowType authFlowType, @NotNull List<AuthUserAttributeKey> signUpAttributes, @NotNull List<? extends UsernameAttribute> usernameAttributes, @NotNull List<? extends VerificationMechanism> verificationMechanisms, @Nullable PasswordProtectionSettings passwordProtectionSettings) {
        Intrinsics.checkNotNullParameter((Object)((Object)authFlowType), (String)"authFlowType");
        Intrinsics.checkNotNullParameter(signUpAttributes, (String)"signUpAttributes");
        Intrinsics.checkNotNullParameter(usernameAttributes, (String)"usernameAttributes");
        Intrinsics.checkNotNullParameter(verificationMechanisms, (String)"verificationMechanisms");
        this.userPool = userPool;
        this.identityPool = identityPool;
        this.oauth = oauth;
        this.authFlowType = authFlowType;
        this.signUpAttributes = signUpAttributes;
        this.usernameAttributes = usernameAttributes;
        this.verificationMechanisms = verificationMechanisms;
        this.passwordProtectionSettings = passwordProtectionSettings;
    }

    @Nullable
    public final UserPoolConfiguration getUserPool() {
        return this.userPool;
    }

    @Nullable
    public final IdentityPoolConfiguration getIdentityPool() {
        return this.identityPool;
    }

    @Nullable
    public final OauthConfiguration getOauth() {
        return this.oauth;
    }

    @NotNull
    public final AuthFlowType getAuthFlowType() {
        return this.authFlowType;
    }

    @NotNull
    public final List<AuthUserAttributeKey> getSignUpAttributes() {
        return this.signUpAttributes;
    }

    @NotNull
    public final List<UsernameAttribute> getUsernameAttributes() {
        return this.usernameAttributes;
    }

    @NotNull
    public final List<VerificationMechanism> getVerificationMechanisms() {
        return this.verificationMechanisms;
    }

    @Nullable
    public final PasswordProtectionSettings getPasswordProtectionSettings() {
        return this.passwordProtectionSettings;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JSONObject toGen1Json$aws_auth_cognito_release(@NotNull String configName) {
        JSONObject jSONObject;
        block6: {
            Object it;
            Object it2;
            void $this$mapTo$iv$iv;
            void $this$mapTo$iv$iv2;
            Collection collection;
            void $this$mapTo$iv$iv3;
            Intrinsics.checkNotNullParameter((Object)configName, (String)"configName");
            JSONObject $this$toGen1Json_u24lambda_u245 = jSONObject = new JSONObject();
            boolean bl = false;
            Iterable $this$map$iv = this.signUpAttributes;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void it3;
                AuthUserAttributeKey authUserAttributeKey = (AuthUserAttributeKey)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                String string = it3.getKeyString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKeyString(...)");
                String string2 = string.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                collection.add(string2);
            }
            List signupAttributes = (List)destination$iv$iv;
            $this$toGen1Json_u24lambda_u245.put("signupAttributes", (Object)new JSONArray((Collection)signupAttributes));
            Iterable $this$map$iv2 = this.usernameAttributes;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it4;
                UsernameAttribute bl2 = (UsernameAttribute)((Object)item$iv$iv);
                collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(AuthConfiguration.Companion.toGen1Json((UsernameAttribute)it4));
            }
            List usernameAttributes = (List)destination$iv$iv2;
            $this$toGen1Json_u24lambda_u245.put("usernameAttributes", (Object)new JSONArray((Collection)usernameAttributes));
            Iterable $this$map$iv3 = this.verificationMechanisms;
            boolean $i$f$map3 = false;
            destination$iv$iv2 = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it5;
                VerificationMechanism bl3 = (VerificationMechanism)((Object)item$iv$iv);
                collection = destination$iv$iv3;
                boolean bl4 = false;
                collection.add(AuthConfiguration.Companion.toGen1Json((VerificationMechanism)it5));
            }
            List verifyMechanisms = (List)destination$iv$iv3;
            $this$toGen1Json_u24lambda_u245.put("verificationMechanisms", (Object)new JSONArray((Collection)verifyMechanisms));
            $this$toGen1Json_u24lambda_u245.put("authenticationFlowType", (Object)this.authFlowType.name());
            OauthConfiguration oauthConfiguration = this.oauth;
            if (oauthConfiguration != null) {
                it2 = oauthConfiguration;
                boolean bl5 = false;
                $this$toGen1Json_u24lambda_u245.put("OAuth", (Object)((OauthConfiguration)it2).toGen1Json$aws_auth_cognito_release());
            }
            PasswordProtectionSettings passwordProtectionSettings = this.passwordProtectionSettings;
            if (passwordProtectionSettings != null) {
                it2 = passwordProtectionSettings;
                boolean bl6 = false;
                $this$toGen1Json_u24lambda_u245.put("passwordProtectionSettings", (Object)AuthConfiguration.Companion.toGen1Json((PasswordProtectionSettings)it2));
            }
            JSONObject authConfig = jSONObject;
            JSONObject $this$toGen1Json_u24lambda_u248 = jSONObject = new JSONObject();
            boolean bl7 = false;
            $this$toGen1Json_u24lambda_u248.put("Auth", (Object)new JSONObject().put(configName, (Object)authConfig));
            UserPoolConfiguration userPoolConfiguration = this.userPool;
            if (userPoolConfiguration != null) {
                it = userPoolConfiguration;
                boolean bl8 = false;
                $this$toGen1Json_u24lambda_u248.put("CognitoUserPool", (Object)new JSONObject().put(configName, (Object)((UserPoolConfiguration)it).toGen1Json$aws_auth_cognito_release()));
            }
            IdentityPoolConfiguration identityPoolConfiguration = this.identityPool;
            if (identityPoolConfiguration == null) break block6;
            it = identityPoolConfiguration;
            boolean bl9 = false;
            $this$toGen1Json_u24lambda_u248.put("CredentialsProvider", (Object)new JSONObject().put("CognitoIdentity", (Object)new JSONObject().put(configName, (Object)((IdentityPoolConfiguration)it).toGen1Json$aws_auth_cognito_release())));
        }
        return jSONObject;
    }

    public static /* synthetic */ JSONObject toGen1Json$aws_auth_cognito_release$default(AuthConfiguration authConfiguration, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "Default";
        }
        return authConfiguration.toGen1Json$aws_auth_cognito_release(string);
    }

    @Nullable
    public final UserPoolConfiguration component1() {
        return this.userPool;
    }

    @Nullable
    public final IdentityPoolConfiguration component2() {
        return this.identityPool;
    }

    @Nullable
    public final OauthConfiguration component3() {
        return this.oauth;
    }

    @NotNull
    public final AuthFlowType component4() {
        return this.authFlowType;
    }

    @NotNull
    public final List<AuthUserAttributeKey> component5() {
        return this.signUpAttributes;
    }

    @NotNull
    public final List<UsernameAttribute> component6() {
        return this.usernameAttributes;
    }

    @NotNull
    public final List<VerificationMechanism> component7() {
        return this.verificationMechanisms;
    }

    @Nullable
    public final PasswordProtectionSettings component8() {
        return this.passwordProtectionSettings;
    }

    @NotNull
    public final AuthConfiguration copy(@Nullable UserPoolConfiguration userPool, @Nullable IdentityPoolConfiguration identityPool, @Nullable OauthConfiguration oauth, @NotNull AuthFlowType authFlowType, @NotNull List<AuthUserAttributeKey> signUpAttributes, @NotNull List<? extends UsernameAttribute> usernameAttributes, @NotNull List<? extends VerificationMechanism> verificationMechanisms, @Nullable PasswordProtectionSettings passwordProtectionSettings) {
        Intrinsics.checkNotNullParameter((Object)((Object)authFlowType), (String)"authFlowType");
        Intrinsics.checkNotNullParameter(signUpAttributes, (String)"signUpAttributes");
        Intrinsics.checkNotNullParameter(usernameAttributes, (String)"usernameAttributes");
        Intrinsics.checkNotNullParameter(verificationMechanisms, (String)"verificationMechanisms");
        return new AuthConfiguration(userPool, identityPool, oauth, authFlowType, signUpAttributes, usernameAttributes, verificationMechanisms, passwordProtectionSettings);
    }

    public static /* synthetic */ AuthConfiguration copy$default(AuthConfiguration authConfiguration, UserPoolConfiguration userPoolConfiguration, IdentityPoolConfiguration identityPoolConfiguration, OauthConfiguration oauthConfiguration, AuthFlowType authFlowType, List list, List list2, List list3, PasswordProtectionSettings passwordProtectionSettings, int n, Object object) {
        if ((n & 1) != 0) {
            userPoolConfiguration = authConfiguration.userPool;
        }
        if ((n & 2) != 0) {
            identityPoolConfiguration = authConfiguration.identityPool;
        }
        if ((n & 4) != 0) {
            oauthConfiguration = authConfiguration.oauth;
        }
        if ((n & 8) != 0) {
            authFlowType = authConfiguration.authFlowType;
        }
        if ((n & 0x10) != 0) {
            list = authConfiguration.signUpAttributes;
        }
        if ((n & 0x20) != 0) {
            list2 = authConfiguration.usernameAttributes;
        }
        if ((n & 0x40) != 0) {
            list3 = authConfiguration.verificationMechanisms;
        }
        if ((n & 0x80) != 0) {
            passwordProtectionSettings = authConfiguration.passwordProtectionSettings;
        }
        return authConfiguration.copy(userPoolConfiguration, identityPoolConfiguration, oauthConfiguration, authFlowType, list, list2, list3, passwordProtectionSettings);
    }

    @NotNull
    public String toString() {
        return "AuthConfiguration(userPool=" + this.userPool + ", identityPool=" + this.identityPool + ", oauth=" + this.oauth + ", authFlowType=" + this.authFlowType + ", signUpAttributes=" + this.signUpAttributes + ", usernameAttributes=" + this.usernameAttributes + ", verificationMechanisms=" + this.verificationMechanisms + ", passwordProtectionSettings=" + this.passwordProtectionSettings + ")";
    }

    public int hashCode() {
        int result = this.userPool == null ? 0 : this.userPool.hashCode();
        result = result * 31 + (this.identityPool == null ? 0 : this.identityPool.hashCode());
        result = result * 31 + (this.oauth == null ? 0 : this.oauth.hashCode());
        result = result * 31 + this.authFlowType.hashCode();
        result = result * 31 + ((Object)this.signUpAttributes).hashCode();
        result = result * 31 + ((Object)this.usernameAttributes).hashCode();
        result = result * 31 + ((Object)this.verificationMechanisms).hashCode();
        result = result * 31 + (this.passwordProtectionSettings == null ? 0 : this.passwordProtectionSettings.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AuthConfiguration)) {
            return false;
        }
        AuthConfiguration authConfiguration = (AuthConfiguration)other;
        if (!Intrinsics.areEqual((Object)this.userPool, (Object)authConfiguration.userPool)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.identityPool, (Object)authConfiguration.identityPool)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.oauth, (Object)authConfiguration.oauth)) {
            return false;
        }
        if (this.authFlowType != authConfiguration.authFlowType) {
            return false;
        }
        if (!Intrinsics.areEqual(this.signUpAttributes, authConfiguration.signUpAttributes)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.usernameAttributes, authConfiguration.usernameAttributes)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.verificationMechanisms, authConfiguration.verificationMechanisms)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.passwordProtectionSettings, (Object)authConfiguration.passwordProtectionSettings);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bJ\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0002J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\tH\u0002J8\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0013\"\u0004\b\u0000\u0010\u0014*\u00020\u00152\u001d\u0010\u0016\u001a\u0019\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u0002H\u00140\u0017\u00a2\u0006\u0002\b\u0019H\u0082\bJ\f\u0010\u001a\u001a\u00020\u0010*\u00020\u001bH\u0002J\f\u0010\u001a\u001a\u00020\u001c*\u00020\u001dH\u0002J\f\u0010\u001a\u001a\u00020\u001e*\u00020\u001fH\u0002J\f\u0010 \u001a\u00020\t*\u00020\u0010H\u0002J\f\u0010 \u001a\u00020\u000b*\u00020\u001eH\u0002J\f\u0010 \u001a\u00020\u000b*\u00020\u001cH\u0002\u00a8\u0006!"}, d2={"Lcom/amplifyframework/auth/cognito/AuthConfiguration$Companion;", "", "()V", "from", "Lcom/amplifyframework/auth/cognito/AuthConfiguration;", "amplifyOutputs", "Lcom/amplifyframework/core/configuration/AmplifyOutputsData;", "fromJson", "pluginJson", "Lorg/json/JSONObject;", "configName", "", "getAuthenticationFlowType", "Lcom/amplifyframework/auth/cognito/options/AuthFlowType;", "authType", "getPasswordProtectionSettings", "Lcom/amplifyframework/auth/cognito/PasswordProtectionSettings;", "authConfig", "map", "", "T", "Lorg/json/JSONArray;", "func", "Lkotlin/Function2;", "", "Lkotlin/ExtensionFunctionType;", "toConfigType", "Lcom/amplifyframework/core/configuration/AmplifyOutputsData$Auth$PasswordPolicy;", "Lcom/amplifyframework/auth/cognito/VerificationMechanism;", "Lcom/amplifyframework/core/configuration/AmplifyOutputsData$Auth$UserVerificationTypes;", "Lcom/amplifyframework/auth/cognito/UsernameAttribute;", "Lcom/amplifyframework/core/configuration/AmplifyOutputsData$Auth$UsernameAttributes;", "toGen1Json", "aws-auth-cognito_release"})
    @SourceDebugExtension(value={"SMAP\nAuthConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthConfiguration.kt\ncom/amplifyframework/auth/cognito/AuthConfiguration$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,256:1\n221#1,3:257\n221#1,3:260\n221#1,3:263\n221#1,3:277\n1#2:266\n1549#3:267\n1620#3,3:268\n1549#3:271\n1620#3,3:272\n12474#4,2:275\n*S KotlinDebug\n*F\n+ 1 AuthConfiguration.kt\ncom/amplifyframework/auth/cognito/AuthConfiguration$Companion\n*L\n107#1:257,3\n111#1:260,3\n119#1:263,3\n198#1:277,3\n181#1:267\n181#1:268,3\n182#1:271\n182#1:272,3\n188#1:275,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final AuthConfiguration fromJson(@NotNull JSONObject pluginJson, @NotNull String configName) {
            OauthConfiguration oauthConfiguration;
            JSONObject jSONObject;
            IdentityPoolConfiguration identityPoolConfiguration;
            UserPoolConfiguration userPoolConfiguration;
            JSONObject this_$iv;
            JSONObject jSONObject2;
            UserPoolConfiguration userPoolConfiguration2;
            JSONObject jSONObject3;
            List verificationMechanisms;
            List list;
            List usernameAttributes;
            List list2;
            JSONArray jSONArray;
            List signUpAttributes;
            List list3;
            int n;
            int n2;
            Object $this$map$iv;
            Companion companion;
            JSONArray jSONArray2;
            JSONObject authConfig;
            Intrinsics.checkNotNullParameter((Object)pluginJson, (String)"pluginJson");
            Intrinsics.checkNotNullParameter((Object)configName, (String)"configName");
            JSONObject jSONObject4 = pluginJson.optJSONObject("Auth");
            Object object = authConfig = jSONObject4 != null ? jSONObject4.optJSONObject(configName) : null;
            if (authConfig != null && (jSONArray2 = authConfig.optJSONArray("signupAttributes")) != null) {
                companion = this;
                $this$map$iv = jSONArray2;
                boolean $i$f$map = false;
                int n3 = $this$map$iv.length();
                ArrayList<AuthUserAttributeKey> arrayList = new ArrayList<AuthUserAttributeKey>(n3);
                int n4 = 0;
                while (n4 < n3) {
                    void it;
                    void it$iv;
                    n = n2 = n4++;
                    ArrayList<AuthUserAttributeKey> arrayList2 = arrayList;
                    boolean $i$a$-List-AuthConfiguration$Companion$map$1$iv3 = false;
                    void var17_34 = it$iv;
                    Object $this$fromJson_u24lambda_u240 = $this$map$iv;
                    boolean bl = false;
                    String string = $this$fromJson_u24lambda_u240.getString((int)it);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                    String string2 = string.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                    arrayList2.add(AuthUserAttributeKey.custom((String)string2));
                }
                list3 = arrayList;
            } else {
                list3 = signUpAttributes = CollectionsKt.emptyList();
            }
            if (authConfig != null && (jSONArray = authConfig.optJSONArray("usernameAttributes")) != null) {
                $this$map$iv = this;
                JSONArray $this$map$iv2 = jSONArray;
                boolean $i$f$map = false;
                int n5 = $this$map$iv2.length();
                ArrayList<UsernameAttribute> arrayList = new ArrayList<UsernameAttribute>(n5);
                for (n2 = 0; n2 < n5; ++n2) {
                    void it;
                    void it$iv;
                    int n6 = n = n2;
                    ArrayList<UsernameAttribute> $i$a$-List-AuthConfiguration$Companion$map$1$iv3 = arrayList;
                    boolean $i$a$-List-AuthConfiguration$Companion$map$1$iv2 = false;
                    void $this$fromJson_u24lambda_u240 = it$iv;
                    JSONArray $this$fromJson_u24lambda_u241 = $this$map$iv2;
                    boolean bl = false;
                    String string = $this$fromJson_u24lambda_u241.getString((int)it);
                    $i$a$-List-AuthConfiguration$Companion$map$1$iv3.add(Intrinsics.areEqual((Object)string, (Object)"EMAIL") ? UsernameAttribute.Email : (Intrinsics.areEqual((Object)string, (Object)"PHONE_NUMBER") ? UsernameAttribute.PhoneNumber : UsernameAttribute.Username));
                }
                list2 = arrayList;
            } else {
                list2 = usernameAttributes = CollectionsKt.emptyList();
            }
            if (authConfig != null && (companion = authConfig.optJSONArray("verificationMechanisms")) != null) {
                Companion $this$map$iv2 = this;
                Companion $this$map$iv3 = companion;
                boolean $i$f$map = false;
                int n7 = $this$map$iv3.length();
                ArrayList<VerificationMechanism> arrayList = new ArrayList<VerificationMechanism>(n7);
                for (n = 0; n < n7; ++n) {
                    void it;
                    void it$iv;
                    int n8;
                    int $i$a$-List-AuthConfiguration$Companion$map$1$iv3 = n8 = n;
                    ArrayList<VerificationMechanism> arrayList3 = arrayList;
                    boolean bl = false;
                    void $this$fromJson_u24lambda_u241 = it$iv;
                    Companion $this$fromJson_u24lambda_u242 = $this$map$iv3;
                    boolean bl2 = false;
                    arrayList3.add(Intrinsics.areEqual((Object)$this$fromJson_u24lambda_u242.getString((int)it), (Object)"EMAIL") ? VerificationMechanism.Email : VerificationMechanism.PhoneNumber);
                }
                list = arrayList;
            } else {
                list = verificationMechanisms = CollectionsKt.emptyList();
            }
            if ((jSONObject3 = pluginJson.optJSONObject("CognitoUserPool")) != null && (jSONObject3 = jSONObject3.getJSONObject(configName)) != null) {
                JSONObject it = jSONObject3;
                boolean bl = false;
                userPoolConfiguration2 = UserPoolConfiguration.Companion.fromJson(it).build();
            } else {
                userPoolConfiguration2 = null;
            }
            companion = pluginJson.optJSONObject("CredentialsProvider");
            if (companion != null && (jSONObject2 = companion.getJSONObject("CognitoIdentity")) != null && (this_$iv = jSONObject2.getJSONObject(configName)) != null) {
                void it;
                JSONObject bl = this_$iv;
                userPoolConfiguration = userPoolConfiguration2;
                boolean bl3 = false;
                identityPoolConfiguration = IdentityPoolConfiguration.Companion.fromJson((JSONObject)it).build();
                userPoolConfiguration2 = userPoolConfiguration;
            } else {
                identityPoolConfiguration = null;
            }
            if ((jSONObject = authConfig) != null && (jSONObject = jSONObject.optJSONObject("OAuth")) != null) {
                void it;
                this_$iv = jSONObject;
                IdentityPoolConfiguration identityPoolConfiguration2 = identityPoolConfiguration;
                userPoolConfiguration = userPoolConfiguration2;
                boolean bl = false;
                OauthConfiguration oauthConfiguration2 = OauthConfiguration.Companion.fromJson((JSONObject)it);
                userPoolConfiguration2 = userPoolConfiguration;
                identityPoolConfiguration = identityPoolConfiguration2;
                oauthConfiguration = oauthConfiguration2;
            } else {
                oauthConfiguration = null;
            }
            JSONObject jSONObject5 = authConfig;
            PasswordProtectionSettings passwordProtectionSettings = this.getPasswordProtectionSettings(authConfig);
            List list4 = verificationMechanisms;
            List list5 = usernameAttributes;
            List list6 = signUpAttributes;
            AuthFlowType authFlowType = this.getAuthenticationFlowType(jSONObject5 != null ? jSONObject5.optString("authenticationFlowType") : null);
            OauthConfiguration oauthConfiguration3 = oauthConfiguration;
            IdentityPoolConfiguration identityPoolConfiguration3 = identityPoolConfiguration;
            UserPoolConfiguration userPoolConfiguration3 = userPoolConfiguration2;
            return new AuthConfiguration(userPoolConfiguration3, identityPoolConfiguration3, oauthConfiguration3, authFlowType, list6, list5, list4, passwordProtectionSettings);
        }

        public static /* synthetic */ AuthConfiguration fromJson$default(Companion companion, JSONObject jSONObject, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = "Default";
            }
            return companion.fromJson(jSONObject, string);
        }

        @NotNull
        public final AuthConfiguration from(@NotNull AmplifyOutputsData amplifyOutputs) {
            Collection<VerificationMechanism> collection;
            AmplifyOutputsData.Auth.UserVerificationTypes it;
            Collection<UsernameAttribute> collection2;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            IdentityPoolConfiguration identityPoolConfiguration;
            OauthConfiguration oauthConfiguration;
            Intrinsics.checkNotNullParameter((Object)amplifyOutputs, (String)"amplifyOutputs");
            AmplifyOutputsData.Auth auth = amplifyOutputs.getAuth();
            if (auth == null) {
                throw new ConfigurationException("Missing Auth configuration", "Ensure the auth category is properly configured", null, 4, null);
            }
            AmplifyOutputsData.Auth auth2 = auth;
            AmplifyOutputsData.Auth.Oauth oauth = auth2.getOauth();
            if (oauth != null) {
                AmplifyOutputsData.Auth.Oauth it2 = oauth;
                boolean bl = false;
                oauthConfiguration = new OauthConfiguration(auth2.getUserPoolClientId(), null, it2.getDomain(), CollectionsKt.toSet((Iterable)it2.getScopes()), CollectionsKt.joinToString$default((Iterable)it2.getRedirectSignInUri(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null), CollectionsKt.joinToString$default((Iterable)it2.getRedirectSignOutUri(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            } else {
                oauthConfiguration = null;
            }
            OauthConfiguration oauth2 = oauthConfiguration;
            String string = auth2.getIdentityPoolId();
            if (string != null) {
                String it3 = string;
                boolean bl = false;
                identityPoolConfiguration = new IdentityPoolConfiguration(auth2.getAwsRegion(), it3);
            } else {
                identityPoolConfiguration = null;
            }
            IdentityPoolConfiguration identityPool = identityPoolConfiguration;
            Iterable iterable = auth2.getUsernameAttributes();
            List list = auth2.getStandardRequiredAttributes();
            AuthFlowType authFlowType = AuthFlowType.USER_SRP_AUTH;
            OauthConfiguration oauthConfiguration2 = oauth2;
            IdentityPoolConfiguration identityPoolConfiguration2 = identityPool;
            UserPoolConfiguration userPoolConfiguration = new UserPoolConfiguration(auth2.getAwsRegion(), null, auth2.getUserPoolId(), auth2.getUserPoolClientId(), null, null);
            boolean $i$f$map = false;
            void it3 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                AmplifyOutputsData.Auth.UsernameAttributes usernameAttributes = (AmplifyOutputsData.Auth.UsernameAttributes)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(Companion.toConfigType((AmplifyOutputsData.Auth.UsernameAttributes)it));
            }
            collection2 = (List)destination$iv$iv;
            $this$map$iv = auth2.getUserVerificationTypes();
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (AmplifyOutputsData.Auth.UserVerificationTypes)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.toConfigType(it));
            }
            collection = (List)destination$iv$iv;
            AmplifyOutputsData.Auth.PasswordPolicy passwordPolicy = auth2.getPasswordPolicy();
            PasswordProtectionSettings passwordProtectionSettings = passwordPolicy != null ? this.toConfigType(passwordPolicy) : null;
            Collection<VerificationMechanism> collection3 = collection;
            Collection<UsernameAttribute> collection4 = collection2;
            List list2 = list;
            AuthFlowType authFlowType2 = authFlowType;
            OauthConfiguration oauthConfiguration3 = oauthConfiguration2;
            IdentityPoolConfiguration identityPoolConfiguration3 = identityPoolConfiguration2;
            UserPoolConfiguration userPoolConfiguration2 = userPoolConfiguration;
            return new AuthConfiguration(userPoolConfiguration2, identityPoolConfiguration3, oauthConfiguration3, authFlowType2, list2, (List<? extends UsernameAttribute>)collection4, (List<? extends VerificationMechanism>)collection3, passwordProtectionSettings);
        }

        /*
         * Enabled aggressive block sorting
         */
        private final AuthFlowType getAuthenticationFlowType(String authType) {
            AuthFlowType authFlowType;
            CharSequence charSequence = authType;
            if (!(charSequence == null || charSequence.length() == 0)) {
                boolean bl;
                block3: {
                    AuthFlowType[] $this$any$iv = AuthFlowType.values();
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int i = 0; i < n; ++i) {
                        AuthFlowType element$iv;
                        AuthFlowType it = element$iv = $this$any$iv[i];
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.name(), (Object)authType)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
                if (bl) {
                    authFlowType = AuthFlowType.valueOf(authType);
                    return authFlowType;
                }
            }
            authFlowType = AuthFlowType.USER_SRP_AUTH;
            return authFlowType;
        }

        /*
         * WARNING - void declaration
         */
        private final PasswordProtectionSettings getPasswordProtectionSettings(JSONObject authConfig) {
            List list;
            JSONObject jSONObject = authConfig;
            Object object = jSONObject != null ? jSONObject.optJSONObject("passwordProtectionSettings") : null;
            if (object == null) {
                return null;
            }
            JSONObject passwordSettings = object;
            int passwordLength = passwordSettings.optInt("passwordPolicyMinLength");
            JSONArray jSONArray = passwordSettings.optJSONArray("passwordPolicyCharacters");
            if (jSONArray != null) {
                Companion companion = this;
                JSONArray $this$map$iv = jSONArray;
                boolean $i$f$map = false;
                int n = $this$map$iv.length();
                ArrayList<String> arrayList = new ArrayList<String>(n);
                int n2 = 0;
                while (n2 < n) {
                    void it;
                    void it$iv;
                    int n3;
                    int n4 = n3 = n2++;
                    ArrayList<String> arrayList2 = arrayList;
                    boolean bl = false;
                    void var17_18 = it$iv;
                    JSONArray $this$getPasswordProtectionSettings_u24lambda_u2411 = $this$map$iv;
                    boolean bl2 = false;
                    arrayList2.add($this$getPasswordProtectionSettings_u24lambda_u2411.getString((int)it));
                }
                list = arrayList;
            } else {
                list = CollectionsKt.emptyList();
            }
            List passwordRequirements = list;
            boolean bl = passwordRequirements.contains("REQUIRES_NUMBERS");
            boolean bl3 = passwordRequirements.contains("REQUIRES_SYMBOLS");
            boolean bl4 = passwordRequirements.contains("REQUIRES_LOWERCASE");
            boolean bl5 = passwordRequirements.contains("REQUIRES_UPPERCASE");
            return new PasswordProtectionSettings(passwordLength, bl, bl3, bl5, bl4);
        }

        private final JSONObject toGen1Json(PasswordProtectionSettings $this$toGen1Json) {
            JSONArray jSONArray;
            JSONObject jSONObject;
            JSONObject $this$toGen1Json_u24lambda_u2413 = jSONObject = new JSONObject();
            boolean bl = false;
            $this$toGen1Json_u24lambda_u2413.put("passwordPolicyMinLength", $this$toGen1Json.getLength());
            JSONArray $this$toGen1Json_u24lambda_u2413_u24lambda_u2412 = jSONArray = new JSONArray();
            boolean bl2 = false;
            if ($this$toGen1Json.getRequiresLower()) {
                $this$toGen1Json_u24lambda_u2413_u24lambda_u2412.put((Object)"REQUIRES_LOWERCASE");
            }
            if ($this$toGen1Json.getRequiresUpper()) {
                $this$toGen1Json_u24lambda_u2413_u24lambda_u2412.put((Object)"REQUIRES_UPPERCASE");
            }
            if ($this$toGen1Json.getRequiresNumber()) {
                $this$toGen1Json_u24lambda_u2413_u24lambda_u2412.put((Object)"REQUIRES_NUMBERS");
            }
            if ($this$toGen1Json.getRequiresSpecial()) {
                $this$toGen1Json_u24lambda_u2413_u24lambda_u2412.put((Object)"REQUIRES_SYMBOLS");
            }
            JSONArray characters = jSONArray;
            $this$toGen1Json_u24lambda_u2413.put("passwordPolicyCharacters", (Object)characters);
            return jSONObject;
        }

        /*
         * WARNING - void declaration
         */
        private final <T> List<T> map(JSONArray $this$map, Function2<? super JSONArray, ? super Integer, ? extends T> func) {
            boolean $i$f$map = false;
            int n = $this$map.length();
            ArrayList<Object> arrayList = new ArrayList<Object>(n);
            int n2 = 0;
            while (n2 < n) {
                void it;
                int n3;
                int n4 = n3 = n2++;
                ArrayList<Object> arrayList2 = arrayList;
                boolean bl = false;
                arrayList2.add(func.invoke((Object)$this$map, (Object)((int)it)));
            }
            return arrayList;
        }

        private final UsernameAttribute toConfigType(AmplifyOutputsData.Auth.UsernameAttributes $this$toConfigType) {
            UsernameAttribute usernameAttribute;
            switch (WhenMappings.$EnumSwitchMapping$0[$this$toConfigType.ordinal()]) {
                case 1: {
                    usernameAttribute = UsernameAttribute.Email;
                    break;
                }
                case 2: {
                    usernameAttribute = UsernameAttribute.PhoneNumber;
                    break;
                }
                case 3: {
                    usernameAttribute = UsernameAttribute.Username;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return usernameAttribute;
        }

        private final String toGen1Json(UsernameAttribute $this$toGen1Json) {
            String string;
            switch (WhenMappings.$EnumSwitchMapping$1[$this$toGen1Json.ordinal()]) {
                case 1: {
                    string = "USERNAME";
                    break;
                }
                case 2: {
                    string = "EMAIL";
                    break;
                }
                case 3: {
                    string = "PHONE_NUMBER";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        private final VerificationMechanism toConfigType(AmplifyOutputsData.Auth.UserVerificationTypes $this$toConfigType) {
            VerificationMechanism verificationMechanism;
            switch (WhenMappings.$EnumSwitchMapping$2[$this$toConfigType.ordinal()]) {
                case 1: {
                    verificationMechanism = VerificationMechanism.Email;
                    break;
                }
                case 2: {
                    verificationMechanism = VerificationMechanism.PhoneNumber;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return verificationMechanism;
        }

        private final String toGen1Json(VerificationMechanism $this$toGen1Json) {
            String string;
            switch (WhenMappings.$EnumSwitchMapping$3[$this$toGen1Json.ordinal()]) {
                case 1: {
                    string = "EMAIL";
                    break;
                }
                case 2: {
                    string = "PHONE_NUMBER";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        private final PasswordProtectionSettings toConfigType(AmplifyOutputsData.Auth.PasswordPolicy $this$toConfigType) {
            Integer n = $this$toConfigType.getMinLength();
            Boolean bl = $this$toConfigType.getRequireNumbers();
            Boolean bl2 = $this$toConfigType.getRequireSymbols();
            Boolean bl3 = $this$toConfigType.getRequireUppercase();
            Boolean bl4 = $this$toConfigType.getRequireLowercase();
            return new PasswordProtectionSettings(n != null ? n : 6, bl != null ? bl : false, bl2 != null ? bl2 : false, bl3 != null ? bl3 : false, bl4 != null ? bl4 : false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;
            public static final /* synthetic */ int[] $EnumSwitchMapping$2;
            public static final /* synthetic */ int[] $EnumSwitchMapping$3;

            static {
                int[] nArray = new int[AmplifyOutputsData.Auth.UsernameAttributes.values().length];
                try {
                    nArray[AmplifyOutputsData.Auth.UsernameAttributes.Email.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AmplifyOutputsData.Auth.UsernameAttributes.PhoneNumber.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AmplifyOutputsData.Auth.UsernameAttributes.Username.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[UsernameAttribute.values().length];
                try {
                    nArray[UsernameAttribute.Username.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[UsernameAttribute.Email.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[UsernameAttribute.PhoneNumber.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
                nArray = new int[AmplifyOutputsData.Auth.UserVerificationTypes.values().length];
                try {
                    nArray[AmplifyOutputsData.Auth.UserVerificationTypes.Email.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AmplifyOutputsData.Auth.UserVerificationTypes.PhoneNumber.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$2 = nArray;
                nArray = new int[VerificationMechanism.values().length];
                try {
                    nArray[VerificationMechanism.Email.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[VerificationMechanism.PhoneNumber.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$3 = nArray;
            }
        }
    }
}

