/*
 * Decompiled with CFR 0.152.
 */
package com.amplifyframework.auth.cognito;

import android.content.Context;
import com.amplifyframework.auth.cognito.AuthConfiguration;
import com.amplifyframework.auth.cognito.CredentialStoreEnvironment;
import com.amplifyframework.auth.cognito.CredentialStoreStateMachine;
import com.amplifyframework.auth.cognito.StoreClientBehavior;
import com.amplifyframework.auth.cognito.data.AWSCognitoAuthCredentialStore;
import com.amplifyframework.auth.cognito.data.AWSCognitoLegacyCredentialStore;
import com.amplifyframework.logging.Logger;
import com.amplifyframework.statemachine.StateChangeListenerToken;
import com.amplifyframework.statemachine.codegen.data.AmplifyCredential;
import com.amplifyframework.statemachine.codegen.data.CredentialType;
import com.amplifyframework.statemachine.codegen.events.CredentialStoreEvent;
import com.amplifyframework.statemachine.codegen.states.CredentialStoreState;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.SafeContinuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0001!B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0019\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002JE\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0018\u0010\u0016\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u0018\u0012\u0004\u0012\u00020\u000e0\u00172\u0016\u0010\u001a\u001a\u0012\u0012\b\u0012\u00060\u001bj\u0002`\u001c\u0012\u0004\u0012\u00020\u000e0\u0017H\u0002\u00f8\u0001\u0000J\u0019\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0010H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J!\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u0019H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\""}, d2={"Lcom/amplifyframework/auth/cognito/CredentialStoreClient;", "Lcom/amplifyframework/auth/cognito/StoreClientBehavior;", "configuration", "Lcom/amplifyframework/auth/cognito/AuthConfiguration;", "context", "Landroid/content/Context;", "logger", "Lcom/amplifyframework/logging/Logger;", "(Lcom/amplifyframework/auth/cognito/AuthConfiguration;Landroid/content/Context;Lcom/amplifyframework/logging/Logger;)V", "credentialStoreStateMachine", "Lcom/amplifyframework/auth/cognito/CredentialStoreStateMachine;", "getLogger", "()Lcom/amplifyframework/logging/Logger;", "clearCredentials", "", "credentialType", "Lcom/amplifyframework/statemachine/codegen/data/CredentialType;", "(Lcom/amplifyframework/statemachine/codegen/data/CredentialType;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createCredentialStoreStateMachine", "listenForResult", "event", "Lcom/amplifyframework/statemachine/codegen/events/CredentialStoreEvent;", "onSuccess", "Lkotlin/Function1;", "Lkotlin/Result;", "Lcom/amplifyframework/statemachine/codegen/data/AmplifyCredential;", "onError", "Ljava/lang/Exception;", "Lkotlin/Exception;", "loadCredentials", "storeCredentials", "amplifyCredential", "(Lcom/amplifyframework/statemachine/codegen/data/CredentialType;Lcom/amplifyframework/statemachine/codegen/data/AmplifyCredential;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "OneShotCredentialStoreStateListener", "aws-auth-cognito_release"})
public final class CredentialStoreClient
implements StoreClientBehavior {
    @NotNull
    private final Logger logger;
    @NotNull
    private final CredentialStoreStateMachine credentialStoreStateMachine;

    public CredentialStoreClient(@NotNull AuthConfiguration configuration, @NotNull Context context, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        this.credentialStoreStateMachine = this.createCredentialStoreStateMachine(configuration, context);
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    private final CredentialStoreStateMachine createCredentialStoreStateMachine(AuthConfiguration configuration, Context context) {
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getApplicationContext(...)");
        AWSCognitoAuthCredentialStore awsCognitoAuthCredentialStore = new AWSCognitoAuthCredentialStore(context2, configuration, false, null, 12, null);
        Context context3 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"getApplicationContext(...)");
        AWSCognitoLegacyCredentialStore legacyCredentialStore = new AWSCognitoLegacyCredentialStore(context3, configuration, null, 4, null);
        CredentialStoreEnvironment credentialStoreEnvironment = new CredentialStoreEnvironment(awsCognitoAuthCredentialStore, legacyCredentialStore, this.logger);
        return new CredentialStoreStateMachine(credentialStoreEnvironment);
    }

    private final void listenForResult(CredentialStoreEvent event, Function1<? super Result<? extends AmplifyCredential>, Unit> onSuccess, Function1<? super Exception, Unit> onError) {
        StateChangeListenerToken token = new StateChangeListenerToken();
        OneShotCredentialStoreStateListener credentialStoreStateListener2 = new OneShotCredentialStoreStateListener((Function1<? super Result<? extends AmplifyCredential>, Unit>)((Function1)new Function1<Result<? extends AmplifyCredential>, Unit>(this, token, onSuccess){
            final /* synthetic */ CredentialStoreClient this$0;
            final /* synthetic */ StateChangeListenerToken $token;
            final /* synthetic */ Function1<Result<? extends AmplifyCredential>, Unit> $onSuccess;
            {
                this.this$0 = $receiver;
                this.$token = $token;
                this.$onSuccess = $onSuccess;
                super(1);
            }

            public final void invoke(@NotNull Object it) {
                CredentialStoreClient.access$getCredentialStoreStateMachine$p(this.this$0).cancel(this.$token);
                this.$onSuccess.invoke((Object)Result.box-impl((Object)it));
            }
        }), (Function1<? super Exception, Unit>)((Function1)new Function1<Exception, Unit>(this, token, onError){
            final /* synthetic */ CredentialStoreClient this$0;
            final /* synthetic */ StateChangeListenerToken $token;
            final /* synthetic */ Function1<Exception, Unit> $onError;
            {
                this.this$0 = $receiver;
                this.$token = $token;
                this.$onError = $onError;
                super(1);
            }

            public final void invoke(@NotNull Exception it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CredentialStoreClient.access$getCredentialStoreStateMachine$p(this.this$0).cancel(this.$token);
                this.$onError.invoke((Object)it);
            }
        }), this.logger);
        this.credentialStoreStateMachine.listen(token, (Function1)new Function1<CredentialStoreState, Unit>((Object)credentialStoreStateListener2){

            public final void invoke(@NotNull CredentialStoreState p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((OneShotCredentialStoreStateListener)this.receiver).listen(p0);
            }
        }, (Function0<Unit>)((Function0)new Function0<Unit>(this, event){
            final /* synthetic */ CredentialStoreClient this$0;
            final /* synthetic */ CredentialStoreEvent $event;
            {
                this.this$0 = $receiver;
                this.$event = $event;
                super(0);
            }

            public final void invoke() {
                CredentialStoreClient.access$getCredentialStoreStateMachine$p(this.this$0).send(this.$event);
            }
        }));
    }

    @Override
    @Nullable
    public Object loadCredentials(@NotNull CredentialType credentialType, @NotNull Continuation<? super AmplifyCredential> $completion) {
        Continuation<? super AmplifyCredential> continuation = $completion;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation continuation2 = (Continuation)safeContinuation;
        boolean bl = false;
        this.listenForResult(new CredentialStoreEvent(new CredentialStoreEvent.EventType.LoadCredentialStore(credentialType), null, 2, null), (Function1<? super Result<? extends AmplifyCredential>, Unit>)((Function1)new Function1<Result<? extends AmplifyCredential>, Unit>((Continuation<? super AmplifyCredential>)continuation2){
            final /* synthetic */ Continuation<AmplifyCredential> $continuation;
            {
                this.$continuation = $continuation;
                super(1);
            }

            public final void invoke(@NotNull Object it) {
                this.$continuation.resumeWith(it);
            }
        }), (Function1<? super Exception, Unit>)((Function1)new Function1<Exception, Unit>((Continuation<? super AmplifyCredential>)continuation2){
            final /* synthetic */ Continuation<AmplifyCredential> $continuation;
            {
                this.$continuation = $continuation;
                super(1);
            }

            public final void invoke(@NotNull Exception it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$continuation.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)it)));
            }
        }));
        Object object = safeContinuation.getOrThrow();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    @Override
    @Nullable
    public Object storeCredentials(@NotNull CredentialType credentialType, @NotNull AmplifyCredential amplifyCredential, @NotNull Continuation<? super Unit> $completion) {
        Continuation<? super Unit> continuation = $completion;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation continuation2 = (Continuation)safeContinuation;
        boolean bl = false;
        this.listenForResult(new CredentialStoreEvent(new CredentialStoreEvent.EventType.StoreCredentials(credentialType, amplifyCredential), null, 2, null), (Function1<? super Result<? extends AmplifyCredential>, Unit>)((Function1)new Function1<Result<? extends AmplifyCredential>, Unit>((Continuation<? super Unit>)continuation2){
            final /* synthetic */ Continuation<Unit> $continuation;
            {
                this.$continuation = $continuation;
                super(1);
            }

            public final void invoke(@NotNull Object it) {
                this.$continuation.resumeWith(Result.constructor-impl((Object)Unit.INSTANCE));
            }
        }), (Function1<? super Exception, Unit>)((Function1)new Function1<Exception, Unit>((Continuation<? super Unit>)continuation2){
            final /* synthetic */ Continuation<Unit> $continuation;
            {
                this.$continuation = $continuation;
                super(1);
            }

            public final void invoke(@NotNull Exception it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$continuation.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)it)));
            }
        }));
        Object object = safeContinuation.getOrThrow();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object clearCredentials(@NotNull CredentialType credentialType, @NotNull Continuation<? super Unit> $completion) {
        Continuation<? super Unit> continuation = $completion;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation continuation2 = (Continuation)safeContinuation;
        boolean bl = false;
        this.listenForResult(new CredentialStoreEvent(new CredentialStoreEvent.EventType.ClearCredentialStore(credentialType), null, 2, null), (Function1<? super Result<? extends AmplifyCredential>, Unit>)((Function1)new Function1<Result<? extends AmplifyCredential>, Unit>((Continuation<? super Unit>)continuation2){
            final /* synthetic */ Continuation<Unit> $continuation;
            {
                this.$continuation = $continuation;
                super(1);
            }

            public final void invoke(@NotNull Object it) {
                this.$continuation.resumeWith(Result.constructor-impl((Object)Unit.INSTANCE));
            }
        }), (Function1<? super Exception, Unit>)((Function1)new Function1<Exception, Unit>((Continuation<? super Unit>)continuation2){
            final /* synthetic */ Continuation<Unit> $continuation;
            {
                this.$continuation = $continuation;
                super(1);
            }

            public final void invoke(@NotNull Exception it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$continuation.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)it)));
            }
        }));
        Object object = safeContinuation.getOrThrow();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ CredentialStoreStateMachine access$getCredentialStoreStateMachine$p(CredentialStoreClient $this) {
        return $this.credentialStoreStateMachine;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001BB\u0012\u0018\u0010\u0002\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0016\u0010\u0007\u001a\u0012\u0012\b\u0012\u00060\bj\u0002`\t\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018R\u0016\u0010\r\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R!\u0010\u0007\u001a\u0012\u0012\b\u0012\u00060\bj\u0002`\t\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R&\u0010\u0002\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u0003\u00f8\u0001\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0019"}, d2={"Lcom/amplifyframework/auth/cognito/CredentialStoreClient$OneShotCredentialStoreStateListener;", "", "onSuccess", "Lkotlin/Function1;", "Lkotlin/Result;", "Lcom/amplifyframework/statemachine/codegen/data/AmplifyCredential;", "", "onError", "Ljava/lang/Exception;", "Lkotlin/Exception;", "logger", "Lcom/amplifyframework/logging/Logger;", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lcom/amplifyframework/logging/Logger;)V", "capturedError", "capturedSuccess", "isActive", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getLogger", "()Lcom/amplifyframework/logging/Logger;", "getOnError", "()Lkotlin/jvm/functions/Function1;", "getOnSuccess", "listen", "storeState", "Lcom/amplifyframework/statemachine/codegen/states/CredentialStoreState;", "aws-auth-cognito_release"})
    public static final class OneShotCredentialStoreStateListener {
        @NotNull
        private final Function1<Result<? extends AmplifyCredential>, Unit> onSuccess;
        @NotNull
        private final Function1<Exception, Unit> onError;
        @NotNull
        private final Logger logger;
        @Nullable
        private Result<? extends AmplifyCredential> capturedSuccess;
        @Nullable
        private Exception capturedError;
        @NotNull
        private final AtomicBoolean isActive;

        public OneShotCredentialStoreStateListener(@NotNull Function1<? super Result<? extends AmplifyCredential>, Unit> onSuccess, @NotNull Function1<? super Exception, Unit> onError, @NotNull Logger logger) {
            Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
            Intrinsics.checkNotNullParameter(onError, (String)"onError");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            this.onSuccess = onSuccess;
            this.onError = onError;
            this.logger = logger;
            this.isActive = new AtomicBoolean(true);
        }

        @NotNull
        public final Function1<Result<? extends AmplifyCredential>, Unit> getOnSuccess() {
            return this.onSuccess;
        }

        @NotNull
        public final Function1<Exception, Unit> getOnError() {
            return this.onError;
        }

        @NotNull
        public final Logger getLogger() {
            return this.logger;
        }

        public final void listen(@NotNull CredentialStoreState storeState) {
            block1: {
                Exception error;
                block3: {
                    CredentialStoreState credentialStoreState;
                    block2: {
                        block0: {
                            Intrinsics.checkNotNullParameter((Object)storeState, (String)"storeState");
                            this.logger.verbose("Credential Store State Change: " + storeState);
                            credentialStoreState = storeState;
                            if (!(credentialStoreState instanceof CredentialStoreState.Success)) break block0;
                            this.capturedSuccess = Result.box-impl((Object)Result.constructor-impl((Object)((CredentialStoreState.Success)storeState).getStoredCredentials()));
                            break block1;
                        }
                        if (!(credentialStoreState instanceof CredentialStoreState.Error)) break block2;
                        this.capturedError = ((CredentialStoreState.Error)storeState).getError();
                        break block1;
                    }
                    if (!(credentialStoreState instanceof CredentialStoreState.Idle)) break block1;
                    Result<? extends AmplifyCredential> success = this.capturedSuccess;
                    error = this.capturedError;
                    if (success == null && error == null || !this.isActive.getAndSet(false)) break block1;
                    if (success == null) break block3;
                    this.onSuccess.invoke(success);
                    break block1;
                }
                if (error == null) break block1;
                this.onError.invoke((Object)error);
            }
        }
    }
}

