/*
 * Decompiled with CFR 0.152.
 */
package com.amplifyframework.auth.cognito;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import androidx.browser.customtabs.CustomTabsClient;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.browser.customtabs.CustomTabsServiceConnection;
import androidx.browser.customtabs.CustomTabsSession;
import com.amplifyframework.auth.cognito.activities.CustomTabsManagerActivity;
import com.amplifyframework.auth.cognito.exceptions.service.CodeValidationException;
import com.amplifyframework.auth.cognito.helpers.BrowserHelper;
import com.amplifyframework.auth.cognito.helpers.CodegenExtensionsKt;
import com.amplifyframework.auth.cognito.helpers.HostedUIHttpHelper;
import com.amplifyframework.auth.cognito.helpers.PkceHelper;
import com.amplifyframework.logging.Logger;
import com.amplifyframework.statemachine.codegen.data.CognitoUserPoolTokens;
import com.amplifyframework.statemachine.codegen.data.HostedUIOptions;
import com.amplifyframework.statemachine.codegen.data.OauthConfiguration;
import java.net.URL;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 -2\u00020\u0001:\u0001-B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\r\u0010\u001a\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u001bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0013J&\u0010\u001f\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u00132\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010\fH\u0002J\u000e\u0010$\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010%\u001a\u00020 2\b\u0010&\u001a\u0004\u0018\u00010\fJ\u0018\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020)2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010*\u001a\u00020 2\u0006\u0010(\u001a\u00020)H\u0016J\u0018\u0010+\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\fH\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/amplifyframework/auth/cognito/HostedUIClient;", "Landroidx/browser/customtabs/CustomTabsServiceConnection;", "context", "Landroid/content/Context;", "configuration", "Lcom/amplifyframework/statemachine/codegen/data/OauthConfiguration;", "logger", "Lcom/amplifyframework/logging/Logger;", "(Landroid/content/Context;Lcom/amplifyframework/statemachine/codegen/data/OauthConfiguration;Lcom/amplifyframework/logging/Logger;)V", "client", "Landroidx/browser/customtabs/CustomTabsClient;", "defaultCustomTabsPackage", "", "proofKey", "proofKeyHash", "session", "Landroidx/browser/customtabs/CustomTabsSession;", "state", "createAuthorizeUri", "Landroid/net/Uri;", "hostedUIOptions", "Lcom/amplifyframework/statemachine/codegen/data/HostedUIOptions;", "createFetchTokenHeaders", "", "createFetchTokenUrl", "Ljava/net/URL;", "createSignOutUri", "createSignOutUri$aws_auth_cognito_release", "fetchToken", "Lcom/amplifyframework/statemachine/codegen/data/CognitoUserPoolTokens;", "uri", "launchCustomTabs", "", "activity", "Landroid/app/Activity;", "customBrowserPackage", "launchCustomTabsSignIn", "launchCustomTabsSignOut", "browserPackage", "onCustomTabsServiceConnected", "name", "Landroid/content/ComponentName;", "onServiceDisconnected", "preWarmCustomTabs", "packageName", "Companion", "aws-auth-cognito_release"})
@SuppressLint(value={"QueryPermissionsNeeded"})
@SourceDebugExtension(value={"SMAP\nHostedUIClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HostedUIClient.kt\ncom/amplifyframework/auth/cognito/HostedUIClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,221:1\n1#2:222\n*E\n"})
public final class HostedUIClient
extends CustomTabsServiceConnection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final OauthConfiguration configuration;
    @NotNull
    private final Logger logger;
    @NotNull
    private final String proofKey;
    @NotNull
    private final String proofKeyHash;
    @NotNull
    private final String state;
    @Nullable
    private CustomTabsClient client;
    @Nullable
    private CustomTabsSession session;
    @Nullable
    private final String defaultCustomTabsPackage;
    public static final int CUSTOM_TABS_ACTIVITY_CODE = 49281;

    /*
     * WARNING - void declaration
     */
    private HostedUIClient(Context context, OauthConfiguration configuration, Logger logger) {
        String string;
        this.context = context;
        this.configuration = configuration;
        this.logger = logger;
        this.proofKey = PkceHelper.INSTANCE.generateRandom();
        this.proofKeyHash = PkceHelper.INSTANCE.generateHash(this.proofKey);
        this.state = PkceHelper.INSTANCE.generateRandom();
        HostedUIClient hostedUIClient = this;
        String string2 = BrowserHelper.INSTANCE.getDefaultCustomTabPackage(this.context);
        if (string2 != null) {
            void it;
            String string3;
            String string4 = string3 = string2;
            HostedUIClient hostedUIClient2 = hostedUIClient;
            boolean bl = false;
            this.preWarmCustomTabs(this.context, (String)it);
            hostedUIClient = hostedUIClient2;
            string = string3;
        } else {
            string = null;
        }
        hostedUIClient.defaultCustomTabsPackage = string;
    }

    public final void launchCustomTabsSignIn(@NotNull HostedUIOptions hostedUIOptions) throws RuntimeException {
        Intrinsics.checkNotNullParameter((Object)hostedUIOptions, (String)"hostedUIOptions");
        this.launchCustomTabs(this.createAuthorizeUri(hostedUIOptions), hostedUIOptions.getCallingActivity(), hostedUIOptions.getBrowserPackage());
    }

    public final void launchCustomTabsSignOut(@Nullable String browserPackage) throws RuntimeException {
        HostedUIClient.launchCustomTabs$default(this, this.createSignOutUri$aws_auth_cognito_release(), null, browserPackage, 2, null);
    }

    private final void launchCustomTabs(Uri uri, Activity activity, String customBrowserPackage) {
        CustomTabsIntent customTabsIntent;
        if (!BrowserHelper.INSTANCE.isBrowserInstalled(this.context)) {
            throw new RuntimeException("No browsers installed");
        }
        String string = customBrowserPackage;
        if (string == null) {
            string = this.defaultCustomTabsPackage;
        }
        String browserPackage = string;
        CustomTabsIntent $this$launchCustomTabs_u24lambda_u242 = customTabsIntent = new CustomTabsIntent.Builder(this.session).build();
        boolean bl = false;
        String string2 = browserPackage;
        if (string2 != null) {
            String it = string2;
            boolean bl2 = false;
            $this$launchCustomTabs_u24lambda_u242.intent.setPackage(it);
        }
        $this$launchCustomTabs_u24lambda_u242.intent.setData(uri);
        CustomTabsIntent customTabsIntent2 = customTabsIntent;
        Intrinsics.checkNotNullExpressionValue((Object)customTabsIntent2, (String)"apply(...)");
        CustomTabsIntent customTabsIntent3 = customTabsIntent2;
        Intent customTabIntent = CustomTabsManagerActivity.Companion.createStartIntent(this.context, customTabsIntent3.intent);
        if (activity != null) {
            activity.startActivityForResult(customTabIntent, 49281);
        } else {
            customTabIntent.addFlags(0x10000000);
            this.context.startActivity(customTabIntent);
        }
    }

    static /* synthetic */ void launchCustomTabs$default(HostedUIClient hostedUIClient, Uri uri, Activity activity, String string, int n, Object object) {
        if ((n & 2) != 0) {
            activity = null;
        }
        hostedUIClient.launchCustomTabs(uri, activity, string);
    }

    @NotNull
    public final CognitoUserPoolTokens fetchToken(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String errorState = uri.getQueryParameter("error");
        String callbackState = uri.getQueryParameter("state");
        String code = uri.getQueryParameter("code");
        if (errorState != null) {
            String errorDescription;
            String string = uri.getQueryParameter("error_description");
            String string2 = errorDescription = string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null;
            String message = (string2 != null ? ((CharSequence)string2).length() > 0 : false) ? errorState + ": " + errorDescription : errorState;
            throw new CodeValidationException(message);
        }
        if (callbackState == null || code == null) {
            throw new CodeValidationException(null, 1, null);
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"grant_type", (Object)"authorization_code"), TuplesKt.to((Object)"client_id", (Object)this.configuration.getAppClient()), TuplesKt.to((Object)"redirect_uri", (Object)this.configuration.getSignInRedirectURI()), TuplesKt.to((Object)"code_verifier", (Object)this.proofKey), TuplesKt.to((Object)"code", (Object)code)};
        Map body = MapsKt.mapOf((Pair[])pairArray);
        return HostedUIHttpHelper.INSTANCE.fetchTokens(this.createFetchTokenUrl(), this.createFetchTokenHeaders(), body);
    }

    private final Uri createAuthorizeUri(HostedUIOptions hostedUIOptions) {
        List scopes;
        Object object;
        List list;
        Object object2;
        Object object3;
        Uri.Builder builder = new Uri.Builder().scheme("https").authority(this.configuration.getDomain()).appendPath("oauth2").appendPath("authorize").appendQueryParameter("client_id", this.configuration.getAppClient()).appendQueryParameter("redirect_uri", this.configuration.getSignInRedirectURI()).appendQueryParameter("response_type", "code").appendQueryParameter("code_challenge", this.proofKeyHash).appendQueryParameter("code_challenge_method", "S256").appendQueryParameter("state", this.state);
        Object object4 = hostedUIOptions.getProviderInfo().getAuthProvider();
        if (object4 != null && (object4 = CodegenExtensionsKt.getUserPoolProviderName(object4)) != null) {
            Object object5;
            Object it = object5 = object4;
            boolean bl = false;
            object4 = ((CharSequence)it).length() > 0 ? object5 : null;
            if (object4 != null) {
                it = object4;
                boolean bl2 = false;
                builder.appendQueryParameter("identity_provider", (String)it);
            }
        }
        if ((object3 = hostedUIOptions.getProviderInfo().getIdpIdentifier()) != null) {
            Object it = object2 = object3;
            boolean bl = false;
            object3 = ((CharSequence)it).length() > 0 ? object2 : null;
            if (object3 != null) {
                it = object3;
                boolean bl3 = false;
                builder.appendQueryParameter("idp_identifier", (String)it);
            }
        }
        List<String> list2 = hostedUIOptions.getScopes();
        if (list2 != null) {
            Object object6;
            object2 = list2;
            if (object2.isEmpty()) {
                boolean bl = false;
                object6 = CollectionsKt.toList((Iterable)this.configuration.getScopes());
            } else {
                object6 = object2;
            }
            list = (List)object6;
        } else {
            list = null;
        }
        if ((object = (scopes = list)) != null && (object = CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)) != null) {
            Object it = object;
            boolean bl = false;
            builder.appendQueryParameter("scope", (String)it);
        }
        Uri uri = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"build(...)");
        return uri;
    }

    private final URL createFetchTokenUrl() {
        return new URL(new Uri.Builder().scheme("https").authority(this.configuration.getDomain()).appendPath("oauth2").appendPath("token").build().toString());
    }

    private final Map<String, String> createFetchTokenHeaders() {
        Object object = new Pair[]{TuplesKt.to((Object)"Content-Type", (Object)"application/x-www-form-urlencoded")};
        Object $this$createFetchTokenHeaders_u24lambda_u249 = object = MapsKt.mutableMapOf((Pair[])object);
        boolean bl = false;
        if (this.configuration.getAppSecret() != null) {
            $this$createFetchTokenHeaders_u24lambda_u249.put("Authorization", "Basic " + PkceHelper.INSTANCE.encodeBase64(this.configuration.getAppClient() + ":" + this.configuration.getAppSecret()));
        }
        return object;
    }

    @NotNull
    public final Uri createSignOutUri$aws_auth_cognito_release() {
        Uri uri = new Uri.Builder().scheme("https").authority(this.configuration.getDomain()).appendPath("logout").appendQueryParameter("client_id", this.configuration.getAppClient()).appendQueryParameter("logout_uri", this.configuration.getSignOutRedirectURI()).build();
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"build(...)");
        return uri;
    }

    public void onCustomTabsServiceConnected(@NotNull ComponentName name, @NotNull CustomTabsClient client) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
        client.warmup(0L);
        this.session = client.newSession(null);
    }

    public void onServiceDisconnected(@NotNull ComponentName name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.client = null;
    }

    private final void preWarmCustomTabs(Context context, String packageName) {
        CustomTabsClient.bindCustomTabsService((Context)context, (String)packageName, (CustomTabsServiceConnection)this);
    }

    public /* synthetic */ HostedUIClient(Context context, OauthConfiguration configuration, Logger logger, DefaultConstructorMarker $constructor_marker) {
        this(context, configuration, logger);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/amplifyframework/auth/cognito/HostedUIClient$Companion;", "", "()V", "CUSTOM_TABS_ACTIVITY_CODE", "", "create", "Lcom/amplifyframework/auth/cognito/HostedUIClient;", "context", "Landroid/content/Context;", "configuration", "Lcom/amplifyframework/statemachine/codegen/data/OauthConfiguration;", "logger", "Lcom/amplifyframework/logging/Logger;", "aws-auth-cognito_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final HostedUIClient create(@NotNull Context context, @Nullable OauthConfiguration configuration, @NotNull Logger logger) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            return configuration != null ? new HostedUIClient(context, configuration, logger, null) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

