/*
 * Decompiled with CFR 0.152.
 */
package com.amplifyframework.auth.cognito.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import com.amplifyframework.core.Amplify;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010\u000b\u001a\u00020\bH\u0002J\b\u0010\f\u001a\u00020\bH\u0002J\u0012\u0010\r\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\nH\u0014J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0004H\u0014J\b\u0010\u0011\u001a\u00020\bH\u0014J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\nH\u0014R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/amplifyframework/auth/cognito/activities/CustomTabsManagerActivity;", "Landroid/app/Activity;", "()V", "customTabsIntent", "Landroid/content/Intent;", "customTabsLaunched", "", "extractState", "", "state", "Landroid/os/Bundle;", "handleAuthorizationCanceled", "handleAuthorizationComplete", "onCreate", "savedInstanceState", "onNewIntent", "intent", "onResume", "onSaveInstanceState", "outState", "Companion", "aws-auth-cognito_release"})
public final class CustomTabsManagerActivity
extends Activity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean customTabsLaunched;
    @Nullable
    private Intent customTabsIntent;
    @NotNull
    private static final String TAG = "AuthClient";
    @NotNull
    public static final String CUSTOM_TABS_LAUNCHED_KEY = "customTabsLaunched";
    @NotNull
    public static final String CUSTOM_TABS_INTENT_KEY = "customTabsIntent";

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState == null) {
            this.extractState(this.getIntent().getExtras());
        } else {
            this.extractState(savedInstanceState);
        }
    }

    protected void onResume() {
        super.onResume();
        if (!this.customTabsLaunched) {
            this.startActivity(this.customTabsIntent);
            this.customTabsLaunched = true;
            return;
        }
        if (this.getIntent().getData() != null) {
            this.handleAuthorizationComplete();
        } else {
            this.handleAuthorizationCanceled();
        }
        this.finish();
    }

    protected void onNewIntent(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        super.onNewIntent(intent);
        this.setIntent(intent);
    }

    protected void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
        super.onSaveInstanceState(outState);
        outState.putBoolean(CUSTOM_TABS_LAUNCHED_KEY, this.customTabsLaunched);
        outState.putParcelable(CUSTOM_TABS_INTENT_KEY, (Parcelable)this.customTabsIntent);
    }

    private final void handleAuthorizationComplete() {
        Log.d((String)TAG, (String)"Authorization flow completed successfully");
        this.setResult(-1, this.getIntent());
    }

    private final void handleAuthorizationCanceled() {
        Log.d((String)TAG, (String)"Authorization flow canceled by user");
        this.setResult(0);
        Amplify.Auth.handleWebUISignInResponse(null);
    }

    private final void extractState(Bundle state) {
        if (state == null) {
            Log.d((String)TAG, (String)"CustomTabsManagerActivity was created with a null state.");
            this.finish();
            return;
        }
        this.customTabsIntent = (Intent)state.getParcelable(CUSTOM_TABS_INTENT_KEY);
        this.customTabsLaunched = state.getBoolean(CUSTOM_TABS_LAUNCHED_KEY, false);
    }

    @JvmStatic
    @NotNull
    public static final Intent createResponseHandlingIntent(@NotNull Context context, @Nullable Uri responseUri) {
        return Companion.createResponseHandlingIntent(context, responseUri);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/amplifyframework/auth/cognito/activities/CustomTabsManagerActivity$Companion;", "", "()V", "CUSTOM_TABS_INTENT_KEY", "", "CUSTOM_TABS_LAUNCHED_KEY", "TAG", "createBaseIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "createResponseHandlingIntent", "responseUri", "Landroid/net/Uri;", "createStartIntent", "customTabsIntent", "aws-auth-cognito_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Intent createStartIntent(@NotNull Context context, @Nullable Intent customTabsIntent) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intent intent = this.createBaseIntent(context);
            intent.putExtra(CustomTabsManagerActivity.CUSTOM_TABS_INTENT_KEY, (Parcelable)customTabsIntent);
            return intent;
        }

        @JvmStatic
        @NotNull
        public final Intent createResponseHandlingIntent(@NotNull Context context, @Nullable Uri responseUri) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intent intent = this.createBaseIntent(context);
            intent.setData(responseUri);
            intent.addFlags(0x24000000);
            return intent;
        }

        private final Intent createBaseIntent(Context context) {
            return new Intent(context, CustomTabsManagerActivity.class);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

