/*
 * Decompiled with CFR 0.152.
 */
package com.amplifyframework.auth.cognito.asf;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageManager;
import android.util.Log;
import com.amplifyframework.auth.cognito.asf.DataCollector;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\n\u001a\n \u000b*\u0004\u0018\u00010\u00050\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0003\u00a8\u0006\r"}, d2={"Lcom/amplifyframework/auth/cognito/asf/ApplicationDataCollector;", "Lcom/amplifyframework/auth/cognito/asf/DataCollector;", "()V", "collect", "", "", "context", "Landroid/content/Context;", "getAppName", "getAppTargetSdk", "getAppVersion", "kotlin.jvm.PlatformType", "Companion", "aws-auth-cognito_release"})
public final class ApplicationDataCollector
implements DataCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final String TAG = ApplicationDataCollector.class.getSimpleName();
    private static final int ALL_FLAGS_OFF = 0;
    @NotNull
    public static final String APP_NAME = "ApplicationName";
    @NotNull
    public static final String APP_TARGET_SDK = "ApplicationTargetSdk";
    @NotNull
    public static final String APP_VERSION = "ApplicationVersion";

    private final String getAppName(Context context) {
        return ((Object)context.getPackageManager().getApplicationLabel(context.getApplicationInfo())).toString();
    }

    @SuppressLint(value={"WrongConstant"})
    private final String getAppVersion(Context context) {
        String string;
        try {
            string = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.i((String)TAG, (String)"Unable to get app version. Provided package name could not be found.");
            string = "";
        }
        return string;
    }

    private final String getAppTargetSdk(Context context) {
        return String.valueOf(context.getApplicationInfo().targetSdkVersion);
    }

    @Override
    @NotNull
    public Map<String, String> collect(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)APP_NAME, (Object)this.getAppName(context)), TuplesKt.to((Object)APP_TARGET_SDK, (Object)this.getAppTargetSdk(context)), TuplesKt.to((Object)APP_VERSION, (Object)this.getAppVersion(context))};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \n*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/amplifyframework/auth/cognito/asf/ApplicationDataCollector$Companion;", "", "()V", "ALL_FLAGS_OFF", "", "APP_NAME", "", "APP_TARGET_SDK", "APP_VERSION", "TAG", "kotlin.jvm.PlatformType", "aws-auth-cognito_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

